package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Processstage;
import microsoft.dynamics.crm.entity.collection.request.AccountCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ContactCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExpiredprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FaxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LetterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.NewprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PhonecallCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcessstageparameterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TaskCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TranslationprocessCollectionRequest;

@JsonIgnoreType
public class ProcessstageRequest extends EntityRequest<Processstage> {

    public ProcessstageRequest(ContextPath contextPath, Optional<Object> value) {
        super(Processstage.class, contextPath, value);
    }

    public KnowledgearticleCollectionRequest processstage_knowledgearticle() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("processstage_knowledgearticle"), Optional.empty());
    }

    public KnowledgearticleRequest processstage_knowledgearticle(String knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("processstage_knowledgearticle").addKeys(new NameValue(knowledgearticleid.toString())), Optional.empty());
    }

    public ContactCollectionRequest processstage_contact() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("processstage_contact"), Optional.empty());
    }

    public ContactRequest processstage_contact(String contactid) {
        return new ContactRequest(contextPath.addSegment("processstage_contact").addKeys(new NameValue(contactid.toString())), Optional.empty());
    }

    public FaxCollectionRequest processstage_faxes() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("processstage_faxes"), Optional.empty());
    }

    public FaxRequest processstage_faxes(String activityid) {
        return new FaxRequest(contextPath.addSegment("processstage_faxes").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public TeamCollectionRequest processstage_teams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("processstage_teams"), Optional.empty());
    }

    public TeamRequest processstage_teams(String ownerid) {
        return new TeamRequest(contextPath.addSegment("processstage_teams").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest processStage_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ProcessStage_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest processStage_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ProcessStage_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public LetterCollectionRequest processstage_letters() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("processstage_letters"), Optional.empty());
    }

    public LetterRequest processstage_letters(String activityid) {
        return new LetterRequest(contextPath.addSegment("processstage_letters").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AppointmentCollectionRequest processstage_appointments() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("processstage_appointments"), Optional.empty());
    }

    public AppointmentRequest processstage_appointments(String activityid) {
        return new AppointmentRequest(contextPath.addSegment("processstage_appointments").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public ExpiredprocessCollectionRequest processstage_expiredprocess() {
        return new ExpiredprocessCollectionRequest(
                        contextPath.addSegment("processstage_expiredprocess"), Optional.empty());
    }

    public ExpiredprocessRequest processstage_expiredprocess(String businessprocessflowinstanceid) {
        return new ExpiredprocessRequest(contextPath.addSegment("processstage_expiredprocess").addKeys(new NameValue(businessprocessflowinstanceid.toString())), Optional.empty());
    }

    public TaskCollectionRequest processstage_tasks() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("processstage_tasks"), Optional.empty());
    }

    public TaskRequest processstage_tasks(String activityid) {
        return new TaskRequest(contextPath.addSegment("processstage_tasks").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public NewprocessCollectionRequest processstage_newprocess() {
        return new NewprocessCollectionRequest(
                        contextPath.addSegment("processstage_newprocess"), Optional.empty());
    }

    public NewprocessRequest processstage_newprocess(String businessprocessflowinstanceid) {
        return new NewprocessRequest(contextPath.addSegment("processstage_newprocess").addKeys(new NameValue(businessprocessflowinstanceid.toString())), Optional.empty());
    }

    public PhonecallCollectionRequest processstage_phonecalls() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("processstage_phonecalls"), Optional.empty());
    }

    public PhonecallRequest processstage_phonecalls(String activityid) {
        return new PhonecallRequest(contextPath.addSegment("processstage_phonecalls").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest processstage_recurringappointmentmasters() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("processstage_recurringappointmentmasters"), Optional.empty());
    }

    public RecurringappointmentmasterRequest processstage_recurringappointmentmasters(String activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("processstage_recurringappointmentmasters").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public SystemuserCollectionRequest processstage_systemusers() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("processstage_systemusers"), Optional.empty());
    }

    public SystemuserRequest processstage_systemusers(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("processstage_systemusers").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public WorkflowRequest processid() {
        return new WorkflowRequest(contextPath.addSegment("processid"), Optional.empty());
    }

    public EmailCollectionRequest processstage_emails() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("processstage_emails"), Optional.empty());
    }

    public EmailRequest processstage_emails(String activityid) {
        return new EmailRequest(contextPath.addSegment("processstage_emails").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public TranslationprocessCollectionRequest processstage_translationprocess() {
        return new TranslationprocessCollectionRequest(
                        contextPath.addSegment("processstage_translationprocess"), Optional.empty());
    }

    public TranslationprocessRequest processstage_translationprocess(String businessprocessflowinstanceid) {
        return new TranslationprocessRequest(contextPath.addSegment("processstage_translationprocess").addKeys(new NameValue(businessprocessflowinstanceid.toString())), Optional.empty());
    }

    public AccountCollectionRequest processstage_account() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("processstage_account"), Optional.empty());
    }

    public AccountRequest processstage_account(String accountid) {
        return new AccountRequest(contextPath.addSegment("processstage_account").addKeys(new NameValue(accountid.toString())), Optional.empty());
    }

    public ProcessstageparameterCollectionRequest processstage_processstageparameter() {
        return new ProcessstageparameterCollectionRequest(
                        contextPath.addSegment("processstage_processstageparameter"), Optional.empty());
    }

    public ProcessstageparameterRequest processstage_processstageparameter(String processstageparameterid) {
        return new ProcessstageparameterRequest(contextPath.addSegment("processstage_processstageparameter").addKeys(new NameValue(processstageparameterid.toString())), Optional.empty());
    }

}
