package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Privilege;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoletemplateCollectionRequest;

@JsonIgnoreType
public class PrivilegeRequest extends EntityRequest<Privilege> {

    public PrivilegeRequest(ContextPath contextPath, Optional<Object> value) {
        super(Privilege.class, contextPath, value);
    }

    public RoletemplateCollectionRequest roletemplateprivileges_association() {
        return new RoletemplateCollectionRequest(
                        contextPath.addSegment("roletemplateprivileges_association"), Optional.empty());
    }

    public RoletemplateRequest roletemplateprivileges_association(String roletemplateid) {
        return new RoletemplateRequest(contextPath.addSegment("roletemplateprivileges_association").addKeys(new NameValue(roletemplateid.toString())), Optional.empty());
    }

    public RoleCollectionRequest roleprivileges_association() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("roleprivileges_association"), Optional.empty());
    }

    public RoleRequest roleprivileges_association(String roleid) {
        return new RoleRequest(contextPath.addSegment("roleprivileges_association").addKeys(new NameValue(roleid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest privilege_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Privilege_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest privilege_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Privilege_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest privilege_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Privilege_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest privilege_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Privilege_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public SolutionRequest solution_privilege() {
        return new SolutionRequest(contextPath.addSegment("solution_privilege"), Optional.empty());
    }

}
