package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Roletemplate;
import microsoft.dynamics.crm.entity.request.PrivilegeRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.RoletemplateRequest;

public class RoletemplateCollectionRequest extends CollectionPageEntityRequest<Roletemplate, RoletemplateRequest>{

    protected ContextPath contextPath;

    public RoletemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Roletemplate.class, cp -> new RoletemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PrivilegeCollectionRequest roletemplateprivileges_association() {
        return new PrivilegeCollectionRequest(contextPath.addSegment("roletemplateprivileges_association"), Optional.empty());
    }

    public PrivilegeRequest roletemplateprivileges_association(String privilegeid) {
        return new PrivilegeRequest(contextPath.addSegment("roletemplateprivileges_association").addKeys(new NameValue(privilegeid.toString())), Optional.empty());
    }

    public RoleCollectionRequest role_template_roles() {
        return new RoleCollectionRequest(contextPath.addSegment("role_template_roles"), Optional.empty());
    }

    public RoleRequest role_template_roles(String roleid) {
        return new RoleRequest(contextPath.addSegment("role_template_roles").addKeys(new NameValue(roleid.toString())), Optional.empty());
    }

}
