package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Msdyn_knowledgearticletemplate;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticletemplateRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class Msdyn_knowledgearticletemplateCollectionRequest extends CollectionPageEntityRequest<Msdyn_knowledgearticletemplate, Msdyn_knowledgearticletemplateRequest>{

    protected ContextPath contextPath;

    public Msdyn_knowledgearticletemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Msdyn_knowledgearticletemplate.class, cp -> new Msdyn_knowledgearticletemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest msdyn_knowledgearticletemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest msdyn_knowledgearticletemplate_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_knowledgearticletemplate_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_knowledgearticletemplate_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest msdyn_knowledgearticletemplate_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest msdyn_knowledgearticletemplate_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest msdyn_knowledgearticletemplate_SharePointDocumentLocations() {
        return new SharepointdocumentlocationCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_SharePointDocumentLocations"), Optional.empty());
    }

    public SharepointdocumentlocationRequest msdyn_knowledgearticletemplate_SharePointDocumentLocations(String sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_SharePointDocumentLocations").addKeys(new NameValue(sharepointdocumentlocationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest msdyn_knowledgearticletemplate_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest msdyn_knowledgearticletemplate_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest msdyn_knowledgearticletemplate_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest msdyn_knowledgearticletemplate_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest msdyn_knowledgearticletemplate_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest msdyn_knowledgearticletemplate_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest msdyn_knowledgearticletemplate_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest msdyn_knowledgearticletemplate_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest msdyn_knowledgearticletemplate_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest msdyn_knowledgearticletemplate_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public QueueitemCollectionRequest msdyn_knowledgearticletemplate_QueueItems() {
        return new QueueitemCollectionRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_QueueItems"), Optional.empty());
    }

    public QueueitemRequest msdyn_knowledgearticletemplate_QueueItems(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("msdyn_knowledgearticletemplate_QueueItems").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

}
