package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Attributeimageconfig;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.AttributeimageconfigRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class AttributeimageconfigCollectionRequest extends CollectionPageEntityRequest<Attributeimageconfig, AttributeimageconfigRequest>{

    protected ContextPath contextPath;

    public AttributeimageconfigCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Attributeimageconfig.class, cp -> new AttributeimageconfigRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest attributeimageconfig_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("attributeimageconfig_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest attributeimageconfig_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("attributeimageconfig_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest attributeimageconfig_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("attributeimageconfig_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest attributeimageconfig_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("attributeimageconfig_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest attributeimageconfig_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("attributeimageconfig_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest attributeimageconfig_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("attributeimageconfig_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest attributeimageconfig_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("attributeimageconfig_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest attributeimageconfig_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("attributeimageconfig_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest attributeimageconfig_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("attributeimageconfig_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest attributeimageconfig_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("attributeimageconfig_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

}
