package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.TimezonelocalizednameCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TimezoneruleCollectionRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "timezonecode", 
    "versionnumber", 
    "userinterfacename", 
    "bias", 
    "retiredorder", 
    "modifiedon", 
    "_createdonbehalfby_value", 
    "createdon", 
    "standardname", 
    "daylightname", 
    "_createdby_value", 
    "timezonedefinitionid", 
    "_modifiedby_value", 
    "_organizationid_value", 
    "_modifiedonbehalfby_value"})
@JsonInclude(Include.NON_NULL)
public class Timezonedefinition extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.timezonedefinition";
    }

    @JsonProperty("timezonecode")
    protected Integer timezonecode;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("userinterfacename")
    protected String userinterfacename;

    @JsonProperty("bias")
    protected Integer bias;

    @JsonProperty("retiredorder")
    protected Integer retiredorder;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("standardname")
    protected String standardname;

    @JsonProperty("daylightname")
    protected String daylightname;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("timezonedefinitionid")
    protected String timezonedefinitionid;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    protected Timezonedefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTimezonedefinition() {
        return new Builder();
    }

    public static final class Builder {
        private Integer timezonecode;
        private Long versionnumber;
        private String userinterfacename;
        private Integer bias;
        private Integer retiredorder;
        private OffsetDateTime modifiedon;
        private String _createdonbehalfby_value;
        private OffsetDateTime createdon;
        private String standardname;
        private String daylightname;
        private String _createdby_value;
        private String timezonedefinitionid;
        private String _modifiedby_value;
        private String _organizationid_value;
        private String _modifiedonbehalfby_value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder timezonecode(Integer timezonecode) {
            this.timezonecode = timezonecode;
            this.changedFields = changedFields.add("timezonecode");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder userinterfacename(String userinterfacename) {
            this.userinterfacename = userinterfacename;
            this.changedFields = changedFields.add("userinterfacename");
            return this;
        }

        public Builder bias(Integer bias) {
            this.bias = bias;
            this.changedFields = changedFields.add("bias");
            return this;
        }

        public Builder retiredorder(Integer retiredorder) {
            this.retiredorder = retiredorder;
            this.changedFields = changedFields.add("retiredorder");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder standardname(String standardname) {
            this.standardname = standardname;
            this.changedFields = changedFields.add("standardname");
            return this;
        }

        public Builder daylightname(String daylightname) {
            this.daylightname = daylightname;
            this.changedFields = changedFields.add("daylightname");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder timezonedefinitionid(String timezonedefinitionid) {
            this.timezonedefinitionid = timezonedefinitionid;
            this.changedFields = changedFields.add("timezonedefinitionid");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Timezonedefinition build() {
            Timezonedefinition _x = new Timezonedefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.timezonedefinition";
            _x.timezonecode = timezonecode;
            _x.versionnumber = versionnumber;
            _x.userinterfacename = userinterfacename;
            _x.bias = bias;
            _x.retiredorder = retiredorder;
            _x.modifiedon = modifiedon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.createdon = createdon;
            _x.standardname = standardname;
            _x.daylightname = daylightname;
            _x._createdby_value = _createdby_value;
            _x.timezonedefinitionid = timezonedefinitionid;
            _x._modifiedby_value = _modifiedby_value;
            _x._organizationid_value = _organizationid_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && timezonedefinitionid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(timezonedefinitionid.toString()));
        }
    }

    @Property(name="timezonecode")
    @JsonIgnore
    public Optional<Integer> getTimezonecode() {
        return Optional.ofNullable(timezonecode);
    }

    public Timezonedefinition withTimezonecode(Integer timezonecode) {
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("timezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x.timezonecode = timezonecode;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Timezonedefinition withVersionnumber(Long versionnumber) {
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="userinterfacename")
    @JsonIgnore
    public Optional<String> getUserinterfacename() {
        return Optional.ofNullable(userinterfacename);
    }

    public Timezonedefinition withUserinterfacename(String userinterfacename) {
        Checks.checkIsAscii(userinterfacename);
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("userinterfacename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x.userinterfacename = userinterfacename;
        return _x;
    }

    @Property(name="bias")
    @JsonIgnore
    public Optional<Integer> getBias() {
        return Optional.ofNullable(bias);
    }

    public Timezonedefinition withBias(Integer bias) {
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("bias");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x.bias = bias;
        return _x;
    }

    @Property(name="retiredorder")
    @JsonIgnore
    public Optional<Integer> getRetiredorder() {
        return Optional.ofNullable(retiredorder);
    }

    public Timezonedefinition withRetiredorder(Integer retiredorder) {
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("retiredorder");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x.retiredorder = retiredorder;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Timezonedefinition withModifiedon(OffsetDateTime modifiedon) {
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Timezonedefinition with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Timezonedefinition withCreatedon(OffsetDateTime createdon) {
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="standardname")
    @JsonIgnore
    public Optional<String> getStandardname() {
        return Optional.ofNullable(standardname);
    }

    public Timezonedefinition withStandardname(String standardname) {
        Checks.checkIsAscii(standardname);
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("standardname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x.standardname = standardname;
        return _x;
    }

    @Property(name="daylightname")
    @JsonIgnore
    public Optional<String> getDaylightname() {
        return Optional.ofNullable(daylightname);
    }

    public Timezonedefinition withDaylightname(String daylightname) {
        Checks.checkIsAscii(daylightname);
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("daylightname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x.daylightname = daylightname;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Timezonedefinition with_createdby_value(String _createdby_value) {
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="timezonedefinitionid")
    @JsonIgnore
    public Optional<String> getTimezonedefinitionid() {
        return Optional.ofNullable(timezonedefinitionid);
    }

    public Timezonedefinition withTimezonedefinitionid(String timezonedefinitionid) {
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("timezonedefinitionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x.timezonedefinitionid = timezonedefinitionid;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Timezonedefinition with_modifiedby_value(String _modifiedby_value) {
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Timezonedefinition with_organizationid_value(String _organizationid_value) {
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Timezonedefinition with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Timezonedefinition _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.timezonedefinition");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    public Timezonedefinition withUnmappedField(String name, String value) {
        Timezonedefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="lk_timezonelocalizedname_timezonedefinitionid")
    @JsonIgnore
    public TimezonelocalizednameCollectionRequest getLk_timezonelocalizedname_timezonedefinitionid() {
        return new TimezonelocalizednameCollectionRequest(
                        contextPath.addSegment("lk_timezonelocalizedname_timezonedefinitionid"), RequestHelper.getValue(unmappedFields, "lk_timezonelocalizedname_timezonedefinitionid"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="lk_timezonerule_timezonedefinitionid")
    @JsonIgnore
    public TimezoneruleCollectionRequest getLk_timezonerule_timezonedefinitionid() {
        return new TimezoneruleCollectionRequest(
                        contextPath.addSegment("lk_timezonerule_timezonedefinitionid"), RequestHelper.getValue(unmappedFields, "lk_timezonerule_timezonedefinitionid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Timezonedefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Timezonedefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Timezonedefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Timezonedefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Timezonedefinition _copy() {
        Timezonedefinition _x = new Timezonedefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.timezonecode = timezonecode;
        _x.versionnumber = versionnumber;
        _x.userinterfacename = userinterfacename;
        _x.bias = bias;
        _x.retiredorder = retiredorder;
        _x.modifiedon = modifiedon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.createdon = createdon;
        _x.standardname = standardname;
        _x.daylightname = daylightname;
        _x._createdby_value = _createdby_value;
        _x.timezonedefinitionid = timezonedefinitionid;
        _x._modifiedby_value = _modifiedby_value;
        _x._organizationid_value = _organizationid_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Timezonedefinition[");
        b.append("timezonecode=");
        b.append(this.timezonecode);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("userinterfacename=");
        b.append(this.userinterfacename);
        b.append(", ");
        b.append("bias=");
        b.append(this.bias);
        b.append(", ");
        b.append("retiredorder=");
        b.append(this.retiredorder);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("standardname=");
        b.append(this.standardname);
        b.append(", ");
        b.append("daylightname=");
        b.append(this.daylightname);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("timezonedefinitionid=");
        b.append(this.timezonedefinitionid);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
