package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.RetrieveAbsoluteAndSiteCollectionUrlResponse;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointsiteCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SharepointsiteRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "statecode", 
    "_modifiedby_value", 
    "validationstatus", 
    "_modifiedonbehalfby_value", 
    "_owninguser_value", 
    "overriddencreatedon", 
    "name", 
    "_createdonbehalfby_value", 
    "_parentsite_value", 
    "statuscode", 
    "absoluteurl", 
    "validationstatuserrorcode", 
    "_ownerid_value", 
    "isdefault", 
    "servicetype", 
    "_createdby_value", 
    "_owningteam_value", 
    "_transactioncurrencyid_value", 
    "sitecollectionid", 
    "relativeurl", 
    "createdon", 
    "utcconversiontimezonecode", 
    "_owningbusinessunit_value", 
    "description", 
    "lastvalidated", 
    "timezoneruleversionnumber", 
    "userid", 
    "ispowerbisite", 
    "exchangerate", 
    "versionnumber", 
    "isgridpresent", 
    "sharepointsiteid", 
    "importsequencenumber", 
    "folderstructureentity", 
    "modifiedon"})
@JsonInclude(Include.NON_NULL)
public class Sharepointsite extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.sharepointsite";
    }

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("validationstatus")
    protected Integer validationstatus;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_parentsite_value")
    protected String _parentsite_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("absoluteurl")
    protected String absoluteurl;

    @JsonProperty("validationstatuserrorcode")
    protected Integer validationstatuserrorcode;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("isdefault")
    protected Boolean isdefault;

    @JsonProperty("servicetype")
    protected Integer servicetype;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    @JsonProperty("sitecollectionid")
    protected String sitecollectionid;

    @JsonProperty("relativeurl")
    protected String relativeurl;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("lastvalidated")
    protected OffsetDateTime lastvalidated;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("userid")
    protected String userid;

    @JsonProperty("ispowerbisite")
    protected Boolean ispowerbisite;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("isgridpresent")
    protected Boolean isgridpresent;

    @JsonProperty("sharepointsiteid")
    protected String sharepointsiteid;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("folderstructureentity")
    protected String folderstructureentity;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    protected Sharepointsite() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSharepointsite() {
        return new Builder();
    }

    public static final class Builder {
        private Integer statecode;
        private String _modifiedby_value;
        private Integer validationstatus;
        private String _modifiedonbehalfby_value;
        private String _owninguser_value;
        private OffsetDateTime overriddencreatedon;
        private String name;
        private String _createdonbehalfby_value;
        private String _parentsite_value;
        private Integer statuscode;
        private String absoluteurl;
        private Integer validationstatuserrorcode;
        private String _ownerid_value;
        private Boolean isdefault;
        private Integer servicetype;
        private String _createdby_value;
        private String _owningteam_value;
        private String _transactioncurrencyid_value;
        private String sitecollectionid;
        private String relativeurl;
        private OffsetDateTime createdon;
        private Integer utcconversiontimezonecode;
        private String _owningbusinessunit_value;
        private String description;
        private OffsetDateTime lastvalidated;
        private Integer timezoneruleversionnumber;
        private String userid;
        private Boolean ispowerbisite;
        private BigDecimal exchangerate;
        private Long versionnumber;
        private Boolean isgridpresent;
        private String sharepointsiteid;
        private Integer importsequencenumber;
        private String folderstructureentity;
        private OffsetDateTime modifiedon;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder validationstatus(Integer validationstatus) {
            this.validationstatus = validationstatus;
            this.changedFields = changedFields.add("validationstatus");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _parentsite_value(String _parentsite_value) {
            this._parentsite_value = _parentsite_value;
            this.changedFields = changedFields.add("_parentsite_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder absoluteurl(String absoluteurl) {
            this.absoluteurl = absoluteurl;
            this.changedFields = changedFields.add("absoluteurl");
            return this;
        }

        public Builder validationstatuserrorcode(Integer validationstatuserrorcode) {
            this.validationstatuserrorcode = validationstatuserrorcode;
            this.changedFields = changedFields.add("validationstatuserrorcode");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder isdefault(Boolean isdefault) {
            this.isdefault = isdefault;
            this.changedFields = changedFields.add("isdefault");
            return this;
        }

        public Builder servicetype(Integer servicetype) {
            this.servicetype = servicetype;
            this.changedFields = changedFields.add("servicetype");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder sitecollectionid(String sitecollectionid) {
            this.sitecollectionid = sitecollectionid;
            this.changedFields = changedFields.add("sitecollectionid");
            return this;
        }

        public Builder relativeurl(String relativeurl) {
            this.relativeurl = relativeurl;
            this.changedFields = changedFields.add("relativeurl");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder lastvalidated(OffsetDateTime lastvalidated) {
            this.lastvalidated = lastvalidated;
            this.changedFields = changedFields.add("lastvalidated");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder userid(String userid) {
            this.userid = userid;
            this.changedFields = changedFields.add("userid");
            return this;
        }

        public Builder ispowerbisite(Boolean ispowerbisite) {
            this.ispowerbisite = ispowerbisite;
            this.changedFields = changedFields.add("ispowerbisite");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder isgridpresent(Boolean isgridpresent) {
            this.isgridpresent = isgridpresent;
            this.changedFields = changedFields.add("isgridpresent");
            return this;
        }

        public Builder sharepointsiteid(String sharepointsiteid) {
            this.sharepointsiteid = sharepointsiteid;
            this.changedFields = changedFields.add("sharepointsiteid");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder folderstructureentity(String folderstructureentity) {
            this.folderstructureentity = folderstructureentity;
            this.changedFields = changedFields.add("folderstructureentity");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Sharepointsite build() {
            Sharepointsite _x = new Sharepointsite();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.sharepointsite";
            _x.statecode = statecode;
            _x._modifiedby_value = _modifiedby_value;
            _x.validationstatus = validationstatus;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._owninguser_value = _owninguser_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.name = name;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._parentsite_value = _parentsite_value;
            _x.statuscode = statuscode;
            _x.absoluteurl = absoluteurl;
            _x.validationstatuserrorcode = validationstatuserrorcode;
            _x._ownerid_value = _ownerid_value;
            _x.isdefault = isdefault;
            _x.servicetype = servicetype;
            _x._createdby_value = _createdby_value;
            _x._owningteam_value = _owningteam_value;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.sitecollectionid = sitecollectionid;
            _x.relativeurl = relativeurl;
            _x.createdon = createdon;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.description = description;
            _x.lastvalidated = lastvalidated;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.userid = userid;
            _x.ispowerbisite = ispowerbisite;
            _x.exchangerate = exchangerate;
            _x.versionnumber = versionnumber;
            _x.isgridpresent = isgridpresent;
            _x.sharepointsiteid = sharepointsiteid;
            _x.importsequencenumber = importsequencenumber;
            _x.folderstructureentity = folderstructureentity;
            _x.modifiedon = modifiedon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && sharepointsiteid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(sharepointsiteid.toString()));
        }
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Sharepointsite withStatecode(Integer statecode) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Sharepointsite with_modifiedby_value(String _modifiedby_value) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="validationstatus")
    @JsonIgnore
    public Optional<Integer> getValidationstatus() {
        return Optional.ofNullable(validationstatus);
    }

    public Sharepointsite withValidationstatus(Integer validationstatus) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("validationstatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.validationstatus = validationstatus;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Sharepointsite with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Sharepointsite with_owninguser_value(String _owninguser_value) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Sharepointsite withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Sharepointsite withName(String name) {
        Checks.checkIsAscii(name);
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.name = name;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Sharepointsite with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_parentsite_value")
    @JsonIgnore
    public Optional<String> get_parentsite_value() {
        return Optional.ofNullable(_parentsite_value);
    }

    public Sharepointsite with_parentsite_value(String _parentsite_value) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("_parentsite_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x._parentsite_value = _parentsite_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Sharepointsite withStatuscode(Integer statuscode) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="absoluteurl")
    @JsonIgnore
    public Optional<String> getAbsoluteurl() {
        return Optional.ofNullable(absoluteurl);
    }

    public Sharepointsite withAbsoluteurl(String absoluteurl) {
        Checks.checkIsAscii(absoluteurl);
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("absoluteurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.absoluteurl = absoluteurl;
        return _x;
    }

    @Property(name="validationstatuserrorcode")
    @JsonIgnore
    public Optional<Integer> getValidationstatuserrorcode() {
        return Optional.ofNullable(validationstatuserrorcode);
    }

    public Sharepointsite withValidationstatuserrorcode(Integer validationstatuserrorcode) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("validationstatuserrorcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.validationstatuserrorcode = validationstatuserrorcode;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Sharepointsite with_ownerid_value(String _ownerid_value) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="isdefault")
    @JsonIgnore
    public Optional<Boolean> getIsdefault() {
        return Optional.ofNullable(isdefault);
    }

    public Sharepointsite withIsdefault(Boolean isdefault) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("isdefault");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.isdefault = isdefault;
        return _x;
    }

    @Property(name="servicetype")
    @JsonIgnore
    public Optional<Integer> getServicetype() {
        return Optional.ofNullable(servicetype);
    }

    public Sharepointsite withServicetype(Integer servicetype) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("servicetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.servicetype = servicetype;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Sharepointsite with_createdby_value(String _createdby_value) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Sharepointsite with_owningteam_value(String _owningteam_value) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Sharepointsite with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="sitecollectionid")
    @JsonIgnore
    public Optional<String> getSitecollectionid() {
        return Optional.ofNullable(sitecollectionid);
    }

    public Sharepointsite withSitecollectionid(String sitecollectionid) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("sitecollectionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.sitecollectionid = sitecollectionid;
        return _x;
    }

    @Property(name="relativeurl")
    @JsonIgnore
    public Optional<String> getRelativeurl() {
        return Optional.ofNullable(relativeurl);
    }

    public Sharepointsite withRelativeurl(String relativeurl) {
        Checks.checkIsAscii(relativeurl);
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("relativeurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.relativeurl = relativeurl;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Sharepointsite withCreatedon(OffsetDateTime createdon) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Sharepointsite withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Sharepointsite with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Sharepointsite withDescription(String description) {
        Checks.checkIsAscii(description);
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.description = description;
        return _x;
    }

    @Property(name="lastvalidated")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastvalidated() {
        return Optional.ofNullable(lastvalidated);
    }

    public Sharepointsite withLastvalidated(OffsetDateTime lastvalidated) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("lastvalidated");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.lastvalidated = lastvalidated;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Sharepointsite withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="userid")
    @JsonIgnore
    public Optional<String> getUserid() {
        return Optional.ofNullable(userid);
    }

    public Sharepointsite withUserid(String userid) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("userid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.userid = userid;
        return _x;
    }

    @Property(name="ispowerbisite")
    @JsonIgnore
    public Optional<Boolean> getIspowerbisite() {
        return Optional.ofNullable(ispowerbisite);
    }

    public Sharepointsite withIspowerbisite(Boolean ispowerbisite) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("ispowerbisite");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.ispowerbisite = ispowerbisite;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Sharepointsite withExchangerate(BigDecimal exchangerate) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Sharepointsite withVersionnumber(Long versionnumber) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="isgridpresent")
    @JsonIgnore
    public Optional<Boolean> getIsgridpresent() {
        return Optional.ofNullable(isgridpresent);
    }

    public Sharepointsite withIsgridpresent(Boolean isgridpresent) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("isgridpresent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.isgridpresent = isgridpresent;
        return _x;
    }

    @Property(name="sharepointsiteid")
    @JsonIgnore
    public Optional<String> getSharepointsiteid() {
        return Optional.ofNullable(sharepointsiteid);
    }

    public Sharepointsite withSharepointsiteid(String sharepointsiteid) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("sharepointsiteid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.sharepointsiteid = sharepointsiteid;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Sharepointsite withImportsequencenumber(Integer importsequencenumber) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="folderstructureentity")
    @JsonIgnore
    public Optional<String> getFolderstructureentity() {
        return Optional.ofNullable(folderstructureentity);
    }

    public Sharepointsite withFolderstructureentity(String folderstructureentity) {
        Checks.checkIsAscii(folderstructureentity);
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("folderstructureentity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.folderstructureentity = folderstructureentity;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Sharepointsite withModifiedon(OffsetDateTime modifiedon) {
        Sharepointsite _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointsite");
        _x.modifiedon = modifiedon;
        return _x;
    }

    public Sharepointsite withUnmappedField(String name, String value) {
        Sharepointsite _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="SharePointSite_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getSharePointSite_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("SharePointSite_ProcessSessions"), RequestHelper.getValue(unmappedFields, "SharePointSite_ProcessSessions"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="SharePointSite_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getSharePointSite_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SharePointSite_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "SharePointSite_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="parentsite")
    @JsonIgnore
    public SharepointsiteRequest getParentsite() {
        return new SharepointsiteRequest(contextPath.addSegment("parentsite"), RequestHelper.getValue(unmappedFields, "parentsite"));
    }

    @NavigationProperty(name="sharepointsite_parentsite_sharepointsite")
    @JsonIgnore
    public SharepointsiteCollectionRequest getSharepointsite_parentsite_sharepointsite() {
        return new SharepointsiteCollectionRequest(
                        contextPath.addSegment("sharepointsite_parentsite_sharepointsite"), RequestHelper.getValue(unmappedFields, "sharepointsite_parentsite_sharepointsite"));
    }

    @NavigationProperty(name="sharepointsite_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getSharepointsite_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("sharepointsite_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "sharepointsite_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="SharePointSite_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getSharePointSite_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SharePointSite_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "SharePointSite_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="sharepointdocumentlocation_parent_sharepointsite")
    @JsonIgnore
    public SharepointdocumentlocationCollectionRequest getSharepointdocumentlocation_parent_sharepointsite() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("sharepointdocumentlocation_parent_sharepointsite"), RequestHelper.getValue(unmappedFields, "sharepointdocumentlocation_parent_sharepointsite"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="SharePointSite_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getSharePointSite_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SharePointSite_AsyncOperations"), RequestHelper.getValue(unmappedFields, "SharePointSite_AsyncOperations"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="SharePointSite_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getSharePointSite_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SharePointSite_SyncErrors"), RequestHelper.getValue(unmappedFields, "SharePointSite_SyncErrors"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sharepointsite patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Sharepointsite _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sharepointsite put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Sharepointsite _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Sharepointsite _copy() {
        Sharepointsite _x = new Sharepointsite();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.statecode = statecode;
        _x._modifiedby_value = _modifiedby_value;
        _x.validationstatus = validationstatus;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._owninguser_value = _owninguser_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.name = name;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._parentsite_value = _parentsite_value;
        _x.statuscode = statuscode;
        _x.absoluteurl = absoluteurl;
        _x.validationstatuserrorcode = validationstatuserrorcode;
        _x._ownerid_value = _ownerid_value;
        _x.isdefault = isdefault;
        _x.servicetype = servicetype;
        _x._createdby_value = _createdby_value;
        _x._owningteam_value = _owningteam_value;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.sitecollectionid = sitecollectionid;
        _x.relativeurl = relativeurl;
        _x.createdon = createdon;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.description = description;
        _x.lastvalidated = lastvalidated;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.userid = userid;
        _x.ispowerbisite = ispowerbisite;
        _x.exchangerate = exchangerate;
        _x.versionnumber = versionnumber;
        _x.isgridpresent = isgridpresent;
        _x.sharepointsiteid = sharepointsiteid;
        _x.importsequencenumber = importsequencenumber;
        _x.folderstructureentity = folderstructureentity;
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Function(name = "RetrieveAbsoluteAndSiteCollectionUrl")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAbsoluteAndSiteCollectionUrlResponse> retrieveAbsoluteAndSiteCollectionUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAbsoluteAndSiteCollectionUrlResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAbsoluteAndSiteCollectionUrl"), RetrieveAbsoluteAndSiteCollectionUrlResponse.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Sharepointsite[");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("validationstatus=");
        b.append(this.validationstatus);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_parentsite_value=");
        b.append(this._parentsite_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("absoluteurl=");
        b.append(this.absoluteurl);
        b.append(", ");
        b.append("validationstatuserrorcode=");
        b.append(this.validationstatuserrorcode);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("isdefault=");
        b.append(this.isdefault);
        b.append(", ");
        b.append("servicetype=");
        b.append(this.servicetype);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("sitecollectionid=");
        b.append(this.sitecollectionid);
        b.append(", ");
        b.append("relativeurl=");
        b.append(this.relativeurl);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("lastvalidated=");
        b.append(this.lastvalidated);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("userid=");
        b.append(this.userid);
        b.append(", ");
        b.append("ispowerbisite=");
        b.append(this.ispowerbisite);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("isgridpresent=");
        b.append(this.isgridpresent);
        b.append(", ");
        b.append("sharepointsiteid=");
        b.append(this.sharepointsiteid);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("folderstructureentity=");
        b.append(this.folderstructureentity);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
