package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PositionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PositionRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_createdonbehalfby_value", 
    "createdon", 
    "name", 
    "_modifiedby_value", 
    "_parentpositionid_value", 
    "exchangerate", 
    "_organizationid_value", 
    "_createdby_value", 
    "utcconversiontimezonecode", 
    "positionid", 
    "overriddencreatedon", 
    "statuscode", 
    "_transactioncurrencyid_value", 
    "versionnumber", 
    "description", 
    "statecode", 
    "_modifiedonbehalfby_value", 
    "timezoneruleversionnumber", 
    "modifiedon", 
    "importsequencenumber"})
@JsonInclude(Include.NON_NULL)
public class Position extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.position";
    }

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_parentpositionid_value")
    protected String _parentpositionid_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("positionid")
    protected String positionid;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    protected Position() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPosition() {
        return new Builder();
    }

    public static final class Builder {
        private String _createdonbehalfby_value;
        private OffsetDateTime createdon;
        private String name;
        private String _modifiedby_value;
        private String _parentpositionid_value;
        private BigDecimal exchangerate;
        private String _organizationid_value;
        private String _createdby_value;
        private Integer utcconversiontimezonecode;
        private String positionid;
        private OffsetDateTime overriddencreatedon;
        private Integer statuscode;
        private String _transactioncurrencyid_value;
        private Long versionnumber;
        private String description;
        private Integer statecode;
        private String _modifiedonbehalfby_value;
        private Integer timezoneruleversionnumber;
        private OffsetDateTime modifiedon;
        private Integer importsequencenumber;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _parentpositionid_value(String _parentpositionid_value) {
            this._parentpositionid_value = _parentpositionid_value;
            this.changedFields = changedFields.add("_parentpositionid_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder positionid(String positionid) {
            this.positionid = positionid;
            this.changedFields = changedFields.add("positionid");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Position build() {
            Position _x = new Position();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.position";
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.createdon = createdon;
            _x.name = name;
            _x._modifiedby_value = _modifiedby_value;
            _x._parentpositionid_value = _parentpositionid_value;
            _x.exchangerate = exchangerate;
            _x._organizationid_value = _organizationid_value;
            _x._createdby_value = _createdby_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.positionid = positionid;
            _x.overriddencreatedon = overriddencreatedon;
            _x.statuscode = statuscode;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.versionnumber = versionnumber;
            _x.description = description;
            _x.statecode = statecode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.modifiedon = modifiedon;
            _x.importsequencenumber = importsequencenumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && positionid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(positionid.toString()));
        }
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Position with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Position withCreatedon(OffsetDateTime createdon) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Position withName(String name) {
        Checks.checkIsAscii(name);
        Position _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.name = name;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Position with_modifiedby_value(String _modifiedby_value) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_parentpositionid_value")
    @JsonIgnore
    public Optional<String> get_parentpositionid_value() {
        return Optional.ofNullable(_parentpositionid_value);
    }

    public Position with_parentpositionid_value(String _parentpositionid_value) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("_parentpositionid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x._parentpositionid_value = _parentpositionid_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Position withExchangerate(BigDecimal exchangerate) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Position with_organizationid_value(String _organizationid_value) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Position with_createdby_value(String _createdby_value) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Position withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="positionid")
    @JsonIgnore
    public Optional<String> getPositionid() {
        return Optional.ofNullable(positionid);
    }

    public Position withPositionid(String positionid) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("positionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.positionid = positionid;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Position withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Position withStatuscode(Integer statuscode) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Position with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Position withVersionnumber(Long versionnumber) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Position withDescription(String description) {
        Checks.checkIsAscii(description);
        Position _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.description = description;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Position withStatecode(Integer statecode) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Position with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Position withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Position withModifiedon(OffsetDateTime modifiedon) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Position withImportsequencenumber(Integer importsequencenumber) {
        Position _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.position");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    public Position withUnmappedField(String name, String value) {
        Position _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="position_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getPosition_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("position_AsyncOperations"), RequestHelper.getValue(unmappedFields, "position_AsyncOperations"));
    }

    @NavigationProperty(name="position_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getPosition_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("position_ProcessSession"), RequestHelper.getValue(unmappedFields, "position_ProcessSession"));
    }

    @NavigationProperty(name="position_users")
    @JsonIgnore
    public SystemuserCollectionRequest getPosition_users() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("position_users"), RequestHelper.getValue(unmappedFields, "position_users"));
    }

    @NavigationProperty(name="parentpositionid")
    @JsonIgnore
    public PositionRequest getParentpositionid() {
        return new PositionRequest(contextPath.addSegment("parentpositionid"), RequestHelper.getValue(unmappedFields, "parentpositionid"));
    }

    @NavigationProperty(name="position_parent_position")
    @JsonIgnore
    public PositionCollectionRequest getPosition_parent_position() {
        return new PositionCollectionRequest(
                        contextPath.addSegment("position_parent_position"), RequestHelper.getValue(unmappedFields, "position_parent_position"));
    }

    @NavigationProperty(name="position_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getPosition_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("position_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "position_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="position_connection1")
    @JsonIgnore
    public ConnectionCollectionRequest getPosition_connection1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("position_connection1"), RequestHelper.getValue(unmappedFields, "position_connection1"));
    }

    @NavigationProperty(name="position_connection2")
    @JsonIgnore
    public ConnectionCollectionRequest getPosition_connection2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("position_connection2"), RequestHelper.getValue(unmappedFields, "position_connection2"));
    }

    @NavigationProperty(name="Position_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getPosition_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Position_SyncErrors"), RequestHelper.getValue(unmappedFields, "Position_SyncErrors"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Position patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Position _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Position put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Position _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Position _copy() {
        Position _x = new Position();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.createdon = createdon;
        _x.name = name;
        _x._modifiedby_value = _modifiedby_value;
        _x._parentpositionid_value = _parentpositionid_value;
        _x.exchangerate = exchangerate;
        _x._organizationid_value = _organizationid_value;
        _x._createdby_value = _createdby_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.positionid = positionid;
        _x.overriddencreatedon = overriddencreatedon;
        _x.statuscode = statuscode;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.versionnumber = versionnumber;
        _x.description = description;
        _x.statecode = statecode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.modifiedon = modifiedon;
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Position[");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_parentpositionid_value=");
        b.append(this._parentpositionid_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("positionid=");
        b.append(this.positionid);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
