package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodtrainingimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "statecode", 
    "timezoneruleversionnumber", 
    "msdyn_aiodimageid", 
    "utcconversiontimezonecode", 
    "statuscode", 
    "entityimage", 
    "msdyn_name", 
    "entityimageid", 
    "versionnumber", 
    "_createdby_value", 
    "_owninguser_value", 
    "createdon", 
    "_ownerid_value", 
    "importsequencenumber", 
    "_owningbusinessunit_value", 
    "_modifiedonbehalfby_value", 
    "entityimage_url", 
    "msdyn_metadata", 
    "entityimage_timestamp", 
    "_owningteam_value", 
    "modifiedon", 
    "msdyn_description", 
    "_createdonbehalfby_value", 
    "_modifiedby_value", 
    "overriddencreatedon", 
    "msdyn_checksum"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_aiodimage extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_aiodimage";
    }

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("msdyn_aiodimageid")
    protected String msdyn_aiodimageid;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("entityimage")
    protected byte[] entityimage;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("entityimageid")
    protected String entityimageid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("entityimage_url")
    protected String entityimage_url;

    @JsonProperty("msdyn_metadata")
    protected String msdyn_metadata;

    @JsonProperty("entityimage_timestamp")
    protected Long entityimage_timestamp;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("msdyn_description")
    protected String msdyn_description;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("msdyn_checksum")
    protected String msdyn_checksum;

    protected Msdyn_aiodimage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_aiodimage() {
        return new Builder();
    }

    public static final class Builder {
        private Integer statecode;
        private Integer timezoneruleversionnumber;
        private String msdyn_aiodimageid;
        private Integer utcconversiontimezonecode;
        private Integer statuscode;
        private byte[] entityimage;
        private String msdyn_name;
        private String entityimageid;
        private Long versionnumber;
        private String _createdby_value;
        private String _owninguser_value;
        private OffsetDateTime createdon;
        private String _ownerid_value;
        private Integer importsequencenumber;
        private String _owningbusinessunit_value;
        private String _modifiedonbehalfby_value;
        private String entityimage_url;
        private String msdyn_metadata;
        private Long entityimage_timestamp;
        private String _owningteam_value;
        private OffsetDateTime modifiedon;
        private String msdyn_description;
        private String _createdonbehalfby_value;
        private String _modifiedby_value;
        private OffsetDateTime overriddencreatedon;
        private String msdyn_checksum;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder msdyn_aiodimageid(String msdyn_aiodimageid) {
            this.msdyn_aiodimageid = msdyn_aiodimageid;
            this.changedFields = changedFields.add("msdyn_aiodimageid");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder entityimage(byte[] entityimage) {
            this.entityimage = entityimage;
            this.changedFields = changedFields.add("entityimage");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder entityimageid(String entityimageid) {
            this.entityimageid = entityimageid;
            this.changedFields = changedFields.add("entityimageid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder entityimage_url(String entityimage_url) {
            this.entityimage_url = entityimage_url;
            this.changedFields = changedFields.add("entityimage_url");
            return this;
        }

        public Builder msdyn_metadata(String msdyn_metadata) {
            this.msdyn_metadata = msdyn_metadata;
            this.changedFields = changedFields.add("msdyn_metadata");
            return this;
        }

        public Builder entityimage_timestamp(Long entityimage_timestamp) {
            this.entityimage_timestamp = entityimage_timestamp;
            this.changedFields = changedFields.add("entityimage_timestamp");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder msdyn_description(String msdyn_description) {
            this.msdyn_description = msdyn_description;
            this.changedFields = changedFields.add("msdyn_description");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder msdyn_checksum(String msdyn_checksum) {
            this.msdyn_checksum = msdyn_checksum;
            this.changedFields = changedFields.add("msdyn_checksum");
            return this;
        }

        public Msdyn_aiodimage build() {
            Msdyn_aiodimage _x = new Msdyn_aiodimage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_aiodimage";
            _x.statecode = statecode;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.msdyn_aiodimageid = msdyn_aiodimageid;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.statuscode = statuscode;
            _x.entityimage = entityimage;
            _x.msdyn_name = msdyn_name;
            _x.entityimageid = entityimageid;
            _x.versionnumber = versionnumber;
            _x._createdby_value = _createdby_value;
            _x._owninguser_value = _owninguser_value;
            _x.createdon = createdon;
            _x._ownerid_value = _ownerid_value;
            _x.importsequencenumber = importsequencenumber;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.entityimage_url = entityimage_url;
            _x.msdyn_metadata = msdyn_metadata;
            _x.entityimage_timestamp = entityimage_timestamp;
            _x._owningteam_value = _owningteam_value;
            _x.modifiedon = modifiedon;
            _x.msdyn_description = msdyn_description;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.msdyn_checksum = msdyn_checksum;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_aiodimageid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_aiodimageid.toString()));
        }
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_aiodimage withStatecode(Integer statecode) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_aiodimage withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="msdyn_aiodimageid")
    @JsonIgnore
    public Optional<String> getMsdyn_aiodimageid() {
        return Optional.ofNullable(msdyn_aiodimageid);
    }

    public Msdyn_aiodimage withMsdyn_aiodimageid(String msdyn_aiodimageid) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aiodimageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.msdyn_aiodimageid = msdyn_aiodimageid;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_aiodimage withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_aiodimage withStatuscode(Integer statuscode) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="entityimage")
    @JsonIgnore
    public Optional<byte[]> getEntityimage() {
        return Optional.ofNullable(entityimage);
    }

    public Msdyn_aiodimage withEntityimage(byte[] entityimage) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("entityimage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.entityimage = entityimage;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_aiodimage withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="entityimageid")
    @JsonIgnore
    public Optional<String> getEntityimageid() {
        return Optional.ofNullable(entityimageid);
    }

    public Msdyn_aiodimage withEntityimageid(String entityimageid) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("entityimageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.entityimageid = entityimageid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_aiodimage withVersionnumber(Long versionnumber) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_aiodimage with_createdby_value(String _createdby_value) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_aiodimage with_owninguser_value(String _owninguser_value) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_aiodimage withCreatedon(OffsetDateTime createdon) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_aiodimage with_ownerid_value(String _ownerid_value) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_aiodimage withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_aiodimage with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_aiodimage with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="entityimage_url")
    @JsonIgnore
    public Optional<String> getEntityimage_url() {
        return Optional.ofNullable(entityimage_url);
    }

    public Msdyn_aiodimage withEntityimage_url(String entityimage_url) {
        Checks.checkIsAscii(entityimage_url);
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("entityimage_url");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.entityimage_url = entityimage_url;
        return _x;
    }

    @Property(name="msdyn_metadata")
    @JsonIgnore
    public Optional<String> getMsdyn_metadata() {
        return Optional.ofNullable(msdyn_metadata);
    }

    public Msdyn_aiodimage withMsdyn_metadata(String msdyn_metadata) {
        Checks.checkIsAscii(msdyn_metadata);
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_metadata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.msdyn_metadata = msdyn_metadata;
        return _x;
    }

    @Property(name="entityimage_timestamp")
    @JsonIgnore
    public Optional<Long> getEntityimage_timestamp() {
        return Optional.ofNullable(entityimage_timestamp);
    }

    public Msdyn_aiodimage withEntityimage_timestamp(Long entityimage_timestamp) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("entityimage_timestamp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.entityimage_timestamp = entityimage_timestamp;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_aiodimage with_owningteam_value(String _owningteam_value) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_aiodimage withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="msdyn_description")
    @JsonIgnore
    public Optional<String> getMsdyn_description() {
        return Optional.ofNullable(msdyn_description);
    }

    public Msdyn_aiodimage withMsdyn_description(String msdyn_description) {
        Checks.checkIsAscii(msdyn_description);
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.msdyn_description = msdyn_description;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_aiodimage with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_aiodimage with_modifiedby_value(String _modifiedby_value) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_aiodimage withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="msdyn_checksum")
    @JsonIgnore
    public Optional<String> getMsdyn_checksum() {
        return Optional.ofNullable(msdyn_checksum);
    }

    public Msdyn_aiodimage withMsdyn_checksum(String msdyn_checksum) {
        Checks.checkIsAscii(msdyn_checksum);
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = changedFields.add("msdyn_checksum");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodimage");
        _x.msdyn_checksum = msdyn_checksum;
        return _x;
    }

    public Msdyn_aiodimage withUnmappedField(String name, String value) {
        Msdyn_aiodimage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_aiodimage_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_aiodimage_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_aiodimage_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_aiodimage_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_aiodimage_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_aiodimage_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_aiodimage_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_aiodimage_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_aiodimage_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_aiodimage_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_aiodimage_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_aiodimage_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_aiodimage_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_aiodimage_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_aiodimage_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_aiodimage_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_aiodimage_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_aiodimage_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_aiodimage_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_aiodimage_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_aiodimage_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_aiodimage_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_aiodimage_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_aiodimage_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_aiodimage_Annotations")
    @JsonIgnore
    public AnnotationCollectionRequest getMsdyn_aiodimage_Annotations() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_Annotations"), RequestHelper.getValue(unmappedFields, "msdyn_aiodimage_Annotations"));
    }

    @NavigationProperty(name="msdyn_aiodimage_msdyn_aiodtrainingimage")
    @JsonIgnore
    public Msdyn_aiodtrainingimageCollectionRequest getMsdyn_aiodimage_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageCollectionRequest(
                        contextPath.addSegment("msdyn_aiodimage_msdyn_aiodtrainingimage"), RequestHelper.getValue(unmappedFields, "msdyn_aiodimage_msdyn_aiodtrainingimage"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aiodimage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aiodimage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aiodimage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_aiodimage _copy() {
        Msdyn_aiodimage _x = new Msdyn_aiodimage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.statecode = statecode;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.msdyn_aiodimageid = msdyn_aiodimageid;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.statuscode = statuscode;
        _x.entityimage = entityimage;
        _x.msdyn_name = msdyn_name;
        _x.entityimageid = entityimageid;
        _x.versionnumber = versionnumber;
        _x._createdby_value = _createdby_value;
        _x._owninguser_value = _owninguser_value;
        _x.createdon = createdon;
        _x._ownerid_value = _ownerid_value;
        _x.importsequencenumber = importsequencenumber;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.entityimage_url = entityimage_url;
        _x.msdyn_metadata = msdyn_metadata;
        _x.entityimage_timestamp = entityimage_timestamp;
        _x._owningteam_value = _owningteam_value;
        _x.modifiedon = modifiedon;
        _x.msdyn_description = msdyn_description;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.msdyn_checksum = msdyn_checksum;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_aiodimage[");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("msdyn_aiodimageid=");
        b.append(this.msdyn_aiodimageid);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("entityimage=");
        b.append(this.entityimage);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("entityimageid=");
        b.append(this.entityimageid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("entityimage_url=");
        b.append(this.entityimage_url);
        b.append(", ");
        b.append("msdyn_metadata=");
        b.append(this.msdyn_metadata);
        b.append(", ");
        b.append("entityimage_timestamp=");
        b.append(this.entityimage_timestamp);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("msdyn_description=");
        b.append(this.msdyn_description);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("msdyn_checksum=");
        b.append(this.msdyn_checksum);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
