package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OrganizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_organizationid_value", 
    "versionnumber", 
    "mobileofflineprofileid", 
    "modifiedon", 
    "introducedversion", 
    "_createdonbehalfby_value", 
    "mobileofflineprofileidunique", 
    "_modifiedby_value", 
    "isvalidated", 
    "_modifiedonbehalfby_value", 
    "overwritetime", 
    "publishedon", 
    "processid", 
    "solutionid", 
    "description", 
    "createdon", 
    "_createdby_value", 
    "stageid", 
    "name", 
    "selectedentitymetadata", 
    "traversedpath", 
    "ismanaged", 
    "componentstate"})
@JsonInclude(Include.NON_NULL)
public class Mobileofflineprofile extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.mobileofflineprofile";
    }

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("mobileofflineprofileid")
    protected String mobileofflineprofileid;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("mobileofflineprofileidunique")
    protected String mobileofflineprofileidunique;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("isvalidated")
    protected Boolean isvalidated;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("publishedon")
    protected OffsetDateTime publishedon;

    @JsonProperty("processid")
    protected String processid;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("stageid")
    protected String stageid;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("selectedentitymetadata")
    protected String selectedentitymetadata;

    @JsonProperty("traversedpath")
    protected String traversedpath;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    protected Mobileofflineprofile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileofflineprofile() {
        return new Builder();
    }

    public static final class Builder {
        private String _organizationid_value;
        private Long versionnumber;
        private String mobileofflineprofileid;
        private OffsetDateTime modifiedon;
        private String introducedversion;
        private String _createdonbehalfby_value;
        private String mobileofflineprofileidunique;
        private String _modifiedby_value;
        private Boolean isvalidated;
        private String _modifiedonbehalfby_value;
        private OffsetDateTime overwritetime;
        private OffsetDateTime publishedon;
        private String processid;
        private String solutionid;
        private String description;
        private OffsetDateTime createdon;
        private String _createdby_value;
        private String stageid;
        private String name;
        private String selectedentitymetadata;
        private String traversedpath;
        private Boolean ismanaged;
        private Integer componentstate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder mobileofflineprofileid(String mobileofflineprofileid) {
            this.mobileofflineprofileid = mobileofflineprofileid;
            this.changedFields = changedFields.add("mobileofflineprofileid");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder mobileofflineprofileidunique(String mobileofflineprofileidunique) {
            this.mobileofflineprofileidunique = mobileofflineprofileidunique;
            this.changedFields = changedFields.add("mobileofflineprofileidunique");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder isvalidated(Boolean isvalidated) {
            this.isvalidated = isvalidated;
            this.changedFields = changedFields.add("isvalidated");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder publishedon(OffsetDateTime publishedon) {
            this.publishedon = publishedon;
            this.changedFields = changedFields.add("publishedon");
            return this;
        }

        public Builder processid(String processid) {
            this.processid = processid;
            this.changedFields = changedFields.add("processid");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder stageid(String stageid) {
            this.stageid = stageid;
            this.changedFields = changedFields.add("stageid");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder selectedentitymetadata(String selectedentitymetadata) {
            this.selectedentitymetadata = selectedentitymetadata;
            this.changedFields = changedFields.add("selectedentitymetadata");
            return this;
        }

        public Builder traversedpath(String traversedpath) {
            this.traversedpath = traversedpath;
            this.changedFields = changedFields.add("traversedpath");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Mobileofflineprofile build() {
            Mobileofflineprofile _x = new Mobileofflineprofile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.mobileofflineprofile";
            _x._organizationid_value = _organizationid_value;
            _x.versionnumber = versionnumber;
            _x.mobileofflineprofileid = mobileofflineprofileid;
            _x.modifiedon = modifiedon;
            _x.introducedversion = introducedversion;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.mobileofflineprofileidunique = mobileofflineprofileidunique;
            _x._modifiedby_value = _modifiedby_value;
            _x.isvalidated = isvalidated;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.overwritetime = overwritetime;
            _x.publishedon = publishedon;
            _x.processid = processid;
            _x.solutionid = solutionid;
            _x.description = description;
            _x.createdon = createdon;
            _x._createdby_value = _createdby_value;
            _x.stageid = stageid;
            _x.name = name;
            _x.selectedentitymetadata = selectedentitymetadata;
            _x.traversedpath = traversedpath;
            _x.ismanaged = ismanaged;
            _x.componentstate = componentstate;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && mobileofflineprofileid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(mobileofflineprofileid.toString()));
        }
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Mobileofflineprofile with_organizationid_value(String _organizationid_value) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Mobileofflineprofile withVersionnumber(Long versionnumber) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="mobileofflineprofileid")
    @JsonIgnore
    public Optional<String> getMobileofflineprofileid() {
        return Optional.ofNullable(mobileofflineprofileid);
    }

    public Mobileofflineprofile withMobileofflineprofileid(String mobileofflineprofileid) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("mobileofflineprofileid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.mobileofflineprofileid = mobileofflineprofileid;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Mobileofflineprofile withModifiedon(OffsetDateTime modifiedon) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Mobileofflineprofile withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Mobileofflineprofile with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="mobileofflineprofileidunique")
    @JsonIgnore
    public Optional<String> getMobileofflineprofileidunique() {
        return Optional.ofNullable(mobileofflineprofileidunique);
    }

    public Mobileofflineprofile withMobileofflineprofileidunique(String mobileofflineprofileidunique) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("mobileofflineprofileidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.mobileofflineprofileidunique = mobileofflineprofileidunique;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Mobileofflineprofile with_modifiedby_value(String _modifiedby_value) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="isvalidated")
    @JsonIgnore
    public Optional<Boolean> getIsvalidated() {
        return Optional.ofNullable(isvalidated);
    }

    public Mobileofflineprofile withIsvalidated(Boolean isvalidated) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("isvalidated");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.isvalidated = isvalidated;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Mobileofflineprofile with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Mobileofflineprofile withOverwritetime(OffsetDateTime overwritetime) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="publishedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getPublishedon() {
        return Optional.ofNullable(publishedon);
    }

    public Mobileofflineprofile withPublishedon(OffsetDateTime publishedon) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("publishedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.publishedon = publishedon;
        return _x;
    }

    @Property(name="processid")
    @JsonIgnore
    public Optional<String> getProcessid() {
        return Optional.ofNullable(processid);
    }

    public Mobileofflineprofile withProcessid(String processid) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("processid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.processid = processid;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Mobileofflineprofile withSolutionid(String solutionid) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Mobileofflineprofile withDescription(String description) {
        Checks.checkIsAscii(description);
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.description = description;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Mobileofflineprofile withCreatedon(OffsetDateTime createdon) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Mobileofflineprofile with_createdby_value(String _createdby_value) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="stageid")
    @JsonIgnore
    public Optional<String> getStageid() {
        return Optional.ofNullable(stageid);
    }

    public Mobileofflineprofile withStageid(String stageid) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("stageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.stageid = stageid;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Mobileofflineprofile withName(String name) {
        Checks.checkIsAscii(name);
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.name = name;
        return _x;
    }

    @Property(name="selectedentitymetadata")
    @JsonIgnore
    public Optional<String> getSelectedentitymetadata() {
        return Optional.ofNullable(selectedentitymetadata);
    }

    public Mobileofflineprofile withSelectedentitymetadata(String selectedentitymetadata) {
        Checks.checkIsAscii(selectedentitymetadata);
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("selectedentitymetadata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.selectedentitymetadata = selectedentitymetadata;
        return _x;
    }

    @Property(name="traversedpath")
    @JsonIgnore
    public Optional<String> getTraversedpath() {
        return Optional.ofNullable(traversedpath);
    }

    public Mobileofflineprofile withTraversedpath(String traversedpath) {
        Checks.checkIsAscii(traversedpath);
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("traversedpath");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.traversedpath = traversedpath;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Mobileofflineprofile withIsmanaged(Boolean ismanaged) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Mobileofflineprofile withComponentstate(Integer componentstate) {
        Mobileofflineprofile _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofile");
        _x.componentstate = componentstate;
        return _x;
    }

    public Mobileofflineprofile withUnmappedField(String name, String value) {
        Mobileofflineprofile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="DefaultMobileOfflineProfile_Organization")
    @JsonIgnore
    public OrganizationCollectionRequest getDefaultMobileOfflineProfile_Organization() {
        return new OrganizationCollectionRequest(
                        contextPath.addSegment("DefaultMobileOfflineProfile_Organization"), RequestHelper.getValue(unmappedFields, "DefaultMobileOfflineProfile_Organization"));
    }

    @NavigationProperty(name="MobileOfflineProfile_MobileOfflineProfileItem")
    @JsonIgnore
    public MobileofflineprofileitemCollectionRequest getMobileOfflineProfile_MobileOfflineProfileItem() {
        return new MobileofflineprofileitemCollectionRequest(
                        contextPath.addSegment("MobileOfflineProfile_MobileOfflineProfileItem"), RequestHelper.getValue(unmappedFields, "MobileOfflineProfile_MobileOfflineProfileItem"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="MobileOfflineProfile_SystemUser")
    @JsonIgnore
    public SystemuserCollectionRequest getMobileOfflineProfile_SystemUser() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("MobileOfflineProfile_SystemUser"), RequestHelper.getValue(unmappedFields, "MobileOfflineProfile_SystemUser"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Mobileofflineprofile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Mobileofflineprofile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Mobileofflineprofile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Mobileofflineprofile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Mobileofflineprofile _copy() {
        Mobileofflineprofile _x = new Mobileofflineprofile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._organizationid_value = _organizationid_value;
        _x.versionnumber = versionnumber;
        _x.mobileofflineprofileid = mobileofflineprofileid;
        _x.modifiedon = modifiedon;
        _x.introducedversion = introducedversion;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.mobileofflineprofileidunique = mobileofflineprofileidunique;
        _x._modifiedby_value = _modifiedby_value;
        _x.isvalidated = isvalidated;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.overwritetime = overwritetime;
        _x.publishedon = publishedon;
        _x.processid = processid;
        _x.solutionid = solutionid;
        _x.description = description;
        _x.createdon = createdon;
        _x._createdby_value = _createdby_value;
        _x.stageid = stageid;
        _x.name = name;
        _x.selectedentitymetadata = selectedentitymetadata;
        _x.traversedpath = traversedpath;
        _x.ismanaged = ismanaged;
        _x.componentstate = componentstate;
        return _x;
    }

    @Action(name = "CloneMobileOfflineProfile")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Mobileofflineprofile> cloneMobileOfflineProfile() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Mobileofflineprofile>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CloneMobileOfflineProfile"), Mobileofflineprofile.class, _parameters);
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Mobileofflineprofile> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Mobileofflineprofile>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Mobileofflineprofile.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Mobileofflineprofile[");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("mobileofflineprofileid=");
        b.append(this.mobileofflineprofileid);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("mobileofflineprofileidunique=");
        b.append(this.mobileofflineprofileidunique);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("isvalidated=");
        b.append(this.isvalidated);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("publishedon=");
        b.append(this.publishedon);
        b.append(", ");
        b.append("processid=");
        b.append(this.processid);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("stageid=");
        b.append(this.stageid);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("selectedentitymetadata=");
        b.append(this.selectedentitymetadata);
        b.append(", ");
        b.append("traversedpath=");
        b.append(this.traversedpath);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
