package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SolutionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "tags", 
    "connectionreferences", 
    "description", 
    "componentstate", 
    "_owningteam_value", 
    "_ownerid_value", 
    "introducedversion", 
    "_owninguser_value", 
    "versionnumber", 
    "canconsumeapppass", 
    "cdsdependencies", 
    "appcomponents", 
    "solutionid", 
    "appcomponentdependencies", 
    "lastmodifiedtime", 
    "canvasapprowid", 
    "backgroundcolor", 
    "lastpublishtime", 
    "appversion", 
    "createdbyclientversion", 
    "authorizationreferences", 
    "overwritetime", 
    "embeddedapp", 
    "appopenuri", 
    "publisher", 
    "commitmessage", 
    "isheroapp", 
    "status", 
    "aadlastmodifiedbyid", 
    "admincontrolbypassconsent", 
    "aadlastpublishedbyid", 
    "galleryitemid", 
    "displayname", 
    "createdtime", 
    "databasereferences", 
    "_owningbusinessunit_value", 
    "canvasappid", 
    "canvasapptype", 
    "ishidden", 
    "isfeaturedapp", 
    "ismanaged", 
    "aadcreatedbyid", 
    "name", 
    "bypassconsent", 
    "iscdsupgraded", 
    "minclientversion"})
@JsonInclude(Include.NON_NULL)
public class Canvasapp extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.canvasapp";
    }

    @JsonProperty("tags")
    protected String tags;

    @JsonProperty("connectionreferences")
    protected String connectionreferences;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("canconsumeapppass")
    protected Boolean canconsumeapppass;

    @JsonProperty("cdsdependencies")
    protected String cdsdependencies;

    @JsonProperty("appcomponents")
    protected String appcomponents;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("appcomponentdependencies")
    protected String appcomponentdependencies;

    @JsonProperty("lastmodifiedtime")
    protected OffsetDateTime lastmodifiedtime;

    @JsonProperty("canvasapprowid")
    protected String canvasapprowid;

    @JsonProperty("backgroundcolor")
    protected String backgroundcolor;

    @JsonProperty("lastpublishtime")
    protected OffsetDateTime lastpublishtime;

    @JsonProperty("appversion")
    protected String appversion;

    @JsonProperty("createdbyclientversion")
    protected String createdbyclientversion;

    @JsonProperty("authorizationreferences")
    protected String authorizationreferences;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("embeddedapp")
    protected String embeddedapp;

    @JsonProperty("appopenuri")
    protected String appopenuri;

    @JsonProperty("publisher")
    protected String publisher;

    @JsonProperty("commitmessage")
    protected String commitmessage;

    @JsonProperty("isheroapp")
    protected Boolean isheroapp;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("aadlastmodifiedbyid")
    protected String aadlastmodifiedbyid;

    @JsonProperty("admincontrolbypassconsent")
    protected Boolean admincontrolbypassconsent;

    @JsonProperty("aadlastpublishedbyid")
    protected String aadlastpublishedbyid;

    @JsonProperty("galleryitemid")
    protected String galleryitemid;

    @JsonProperty("displayname")
    protected String displayname;

    @JsonProperty("createdtime")
    protected OffsetDateTime createdtime;

    @JsonProperty("databasereferences")
    protected String databasereferences;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("canvasappid")
    protected String canvasappid;

    @JsonProperty("canvasapptype")
    protected Integer canvasapptype;

    @JsonProperty("ishidden")
    protected Boolean ishidden;

    @JsonProperty("isfeaturedapp")
    protected Boolean isfeaturedapp;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("aadcreatedbyid")
    protected String aadcreatedbyid;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("bypassconsent")
    protected Boolean bypassconsent;

    @JsonProperty("iscdsupgraded")
    protected Boolean iscdsupgraded;

    @JsonProperty("minclientversion")
    protected String minclientversion;

    protected Canvasapp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCanvasapp() {
        return new Builder();
    }

    public static final class Builder {
        private String tags;
        private String connectionreferences;
        private String description;
        private Integer componentstate;
        private String _owningteam_value;
        private String _ownerid_value;
        private String introducedversion;
        private String _owninguser_value;
        private Long versionnumber;
        private Boolean canconsumeapppass;
        private String cdsdependencies;
        private String appcomponents;
        private String solutionid;
        private String appcomponentdependencies;
        private OffsetDateTime lastmodifiedtime;
        private String canvasapprowid;
        private String backgroundcolor;
        private OffsetDateTime lastpublishtime;
        private String appversion;
        private String createdbyclientversion;
        private String authorizationreferences;
        private OffsetDateTime overwritetime;
        private String embeddedapp;
        private String appopenuri;
        private String publisher;
        private String commitmessage;
        private Boolean isheroapp;
        private String status;
        private String aadlastmodifiedbyid;
        private Boolean admincontrolbypassconsent;
        private String aadlastpublishedbyid;
        private String galleryitemid;
        private String displayname;
        private OffsetDateTime createdtime;
        private String databasereferences;
        private String _owningbusinessunit_value;
        private String canvasappid;
        private Integer canvasapptype;
        private Boolean ishidden;
        private Boolean isfeaturedapp;
        private Boolean ismanaged;
        private String aadcreatedbyid;
        private String name;
        private Boolean bypassconsent;
        private Boolean iscdsupgraded;
        private String minclientversion;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder tags(String tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder connectionreferences(String connectionreferences) {
            this.connectionreferences = connectionreferences;
            this.changedFields = changedFields.add("connectionreferences");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder canconsumeapppass(Boolean canconsumeapppass) {
            this.canconsumeapppass = canconsumeapppass;
            this.changedFields = changedFields.add("canconsumeapppass");
            return this;
        }

        public Builder cdsdependencies(String cdsdependencies) {
            this.cdsdependencies = cdsdependencies;
            this.changedFields = changedFields.add("cdsdependencies");
            return this;
        }

        public Builder appcomponents(String appcomponents) {
            this.appcomponents = appcomponents;
            this.changedFields = changedFields.add("appcomponents");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder appcomponentdependencies(String appcomponentdependencies) {
            this.appcomponentdependencies = appcomponentdependencies;
            this.changedFields = changedFields.add("appcomponentdependencies");
            return this;
        }

        public Builder lastmodifiedtime(OffsetDateTime lastmodifiedtime) {
            this.lastmodifiedtime = lastmodifiedtime;
            this.changedFields = changedFields.add("lastmodifiedtime");
            return this;
        }

        public Builder canvasapprowid(String canvasapprowid) {
            this.canvasapprowid = canvasapprowid;
            this.changedFields = changedFields.add("canvasapprowid");
            return this;
        }

        public Builder backgroundcolor(String backgroundcolor) {
            this.backgroundcolor = backgroundcolor;
            this.changedFields = changedFields.add("backgroundcolor");
            return this;
        }

        public Builder lastpublishtime(OffsetDateTime lastpublishtime) {
            this.lastpublishtime = lastpublishtime;
            this.changedFields = changedFields.add("lastpublishtime");
            return this;
        }

        public Builder appversion(String appversion) {
            this.appversion = appversion;
            this.changedFields = changedFields.add("appversion");
            return this;
        }

        public Builder createdbyclientversion(String createdbyclientversion) {
            this.createdbyclientversion = createdbyclientversion;
            this.changedFields = changedFields.add("createdbyclientversion");
            return this;
        }

        public Builder authorizationreferences(String authorizationreferences) {
            this.authorizationreferences = authorizationreferences;
            this.changedFields = changedFields.add("authorizationreferences");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder embeddedapp(String embeddedapp) {
            this.embeddedapp = embeddedapp;
            this.changedFields = changedFields.add("embeddedapp");
            return this;
        }

        public Builder appopenuri(String appopenuri) {
            this.appopenuri = appopenuri;
            this.changedFields = changedFields.add("appopenuri");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder commitmessage(String commitmessage) {
            this.commitmessage = commitmessage;
            this.changedFields = changedFields.add("commitmessage");
            return this;
        }

        public Builder isheroapp(Boolean isheroapp) {
            this.isheroapp = isheroapp;
            this.changedFields = changedFields.add("isheroapp");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder aadlastmodifiedbyid(String aadlastmodifiedbyid) {
            this.aadlastmodifiedbyid = aadlastmodifiedbyid;
            this.changedFields = changedFields.add("aadlastmodifiedbyid");
            return this;
        }

        public Builder admincontrolbypassconsent(Boolean admincontrolbypassconsent) {
            this.admincontrolbypassconsent = admincontrolbypassconsent;
            this.changedFields = changedFields.add("admincontrolbypassconsent");
            return this;
        }

        public Builder aadlastpublishedbyid(String aadlastpublishedbyid) {
            this.aadlastpublishedbyid = aadlastpublishedbyid;
            this.changedFields = changedFields.add("aadlastpublishedbyid");
            return this;
        }

        public Builder galleryitemid(String galleryitemid) {
            this.galleryitemid = galleryitemid;
            this.changedFields = changedFields.add("galleryitemid");
            return this;
        }

        public Builder displayname(String displayname) {
            this.displayname = displayname;
            this.changedFields = changedFields.add("displayname");
            return this;
        }

        public Builder createdtime(OffsetDateTime createdtime) {
            this.createdtime = createdtime;
            this.changedFields = changedFields.add("createdtime");
            return this;
        }

        public Builder databasereferences(String databasereferences) {
            this.databasereferences = databasereferences;
            this.changedFields = changedFields.add("databasereferences");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder canvasappid(String canvasappid) {
            this.canvasappid = canvasappid;
            this.changedFields = changedFields.add("canvasappid");
            return this;
        }

        public Builder canvasapptype(Integer canvasapptype) {
            this.canvasapptype = canvasapptype;
            this.changedFields = changedFields.add("canvasapptype");
            return this;
        }

        public Builder ishidden(Boolean ishidden) {
            this.ishidden = ishidden;
            this.changedFields = changedFields.add("ishidden");
            return this;
        }

        public Builder isfeaturedapp(Boolean isfeaturedapp) {
            this.isfeaturedapp = isfeaturedapp;
            this.changedFields = changedFields.add("isfeaturedapp");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder aadcreatedbyid(String aadcreatedbyid) {
            this.aadcreatedbyid = aadcreatedbyid;
            this.changedFields = changedFields.add("aadcreatedbyid");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder bypassconsent(Boolean bypassconsent) {
            this.bypassconsent = bypassconsent;
            this.changedFields = changedFields.add("bypassconsent");
            return this;
        }

        public Builder iscdsupgraded(Boolean iscdsupgraded) {
            this.iscdsupgraded = iscdsupgraded;
            this.changedFields = changedFields.add("iscdsupgraded");
            return this;
        }

        public Builder minclientversion(String minclientversion) {
            this.minclientversion = minclientversion;
            this.changedFields = changedFields.add("minclientversion");
            return this;
        }

        public Canvasapp build() {
            Canvasapp _x = new Canvasapp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.canvasapp";
            _x.tags = tags;
            _x.connectionreferences = connectionreferences;
            _x.description = description;
            _x.componentstate = componentstate;
            _x._owningteam_value = _owningteam_value;
            _x._ownerid_value = _ownerid_value;
            _x.introducedversion = introducedversion;
            _x._owninguser_value = _owninguser_value;
            _x.versionnumber = versionnumber;
            _x.canconsumeapppass = canconsumeapppass;
            _x.cdsdependencies = cdsdependencies;
            _x.appcomponents = appcomponents;
            _x.solutionid = solutionid;
            _x.appcomponentdependencies = appcomponentdependencies;
            _x.lastmodifiedtime = lastmodifiedtime;
            _x.canvasapprowid = canvasapprowid;
            _x.backgroundcolor = backgroundcolor;
            _x.lastpublishtime = lastpublishtime;
            _x.appversion = appversion;
            _x.createdbyclientversion = createdbyclientversion;
            _x.authorizationreferences = authorizationreferences;
            _x.overwritetime = overwritetime;
            _x.embeddedapp = embeddedapp;
            _x.appopenuri = appopenuri;
            _x.publisher = publisher;
            _x.commitmessage = commitmessage;
            _x.isheroapp = isheroapp;
            _x.status = status;
            _x.aadlastmodifiedbyid = aadlastmodifiedbyid;
            _x.admincontrolbypassconsent = admincontrolbypassconsent;
            _x.aadlastpublishedbyid = aadlastpublishedbyid;
            _x.galleryitemid = galleryitemid;
            _x.displayname = displayname;
            _x.createdtime = createdtime;
            _x.databasereferences = databasereferences;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.canvasappid = canvasappid;
            _x.canvasapptype = canvasapptype;
            _x.ishidden = ishidden;
            _x.isfeaturedapp = isfeaturedapp;
            _x.ismanaged = ismanaged;
            _x.aadcreatedbyid = aadcreatedbyid;
            _x.name = name;
            _x.bypassconsent = bypassconsent;
            _x.iscdsupgraded = iscdsupgraded;
            _x.minclientversion = minclientversion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && canvasappid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(canvasappid.toString()));
        }
    }

    @Property(name="tags")
    @JsonIgnore
    public Optional<String> getTags() {
        return Optional.ofNullable(tags);
    }

    public Canvasapp withTags(String tags) {
        Checks.checkIsAscii(tags);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("tags");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.tags = tags;
        return _x;
    }

    @Property(name="connectionreferences")
    @JsonIgnore
    public Optional<String> getConnectionreferences() {
        return Optional.ofNullable(connectionreferences);
    }

    public Canvasapp withConnectionreferences(String connectionreferences) {
        Checks.checkIsAscii(connectionreferences);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("connectionreferences");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.connectionreferences = connectionreferences;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Canvasapp withDescription(String description) {
        Checks.checkIsAscii(description);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.description = description;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Canvasapp withComponentstate(Integer componentstate) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Canvasapp with_owningteam_value(String _owningteam_value) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Canvasapp with_ownerid_value(String _ownerid_value) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Canvasapp withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Canvasapp with_owninguser_value(String _owninguser_value) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Canvasapp withVersionnumber(Long versionnumber) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="canconsumeapppass")
    @JsonIgnore
    public Optional<Boolean> getCanconsumeapppass() {
        return Optional.ofNullable(canconsumeapppass);
    }

    public Canvasapp withCanconsumeapppass(Boolean canconsumeapppass) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("canconsumeapppass");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.canconsumeapppass = canconsumeapppass;
        return _x;
    }

    @Property(name="cdsdependencies")
    @JsonIgnore
    public Optional<String> getCdsdependencies() {
        return Optional.ofNullable(cdsdependencies);
    }

    public Canvasapp withCdsdependencies(String cdsdependencies) {
        Checks.checkIsAscii(cdsdependencies);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("cdsdependencies");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.cdsdependencies = cdsdependencies;
        return _x;
    }

    @Property(name="appcomponents")
    @JsonIgnore
    public Optional<String> getAppcomponents() {
        return Optional.ofNullable(appcomponents);
    }

    public Canvasapp withAppcomponents(String appcomponents) {
        Checks.checkIsAscii(appcomponents);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("appcomponents");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.appcomponents = appcomponents;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Canvasapp withSolutionid(String solutionid) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="appcomponentdependencies")
    @JsonIgnore
    public Optional<String> getAppcomponentdependencies() {
        return Optional.ofNullable(appcomponentdependencies);
    }

    public Canvasapp withAppcomponentdependencies(String appcomponentdependencies) {
        Checks.checkIsAscii(appcomponentdependencies);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("appcomponentdependencies");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.appcomponentdependencies = appcomponentdependencies;
        return _x;
    }

    @Property(name="lastmodifiedtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastmodifiedtime() {
        return Optional.ofNullable(lastmodifiedtime);
    }

    public Canvasapp withLastmodifiedtime(OffsetDateTime lastmodifiedtime) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("lastmodifiedtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.lastmodifiedtime = lastmodifiedtime;
        return _x;
    }

    @Property(name="canvasapprowid")
    @JsonIgnore
    public Optional<String> getCanvasapprowid() {
        return Optional.ofNullable(canvasapprowid);
    }

    public Canvasapp withCanvasapprowid(String canvasapprowid) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("canvasapprowid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.canvasapprowid = canvasapprowid;
        return _x;
    }

    @Property(name="backgroundcolor")
    @JsonIgnore
    public Optional<String> getBackgroundcolor() {
        return Optional.ofNullable(backgroundcolor);
    }

    public Canvasapp withBackgroundcolor(String backgroundcolor) {
        Checks.checkIsAscii(backgroundcolor);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("backgroundcolor");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.backgroundcolor = backgroundcolor;
        return _x;
    }

    @Property(name="lastpublishtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastpublishtime() {
        return Optional.ofNullable(lastpublishtime);
    }

    public Canvasapp withLastpublishtime(OffsetDateTime lastpublishtime) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("lastpublishtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.lastpublishtime = lastpublishtime;
        return _x;
    }

    @Property(name="appversion")
    @JsonIgnore
    public Optional<String> getAppversion() {
        return Optional.ofNullable(appversion);
    }

    public Canvasapp withAppversion(String appversion) {
        Checks.checkIsAscii(appversion);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("appversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.appversion = appversion;
        return _x;
    }

    @Property(name="createdbyclientversion")
    @JsonIgnore
    public Optional<String> getCreatedbyclientversion() {
        return Optional.ofNullable(createdbyclientversion);
    }

    public Canvasapp withCreatedbyclientversion(String createdbyclientversion) {
        Checks.checkIsAscii(createdbyclientversion);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("createdbyclientversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.createdbyclientversion = createdbyclientversion;
        return _x;
    }

    @Property(name="authorizationreferences")
    @JsonIgnore
    public Optional<String> getAuthorizationreferences() {
        return Optional.ofNullable(authorizationreferences);
    }

    public Canvasapp withAuthorizationreferences(String authorizationreferences) {
        Checks.checkIsAscii(authorizationreferences);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("authorizationreferences");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.authorizationreferences = authorizationreferences;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Canvasapp withOverwritetime(OffsetDateTime overwritetime) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="embeddedapp")
    @JsonIgnore
    public Optional<String> getEmbeddedapp() {
        return Optional.ofNullable(embeddedapp);
    }

    public Canvasapp withEmbeddedapp(String embeddedapp) {
        Checks.checkIsAscii(embeddedapp);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("embeddedapp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.embeddedapp = embeddedapp;
        return _x;
    }

    @Property(name="appopenuri")
    @JsonIgnore
    public Optional<String> getAppopenuri() {
        return Optional.ofNullable(appopenuri);
    }

    public Canvasapp withAppopenuri(String appopenuri) {
        Checks.checkIsAscii(appopenuri);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("appopenuri");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.appopenuri = appopenuri;
        return _x;
    }

    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    public Canvasapp withPublisher(String publisher) {
        Checks.checkIsAscii(publisher);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("publisher");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.publisher = publisher;
        return _x;
    }

    @Property(name="commitmessage")
    @JsonIgnore
    public Optional<String> getCommitmessage() {
        return Optional.ofNullable(commitmessage);
    }

    public Canvasapp withCommitmessage(String commitmessage) {
        Checks.checkIsAscii(commitmessage);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("commitmessage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.commitmessage = commitmessage;
        return _x;
    }

    @Property(name="isheroapp")
    @JsonIgnore
    public Optional<Boolean> getIsheroapp() {
        return Optional.ofNullable(isheroapp);
    }

    public Canvasapp withIsheroapp(Boolean isheroapp) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("isheroapp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.isheroapp = isheroapp;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public Canvasapp withStatus(String status) {
        Checks.checkIsAscii(status);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.status = status;
        return _x;
    }

    @Property(name="aadlastmodifiedbyid")
    @JsonIgnore
    public Optional<String> getAadlastmodifiedbyid() {
        return Optional.ofNullable(aadlastmodifiedbyid);
    }

    public Canvasapp withAadlastmodifiedbyid(String aadlastmodifiedbyid) {
        Checks.checkIsAscii(aadlastmodifiedbyid);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("aadlastmodifiedbyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.aadlastmodifiedbyid = aadlastmodifiedbyid;
        return _x;
    }

    @Property(name="admincontrolbypassconsent")
    @JsonIgnore
    public Optional<Boolean> getAdmincontrolbypassconsent() {
        return Optional.ofNullable(admincontrolbypassconsent);
    }

    public Canvasapp withAdmincontrolbypassconsent(Boolean admincontrolbypassconsent) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("admincontrolbypassconsent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.admincontrolbypassconsent = admincontrolbypassconsent;
        return _x;
    }

    @Property(name="aadlastpublishedbyid")
    @JsonIgnore
    public Optional<String> getAadlastpublishedbyid() {
        return Optional.ofNullable(aadlastpublishedbyid);
    }

    public Canvasapp withAadlastpublishedbyid(String aadlastpublishedbyid) {
        Checks.checkIsAscii(aadlastpublishedbyid);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("aadlastpublishedbyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.aadlastpublishedbyid = aadlastpublishedbyid;
        return _x;
    }

    @Property(name="galleryitemid")
    @JsonIgnore
    public Optional<String> getGalleryitemid() {
        return Optional.ofNullable(galleryitemid);
    }

    public Canvasapp withGalleryitemid(String galleryitemid) {
        Checks.checkIsAscii(galleryitemid);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("galleryitemid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.galleryitemid = galleryitemid;
        return _x;
    }

    @Property(name="displayname")
    @JsonIgnore
    public Optional<String> getDisplayname() {
        return Optional.ofNullable(displayname);
    }

    public Canvasapp withDisplayname(String displayname) {
        Checks.checkIsAscii(displayname);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("displayname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.displayname = displayname;
        return _x;
    }

    @Property(name="createdtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedtime() {
        return Optional.ofNullable(createdtime);
    }

    public Canvasapp withCreatedtime(OffsetDateTime createdtime) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("createdtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.createdtime = createdtime;
        return _x;
    }

    @Property(name="databasereferences")
    @JsonIgnore
    public Optional<String> getDatabasereferences() {
        return Optional.ofNullable(databasereferences);
    }

    public Canvasapp withDatabasereferences(String databasereferences) {
        Checks.checkIsAscii(databasereferences);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("databasereferences");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.databasereferences = databasereferences;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Canvasapp with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="canvasappid")
    @JsonIgnore
    public Optional<String> getCanvasappid() {
        return Optional.ofNullable(canvasappid);
    }

    public Canvasapp withCanvasappid(String canvasappid) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("canvasappid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.canvasappid = canvasappid;
        return _x;
    }

    @Property(name="canvasapptype")
    @JsonIgnore
    public Optional<Integer> getCanvasapptype() {
        return Optional.ofNullable(canvasapptype);
    }

    public Canvasapp withCanvasapptype(Integer canvasapptype) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("canvasapptype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.canvasapptype = canvasapptype;
        return _x;
    }

    @Property(name="ishidden")
    @JsonIgnore
    public Optional<Boolean> getIshidden() {
        return Optional.ofNullable(ishidden);
    }

    public Canvasapp withIshidden(Boolean ishidden) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("ishidden");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.ishidden = ishidden;
        return _x;
    }

    @Property(name="isfeaturedapp")
    @JsonIgnore
    public Optional<Boolean> getIsfeaturedapp() {
        return Optional.ofNullable(isfeaturedapp);
    }

    public Canvasapp withIsfeaturedapp(Boolean isfeaturedapp) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("isfeaturedapp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.isfeaturedapp = isfeaturedapp;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Canvasapp withIsmanaged(Boolean ismanaged) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="aadcreatedbyid")
    @JsonIgnore
    public Optional<String> getAadcreatedbyid() {
        return Optional.ofNullable(aadcreatedbyid);
    }

    public Canvasapp withAadcreatedbyid(String aadcreatedbyid) {
        Checks.checkIsAscii(aadcreatedbyid);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("aadcreatedbyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.aadcreatedbyid = aadcreatedbyid;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Canvasapp withName(String name) {
        Checks.checkIsAscii(name);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.name = name;
        return _x;
    }

    @Property(name="bypassconsent")
    @JsonIgnore
    public Optional<Boolean> getBypassconsent() {
        return Optional.ofNullable(bypassconsent);
    }

    public Canvasapp withBypassconsent(Boolean bypassconsent) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("bypassconsent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.bypassconsent = bypassconsent;
        return _x;
    }

    @Property(name="iscdsupgraded")
    @JsonIgnore
    public Optional<Boolean> getIscdsupgraded() {
        return Optional.ofNullable(iscdsupgraded);
    }

    public Canvasapp withIscdsupgraded(Boolean iscdsupgraded) {
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("iscdsupgraded");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.iscdsupgraded = iscdsupgraded;
        return _x;
    }

    @Property(name="minclientversion")
    @JsonIgnore
    public Optional<String> getMinclientversion() {
        return Optional.ofNullable(minclientversion);
    }

    public Canvasapp withMinclientversion(String minclientversion) {
        Checks.checkIsAscii(minclientversion);
        Canvasapp _x = _copy();
        _x.changedFields = changedFields.add("minclientversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.canvasapp");
        _x.minclientversion = minclientversion;
        return _x;
    }

    public Canvasapp withUnmappedField(String name, String value) {
        Canvasapp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="FK_CanvasApp_Solution")
    @JsonIgnore
    public SolutionRequest getFK_CanvasApp_Solution() {
        return new SolutionRequest(contextPath.addSegment("FK_CanvasApp_Solution"), RequestHelper.getValue(unmappedFields, "FK_CanvasApp_Solution"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Canvasapp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Canvasapp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Canvasapp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Canvasapp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Canvasapp _copy() {
        Canvasapp _x = new Canvasapp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.tags = tags;
        _x.connectionreferences = connectionreferences;
        _x.description = description;
        _x.componentstate = componentstate;
        _x._owningteam_value = _owningteam_value;
        _x._ownerid_value = _ownerid_value;
        _x.introducedversion = introducedversion;
        _x._owninguser_value = _owninguser_value;
        _x.versionnumber = versionnumber;
        _x.canconsumeapppass = canconsumeapppass;
        _x.cdsdependencies = cdsdependencies;
        _x.appcomponents = appcomponents;
        _x.solutionid = solutionid;
        _x.appcomponentdependencies = appcomponentdependencies;
        _x.lastmodifiedtime = lastmodifiedtime;
        _x.canvasapprowid = canvasapprowid;
        _x.backgroundcolor = backgroundcolor;
        _x.lastpublishtime = lastpublishtime;
        _x.appversion = appversion;
        _x.createdbyclientversion = createdbyclientversion;
        _x.authorizationreferences = authorizationreferences;
        _x.overwritetime = overwritetime;
        _x.embeddedapp = embeddedapp;
        _x.appopenuri = appopenuri;
        _x.publisher = publisher;
        _x.commitmessage = commitmessage;
        _x.isheroapp = isheroapp;
        _x.status = status;
        _x.aadlastmodifiedbyid = aadlastmodifiedbyid;
        _x.admincontrolbypassconsent = admincontrolbypassconsent;
        _x.aadlastpublishedbyid = aadlastpublishedbyid;
        _x.galleryitemid = galleryitemid;
        _x.displayname = displayname;
        _x.createdtime = createdtime;
        _x.databasereferences = databasereferences;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.canvasappid = canvasappid;
        _x.canvasapptype = canvasapptype;
        _x.ishidden = ishidden;
        _x.isfeaturedapp = isfeaturedapp;
        _x.ismanaged = ismanaged;
        _x.aadcreatedbyid = aadcreatedbyid;
        _x.name = name;
        _x.bypassconsent = bypassconsent;
        _x.iscdsupgraded = iscdsupgraded;
        _x.minclientversion = minclientversion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Canvasapp[");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("connectionreferences=");
        b.append(this.connectionreferences);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("canconsumeapppass=");
        b.append(this.canconsumeapppass);
        b.append(", ");
        b.append("cdsdependencies=");
        b.append(this.cdsdependencies);
        b.append(", ");
        b.append("appcomponents=");
        b.append(this.appcomponents);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("appcomponentdependencies=");
        b.append(this.appcomponentdependencies);
        b.append(", ");
        b.append("lastmodifiedtime=");
        b.append(this.lastmodifiedtime);
        b.append(", ");
        b.append("canvasapprowid=");
        b.append(this.canvasapprowid);
        b.append(", ");
        b.append("backgroundcolor=");
        b.append(this.backgroundcolor);
        b.append(", ");
        b.append("lastpublishtime=");
        b.append(this.lastpublishtime);
        b.append(", ");
        b.append("appversion=");
        b.append(this.appversion);
        b.append(", ");
        b.append("createdbyclientversion=");
        b.append(this.createdbyclientversion);
        b.append(", ");
        b.append("authorizationreferences=");
        b.append(this.authorizationreferences);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("embeddedapp=");
        b.append(this.embeddedapp);
        b.append(", ");
        b.append("appopenuri=");
        b.append(this.appopenuri);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("commitmessage=");
        b.append(this.commitmessage);
        b.append(", ");
        b.append("isheroapp=");
        b.append(this.isheroapp);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("aadlastmodifiedbyid=");
        b.append(this.aadlastmodifiedbyid);
        b.append(", ");
        b.append("admincontrolbypassconsent=");
        b.append(this.admincontrolbypassconsent);
        b.append(", ");
        b.append("aadlastpublishedbyid=");
        b.append(this.aadlastpublishedbyid);
        b.append(", ");
        b.append("galleryitemid=");
        b.append(this.galleryitemid);
        b.append(", ");
        b.append("displayname=");
        b.append(this.displayname);
        b.append(", ");
        b.append("createdtime=");
        b.append(this.createdtime);
        b.append(", ");
        b.append("databasereferences=");
        b.append(this.databasereferences);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("canvasappid=");
        b.append(this.canvasappid);
        b.append(", ");
        b.append("canvasapptype=");
        b.append(this.canvasapptype);
        b.append(", ");
        b.append("ishidden=");
        b.append(this.ishidden);
        b.append(", ");
        b.append("isfeaturedapp=");
        b.append(this.isfeaturedapp);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("aadcreatedbyid=");
        b.append(this.aadcreatedbyid);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("bypassconsent=");
        b.append(this.bypassconsent);
        b.append(", ");
        b.append("iscdsupgraded=");
        b.append(this.iscdsupgraded);
        b.append(", ");
        b.append("minclientversion=");
        b.append(this.minclientversion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
