package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AppconfiginstanceCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "overriddencreatedon", 
    "_modifiedby_value", 
    "configtype", 
    "createdon", 
    "_modifiedonbehalfby_value", 
    "defaultvalue", 
    "isnavigationsetting", 
    "versionnumber", 
    "name", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "importsequencenumber", 
    "validator", 
    "_organizationid_value", 
    "parentappconfigmasterid", 
    "appconfigmasterid", 
    "_createdby_value"})
@JsonInclude(Include.NON_NULL)
public class Appconfigmaster extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.appconfigmaster";
    }

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("configtype")
    protected String configtype;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("defaultvalue")
    protected String defaultvalue;

    @JsonProperty("isnavigationsetting")
    protected Integer isnavigationsetting;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("validator")
    protected String validator;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("parentappconfigmasterid")
    protected String parentappconfigmasterid;

    @JsonProperty("appconfigmasterid")
    protected String appconfigmasterid;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    protected Appconfigmaster() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppconfigmaster() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime overriddencreatedon;
        private String _modifiedby_value;
        private String configtype;
        private OffsetDateTime createdon;
        private String _modifiedonbehalfby_value;
        private String defaultvalue;
        private Integer isnavigationsetting;
        private Long versionnumber;
        private String name;
        private String _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private Integer importsequencenumber;
        private String validator;
        private String _organizationid_value;
        private String parentappconfigmasterid;
        private String appconfigmasterid;
        private String _createdby_value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder configtype(String configtype) {
            this.configtype = configtype;
            this.changedFields = changedFields.add("configtype");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder defaultvalue(String defaultvalue) {
            this.defaultvalue = defaultvalue;
            this.changedFields = changedFields.add("defaultvalue");
            return this;
        }

        public Builder isnavigationsetting(Integer isnavigationsetting) {
            this.isnavigationsetting = isnavigationsetting;
            this.changedFields = changedFields.add("isnavigationsetting");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder validator(String validator) {
            this.validator = validator;
            this.changedFields = changedFields.add("validator");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder parentappconfigmasterid(String parentappconfigmasterid) {
            this.parentappconfigmasterid = parentappconfigmasterid;
            this.changedFields = changedFields.add("parentappconfigmasterid");
            return this;
        }

        public Builder appconfigmasterid(String appconfigmasterid) {
            this.appconfigmasterid = appconfigmasterid;
            this.changedFields = changedFields.add("appconfigmasterid");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Appconfigmaster build() {
            Appconfigmaster _x = new Appconfigmaster();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.appconfigmaster";
            _x.overriddencreatedon = overriddencreatedon;
            _x._modifiedby_value = _modifiedby_value;
            _x.configtype = configtype;
            _x.createdon = createdon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.defaultvalue = defaultvalue;
            _x.isnavigationsetting = isnavigationsetting;
            _x.versionnumber = versionnumber;
            _x.name = name;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x.importsequencenumber = importsequencenumber;
            _x.validator = validator;
            _x._organizationid_value = _organizationid_value;
            _x.parentappconfigmasterid = parentappconfigmasterid;
            _x.appconfigmasterid = appconfigmasterid;
            _x._createdby_value = _createdby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && appconfigmasterid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(appconfigmasterid.toString()));
        }
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Appconfigmaster withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Appconfigmaster with_modifiedby_value(String _modifiedby_value) {
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="configtype")
    @JsonIgnore
    public Optional<String> getConfigtype() {
        return Optional.ofNullable(configtype);
    }

    public Appconfigmaster withConfigtype(String configtype) {
        Checks.checkIsAscii(configtype);
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("configtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x.configtype = configtype;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Appconfigmaster withCreatedon(OffsetDateTime createdon) {
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Appconfigmaster with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="defaultvalue")
    @JsonIgnore
    public Optional<String> getDefaultvalue() {
        return Optional.ofNullable(defaultvalue);
    }

    public Appconfigmaster withDefaultvalue(String defaultvalue) {
        Checks.checkIsAscii(defaultvalue);
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("defaultvalue");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x.defaultvalue = defaultvalue;
        return _x;
    }

    @Property(name="isnavigationsetting")
    @JsonIgnore
    public Optional<Integer> getIsnavigationsetting() {
        return Optional.ofNullable(isnavigationsetting);
    }

    public Appconfigmaster withIsnavigationsetting(Integer isnavigationsetting) {
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("isnavigationsetting");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x.isnavigationsetting = isnavigationsetting;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Appconfigmaster withVersionnumber(Long versionnumber) {
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Appconfigmaster withName(String name) {
        Checks.checkIsAscii(name);
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x.name = name;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Appconfigmaster with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Appconfigmaster withModifiedon(OffsetDateTime modifiedon) {
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Appconfigmaster withImportsequencenumber(Integer importsequencenumber) {
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="validator")
    @JsonIgnore
    public Optional<String> getValidator() {
        return Optional.ofNullable(validator);
    }

    public Appconfigmaster withValidator(String validator) {
        Checks.checkIsAscii(validator);
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("validator");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x.validator = validator;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Appconfigmaster with_organizationid_value(String _organizationid_value) {
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="parentappconfigmasterid")
    @JsonIgnore
    public Optional<String> getParentappconfigmasterid() {
        return Optional.ofNullable(parentappconfigmasterid);
    }

    public Appconfigmaster withParentappconfigmasterid(String parentappconfigmasterid) {
        Checks.checkIsAscii(parentappconfigmasterid);
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("parentappconfigmasterid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x.parentappconfigmasterid = parentappconfigmasterid;
        return _x;
    }

    @Property(name="appconfigmasterid")
    @JsonIgnore
    public Optional<String> getAppconfigmasterid() {
        return Optional.ofNullable(appconfigmasterid);
    }

    public Appconfigmaster withAppconfigmasterid(String appconfigmasterid) {
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("appconfigmasterid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x.appconfigmasterid = appconfigmasterid;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Appconfigmaster with_createdby_value(String _createdby_value) {
        Appconfigmaster _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfigmaster");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    public Appconfigmaster withUnmappedField(String name, String value) {
        Appconfigmaster _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="appconfigmaster_appconfiginstance")
    @JsonIgnore
    public AppconfiginstanceCollectionRequest getAppconfigmaster_appconfiginstance() {
        return new AppconfiginstanceCollectionRequest(
                        contextPath.addSegment("appconfigmaster_appconfiginstance"), RequestHelper.getValue(unmappedFields, "appconfigmaster_appconfiginstance"));
    }

    @NavigationProperty(name="appconfigmaster_createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getAppconfigmaster_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("appconfigmaster_createdonbehalfby"), RequestHelper.getValue(unmappedFields, "appconfigmaster_createdonbehalfby"));
    }

    @NavigationProperty(name="appconfigmaster_createdby")
    @JsonIgnore
    public SystemuserRequest getAppconfigmaster_createdby() {
        return new SystemuserRequest(contextPath.addSegment("appconfigmaster_createdby"), RequestHelper.getValue(unmappedFields, "appconfigmaster_createdby"));
    }

    @NavigationProperty(name="organization_appconfigmaster_appconfigmaster")
    @JsonIgnore
    public OrganizationRequest getOrganization_appconfigmaster_appconfigmaster() {
        return new OrganizationRequest(contextPath.addSegment("organization_appconfigmaster_appconfigmaster"), RequestHelper.getValue(unmappedFields, "organization_appconfigmaster_appconfigmaster"));
    }

    @NavigationProperty(name="appconfigmaster_modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getAppconfigmaster_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("appconfigmaster_modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "appconfigmaster_modifiedonbehalfby"));
    }

    @NavigationProperty(name="appconfigmaster_modifiedby")
    @JsonIgnore
    public SystemuserRequest getAppconfigmaster_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("appconfigmaster_modifiedby"), RequestHelper.getValue(unmappedFields, "appconfigmaster_modifiedby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appconfigmaster patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Appconfigmaster _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appconfigmaster put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Appconfigmaster _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Appconfigmaster _copy() {
        Appconfigmaster _x = new Appconfigmaster();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.overriddencreatedon = overriddencreatedon;
        _x._modifiedby_value = _modifiedby_value;
        _x.configtype = configtype;
        _x.createdon = createdon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.defaultvalue = defaultvalue;
        _x.isnavigationsetting = isnavigationsetting;
        _x.versionnumber = versionnumber;
        _x.name = name;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x.importsequencenumber = importsequencenumber;
        _x.validator = validator;
        _x._organizationid_value = _organizationid_value;
        _x.parentappconfigmasterid = parentappconfigmasterid;
        _x.appconfigmasterid = appconfigmasterid;
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Appconfigmaster[");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("configtype=");
        b.append(this.configtype);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("defaultvalue=");
        b.append(this.defaultvalue);
        b.append(", ");
        b.append("isnavigationsetting=");
        b.append(this.isnavigationsetting);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("validator=");
        b.append(this.validator);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("parentappconfigmasterid=");
        b.append(this.parentappconfigmasterid);
        b.append(", ");
        b.append("appconfigmasterid=");
        b.append(this.appconfigmasterid);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
