package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "MailboxTrackingFolderMappings"})
@JsonInclude(Include.NON_NULL)
public class RetrieveMailboxTrackingFoldersResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("MailboxTrackingFolderMappings")
    protected List<MailboxTrackingFolderMapping> mailboxTrackingFolderMappings;

    @JsonProperty("MailboxTrackingFolderMappings@nextLink")
    protected String mailboxTrackingFolderMappingsNextLink;

    protected RetrieveMailboxTrackingFoldersResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveMailboxTrackingFoldersResponse";
    }

    @Property(name="MailboxTrackingFolderMappings")
    @JsonIgnore
    public CollectionPage<MailboxTrackingFolderMapping> getMailboxTrackingFolderMappings() {
        return new CollectionPage<MailboxTrackingFolderMapping>(contextPath, MailboxTrackingFolderMapping.class, this.mailboxTrackingFolderMappings, Optional.ofNullable(mailboxTrackingFolderMappingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="MailboxTrackingFolderMappings")
    @JsonIgnore
    public CollectionPage<MailboxTrackingFolderMapping> getMailboxTrackingFolderMappings(HttpRequestOptions options) {
        return new CollectionPage<MailboxTrackingFolderMapping>(contextPath, MailboxTrackingFolderMapping.class, this.mailboxTrackingFolderMappings, Optional.ofNullable(mailboxTrackingFolderMappingsNextLink), Collections.emptyList(), options);
    }

    public RetrieveMailboxTrackingFoldersResponse withUnmappedField(String name, String value) {
        RetrieveMailboxTrackingFoldersResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<MailboxTrackingFolderMapping> mailboxTrackingFolderMappings;
        private String mailboxTrackingFolderMappingsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder mailboxTrackingFolderMappings(List<MailboxTrackingFolderMapping> mailboxTrackingFolderMappings) {
            this.mailboxTrackingFolderMappings = mailboxTrackingFolderMappings;
            this.changedFields = changedFields.add("MailboxTrackingFolderMappings");
            return this;
        }

        public Builder mailboxTrackingFolderMappings(MailboxTrackingFolderMapping... mailboxTrackingFolderMappings) {
            return mailboxTrackingFolderMappings(Arrays.asList(mailboxTrackingFolderMappings));
        }

        public Builder mailboxTrackingFolderMappingsNextLink(String mailboxTrackingFolderMappingsNextLink) {
            this.mailboxTrackingFolderMappingsNextLink = mailboxTrackingFolderMappingsNextLink;
            this.changedFields = changedFields.add("MailboxTrackingFolderMappings");
            return this;
        }

        public RetrieveMailboxTrackingFoldersResponse build() {
            RetrieveMailboxTrackingFoldersResponse _x = new RetrieveMailboxTrackingFoldersResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveMailboxTrackingFoldersResponse";
            _x.mailboxTrackingFolderMappings = mailboxTrackingFolderMappings;
            _x.mailboxTrackingFolderMappingsNextLink = mailboxTrackingFolderMappingsNextLink;
            return _x;
        }
    }

    private RetrieveMailboxTrackingFoldersResponse _copy() {
        RetrieveMailboxTrackingFoldersResponse _x = new RetrieveMailboxTrackingFoldersResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.mailboxTrackingFolderMappings = mailboxTrackingFolderMappings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveMailboxTrackingFoldersResponse[");
        b.append("MailboxTrackingFolderMappings=");
        b.append(this.mailboxTrackingFolderMappings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
