package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "LocaleIds"})
@JsonInclude(Include.NON_NULL)
public class RetrieveAvailableLanguagesResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("LocaleIds")
    protected List<Integer> localeIds;

    @JsonProperty("LocaleIds@nextLink")
    protected String localeIdsNextLink;

    protected RetrieveAvailableLanguagesResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveAvailableLanguagesResponse";
    }

    @Property(name="LocaleIds")
    @JsonIgnore
    public CollectionPage<Integer> getLocaleIds() {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.localeIds, Optional.ofNullable(localeIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="LocaleIds")
    @JsonIgnore
    public CollectionPage<Integer> getLocaleIds(HttpRequestOptions options) {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.localeIds, Optional.ofNullable(localeIdsNextLink), Collections.emptyList(), options);
    }

    public RetrieveAvailableLanguagesResponse withUnmappedField(String name, String value) {
        RetrieveAvailableLanguagesResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Integer> localeIds;
        private String localeIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder localeIds(List<Integer> localeIds) {
            this.localeIds = localeIds;
            this.changedFields = changedFields.add("LocaleIds");
            return this;
        }

        public Builder localeIds(Integer... localeIds) {
            return localeIds(Arrays.asList(localeIds));
        }

        public Builder localeIdsNextLink(String localeIdsNextLink) {
            this.localeIdsNextLink = localeIdsNextLink;
            this.changedFields = changedFields.add("LocaleIds");
            return this;
        }

        public RetrieveAvailableLanguagesResponse build() {
            RetrieveAvailableLanguagesResponse _x = new RetrieveAvailableLanguagesResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveAvailableLanguagesResponse";
            _x.localeIds = localeIds;
            _x.localeIdsNextLink = localeIdsNextLink;
            return _x;
        }
    }

    private RetrieveAvailableLanguagesResponse _copy() {
        RetrieveAvailableLanguagesResponse _x = new RetrieveAvailableLanguagesResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.localeIds = localeIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveAvailableLanguagesResponse[");
        b.append("LocaleIds=");
        b.append(this.localeIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
