package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "AllProperties", 
    "PropertyNames"})
@JsonInclude(Include.NON_NULL)
public class MetadataPropertiesExpression implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AllProperties")
    protected Boolean allProperties;

    @JsonProperty("PropertyNames")
    protected List<String> propertyNames;

    @JsonProperty("PropertyNames@nextLink")
    protected String propertyNamesNextLink;

    protected MetadataPropertiesExpression() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.MetadataPropertiesExpression";
    }

    @Property(name="AllProperties")
    @JsonIgnore
    public Optional<Boolean> getAllProperties() {
        return Optional.ofNullable(allProperties);
    }

    public MetadataPropertiesExpression withAllProperties(Boolean allProperties) {
        MetadataPropertiesExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataPropertiesExpression");
        _x.allProperties = allProperties;
        return _x;
    }

    @Property(name="PropertyNames")
    @JsonIgnore
    public CollectionPage<String> getPropertyNames() {
        return new CollectionPage<String>(contextPath, String.class, this.propertyNames, Optional.ofNullable(propertyNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="PropertyNames")
    @JsonIgnore
    public CollectionPage<String> getPropertyNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.propertyNames, Optional.ofNullable(propertyNamesNextLink), Collections.emptyList(), options);
    }

    public MetadataPropertiesExpression withUnmappedField(String name, String value) {
        MetadataPropertiesExpression _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean allProperties;
        private List<String> propertyNames;
        private String propertyNamesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder allProperties(Boolean allProperties) {
            this.allProperties = allProperties;
            this.changedFields = changedFields.add("AllProperties");
            return this;
        }

        public Builder propertyNames(List<String> propertyNames) {
            this.propertyNames = propertyNames;
            this.changedFields = changedFields.add("PropertyNames");
            return this;
        }

        public Builder propertyNames(String... propertyNames) {
            return propertyNames(Arrays.asList(propertyNames));
        }

        public Builder propertyNamesNextLink(String propertyNamesNextLink) {
            this.propertyNamesNextLink = propertyNamesNextLink;
            this.changedFields = changedFields.add("PropertyNames");
            return this;
        }

        public MetadataPropertiesExpression build() {
            MetadataPropertiesExpression _x = new MetadataPropertiesExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.MetadataPropertiesExpression";
            _x.allProperties = allProperties;
            _x.propertyNames = propertyNames;
            _x.propertyNamesNextLink = propertyNamesNextLink;
            return _x;
        }
    }

    private MetadataPropertiesExpression _copy() {
        MetadataPropertiesExpression _x = new MetadataPropertiesExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.allProperties = allProperties;
        _x.propertyNames = propertyNames;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MetadataPropertiesExpression[");
        b.append("AllProperties=");
        b.append(this.allProperties);
        b.append(", ");
        b.append("PropertyNames=");
        b.append(this.propertyNames);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
