package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Entity", 
    "View"})
@JsonInclude(Include.NON_NULL)
public class LookupMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Entity")
    protected LookupEntityMetadata entity;

    @JsonProperty("View")
    protected LookupView view;

    protected LookupMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LookupMetadata";
    }

    @Property(name="Entity")
    @JsonIgnore
    public Optional<LookupEntityMetadata> getEntity() {
        return Optional.ofNullable(entity);
    }

    public LookupMetadata withEntity(LookupEntityMetadata entity) {
        LookupMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupMetadata");
        _x.entity = entity;
        return _x;
    }

    @Property(name="View")
    @JsonIgnore
    public Optional<LookupView> getView() {
        return Optional.ofNullable(view);
    }

    public LookupMetadata withView(LookupView view) {
        LookupMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LookupMetadata");
        _x.view = view;
        return _x;
    }

    public LookupMetadata withUnmappedField(String name, String value) {
        LookupMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private LookupEntityMetadata entity;
        private LookupView view;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder entity(LookupEntityMetadata entity) {
            this.entity = entity;
            this.changedFields = changedFields.add("Entity");
            return this;
        }

        public Builder view(LookupView view) {
            this.view = view;
            this.changedFields = changedFields.add("View");
            return this;
        }

        public LookupMetadata build() {
            LookupMetadata _x = new LookupMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LookupMetadata";
            _x.entity = entity;
            _x.view = view;
            return _x;
        }
    }

    private LookupMetadata _copy() {
        LookupMetadata _x = new LookupMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entity = entity;
        _x.view = view;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupMetadata[");
        b.append("Entity=");
        b.append(this.entity);
        b.append(", ");
        b.append("View=");
        b.append(this.view);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
