package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ResourceList", 
    "ErrorCode"})
@JsonInclude(Include.NON_NULL)
public class ErrorInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ResourceList")
    protected List<ResourceInfo> resourceList;

    @JsonProperty("ResourceList@nextLink")
    protected String resourceListNextLink;

    @JsonProperty("ErrorCode")
    protected String errorCode;

    protected ErrorInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ErrorInfo";
    }

    @Property(name="ResourceList")
    @JsonIgnore
    public CollectionPage<ResourceInfo> getResourceList() {
        return new CollectionPage<ResourceInfo>(contextPath, ResourceInfo.class, this.resourceList, Optional.ofNullable(resourceListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ResourceList")
    @JsonIgnore
    public CollectionPage<ResourceInfo> getResourceList(HttpRequestOptions options) {
        return new CollectionPage<ResourceInfo>(contextPath, ResourceInfo.class, this.resourceList, Optional.ofNullable(resourceListNextLink), Collections.emptyList(), options);
    }

    @Property(name="ErrorCode")
    @JsonIgnore
    public Optional<String> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    public ErrorInfo withErrorCode(String errorCode) {
        Checks.checkIsAscii(errorCode);
        ErrorInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ErrorInfo");
        _x.errorCode = errorCode;
        return _x;
    }

    public ErrorInfo withUnmappedField(String name, String value) {
        ErrorInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ResourceInfo> resourceList;
        private String resourceListNextLink;
        private String errorCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder resourceList(List<ResourceInfo> resourceList) {
            this.resourceList = resourceList;
            this.changedFields = changedFields.add("ResourceList");
            return this;
        }

        public Builder resourceList(ResourceInfo... resourceList) {
            return resourceList(Arrays.asList(resourceList));
        }

        public Builder resourceListNextLink(String resourceListNextLink) {
            this.resourceListNextLink = resourceListNextLink;
            this.changedFields = changedFields.add("ResourceList");
            return this;
        }

        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("ErrorCode");
            return this;
        }

        public ErrorInfo build() {
            ErrorInfo _x = new ErrorInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ErrorInfo";
            _x.resourceList = resourceList;
            _x.resourceListNextLink = resourceListNextLink;
            _x.errorCode = errorCode;
            return _x;
        }
    }

    private ErrorInfo _copy() {
        ErrorInfo _x = new ErrorInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.resourceList = resourceList;
        _x.errorCode = errorCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ErrorInfo[");
        b.append("ResourceList=");
        b.append(this.resourceList);
        b.append(", ");
        b.append("ErrorCode=");
        b.append(this.errorCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
