package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "OptionList"})
@JsonInclude(Include.NON_NULL)
public class DependentOptionMetadataCollection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("OptionList")
    protected List<DependentOptionMetadata> optionList;

    @JsonProperty("OptionList@nextLink")
    protected String optionListNextLink;

    protected DependentOptionMetadataCollection() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DependentOptionMetadataCollection";
    }

    @Property(name="OptionList")
    @JsonIgnore
    public CollectionPage<DependentOptionMetadata> getOptionList() {
        return new CollectionPage<DependentOptionMetadata>(contextPath, DependentOptionMetadata.class, this.optionList, Optional.ofNullable(optionListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="OptionList")
    @JsonIgnore
    public CollectionPage<DependentOptionMetadata> getOptionList(HttpRequestOptions options) {
        return new CollectionPage<DependentOptionMetadata>(contextPath, DependentOptionMetadata.class, this.optionList, Optional.ofNullable(optionListNextLink), Collections.emptyList(), options);
    }

    public DependentOptionMetadataCollection withUnmappedField(String name, String value) {
        DependentOptionMetadataCollection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DependentOptionMetadata> optionList;
        private String optionListNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder optionList(List<DependentOptionMetadata> optionList) {
            this.optionList = optionList;
            this.changedFields = changedFields.add("OptionList");
            return this;
        }

        public Builder optionList(DependentOptionMetadata... optionList) {
            return optionList(Arrays.asList(optionList));
        }

        public Builder optionListNextLink(String optionListNextLink) {
            this.optionListNextLink = optionListNextLink;
            this.changedFields = changedFields.add("OptionList");
            return this;
        }

        public DependentOptionMetadataCollection build() {
            DependentOptionMetadataCollection _x = new DependentOptionMetadataCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DependentOptionMetadataCollection";
            _x.optionList = optionList;
            _x.optionListNextLink = optionListNextLink;
            return _x;
        }
    }

    private DependentOptionMetadataCollection _copy() {
        DependentOptionMetadataCollection _x = new DependentOptionMetadataCollection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.optionList = optionList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DependentOptionMetadataCollection[");
        b.append("OptionList=");
        b.append(this.optionList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
