package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "appInfo", 
    "SitemapId", 
    "bpfIds", 
    "dashboardIds", 
    "appEntityInfo", 
    "CanvasApps"})
@JsonInclude(Include.NON_NULL)
public class AppContext implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appInfo")
    protected AppInfo appInfo;

    @JsonProperty("SitemapId")
    protected String sitemapId;

    @JsonProperty("bpfIds")
    protected List<String> bpfIds;

    @JsonProperty("bpfIds@nextLink")
    protected String bpfIdsNextLink;

    @JsonProperty("dashboardIds")
    protected List<String> dashboardIds;

    @JsonProperty("dashboardIds@nextLink")
    protected String dashboardIdsNextLink;

    @JsonProperty("appEntityInfo")
    protected List<AppEntityInfo> appEntityInfo;

    @JsonProperty("appEntityInfo@nextLink")
    protected String appEntityInfoNextLink;

    @JsonProperty("CanvasApps")
    protected List<CanvasAppsInfo> canvasApps;

    @JsonProperty("CanvasApps@nextLink")
    protected String canvasAppsNextLink;

    protected AppContext() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppContext";
    }

    @Property(name="appInfo")
    @JsonIgnore
    public Optional<AppInfo> getAppInfo() {
        return Optional.ofNullable(appInfo);
    }

    public AppContext withAppInfo(AppInfo appInfo) {
        AppContext _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppContext");
        _x.appInfo = appInfo;
        return _x;
    }

    @Property(name="SitemapId")
    @JsonIgnore
    public Optional<String> getSitemapId() {
        return Optional.ofNullable(sitemapId);
    }

    public AppContext withSitemapId(String sitemapId) {
        Checks.checkIsAscii(sitemapId);
        AppContext _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppContext");
        _x.sitemapId = sitemapId;
        return _x;
    }

    @Property(name="bpfIds")
    @JsonIgnore
    public CollectionPage<String> getBpfIds() {
        return new CollectionPage<String>(contextPath, String.class, this.bpfIds, Optional.ofNullable(bpfIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="bpfIds")
    @JsonIgnore
    public CollectionPage<String> getBpfIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.bpfIds, Optional.ofNullable(bpfIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="dashboardIds")
    @JsonIgnore
    public CollectionPage<String> getDashboardIds() {
        return new CollectionPage<String>(contextPath, String.class, this.dashboardIds, Optional.ofNullable(dashboardIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="dashboardIds")
    @JsonIgnore
    public CollectionPage<String> getDashboardIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.dashboardIds, Optional.ofNullable(dashboardIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="appEntityInfo")
    @JsonIgnore
    public CollectionPage<AppEntityInfo> getAppEntityInfo() {
        return new CollectionPage<AppEntityInfo>(contextPath, AppEntityInfo.class, this.appEntityInfo, Optional.ofNullable(appEntityInfoNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="appEntityInfo")
    @JsonIgnore
    public CollectionPage<AppEntityInfo> getAppEntityInfo(HttpRequestOptions options) {
        return new CollectionPage<AppEntityInfo>(contextPath, AppEntityInfo.class, this.appEntityInfo, Optional.ofNullable(appEntityInfoNextLink), Collections.emptyList(), options);
    }

    @Property(name="CanvasApps")
    @JsonIgnore
    public CollectionPage<CanvasAppsInfo> getCanvasApps() {
        return new CollectionPage<CanvasAppsInfo>(contextPath, CanvasAppsInfo.class, this.canvasApps, Optional.ofNullable(canvasAppsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="CanvasApps")
    @JsonIgnore
    public CollectionPage<CanvasAppsInfo> getCanvasApps(HttpRequestOptions options) {
        return new CollectionPage<CanvasAppsInfo>(contextPath, CanvasAppsInfo.class, this.canvasApps, Optional.ofNullable(canvasAppsNextLink), Collections.emptyList(), options);
    }

    public AppContext withUnmappedField(String name, String value) {
        AppContext _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AppInfo appInfo;
        private String sitemapId;
        private List<String> bpfIds;
        private String bpfIdsNextLink;
        private List<String> dashboardIds;
        private String dashboardIdsNextLink;
        private List<AppEntityInfo> appEntityInfo;
        private String appEntityInfoNextLink;
        private List<CanvasAppsInfo> canvasApps;
        private String canvasAppsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder appInfo(AppInfo appInfo) {
            this.appInfo = appInfo;
            this.changedFields = changedFields.add("appInfo");
            return this;
        }

        public Builder sitemapId(String sitemapId) {
            this.sitemapId = sitemapId;
            this.changedFields = changedFields.add("SitemapId");
            return this;
        }

        public Builder bpfIds(List<String> bpfIds) {
            this.bpfIds = bpfIds;
            this.changedFields = changedFields.add("bpfIds");
            return this;
        }

        public Builder bpfIds(String... bpfIds) {
            return bpfIds(Arrays.asList(bpfIds));
        }

        public Builder bpfIdsNextLink(String bpfIdsNextLink) {
            this.bpfIdsNextLink = bpfIdsNextLink;
            this.changedFields = changedFields.add("bpfIds");
            return this;
        }

        public Builder dashboardIds(List<String> dashboardIds) {
            this.dashboardIds = dashboardIds;
            this.changedFields = changedFields.add("dashboardIds");
            return this;
        }

        public Builder dashboardIds(String... dashboardIds) {
            return dashboardIds(Arrays.asList(dashboardIds));
        }

        public Builder dashboardIdsNextLink(String dashboardIdsNextLink) {
            this.dashboardIdsNextLink = dashboardIdsNextLink;
            this.changedFields = changedFields.add("dashboardIds");
            return this;
        }

        public Builder appEntityInfo(List<AppEntityInfo> appEntityInfo) {
            this.appEntityInfo = appEntityInfo;
            this.changedFields = changedFields.add("appEntityInfo");
            return this;
        }

        public Builder appEntityInfo(AppEntityInfo... appEntityInfo) {
            return appEntityInfo(Arrays.asList(appEntityInfo));
        }

        public Builder appEntityInfoNextLink(String appEntityInfoNextLink) {
            this.appEntityInfoNextLink = appEntityInfoNextLink;
            this.changedFields = changedFields.add("appEntityInfo");
            return this;
        }

        public Builder canvasApps(List<CanvasAppsInfo> canvasApps) {
            this.canvasApps = canvasApps;
            this.changedFields = changedFields.add("CanvasApps");
            return this;
        }

        public Builder canvasApps(CanvasAppsInfo... canvasApps) {
            return canvasApps(Arrays.asList(canvasApps));
        }

        public Builder canvasAppsNextLink(String canvasAppsNextLink) {
            this.canvasAppsNextLink = canvasAppsNextLink;
            this.changedFields = changedFields.add("CanvasApps");
            return this;
        }

        public AppContext build() {
            AppContext _x = new AppContext();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppContext";
            _x.appInfo = appInfo;
            _x.sitemapId = sitemapId;
            _x.bpfIds = bpfIds;
            _x.bpfIdsNextLink = bpfIdsNextLink;
            _x.dashboardIds = dashboardIds;
            _x.dashboardIdsNextLink = dashboardIdsNextLink;
            _x.appEntityInfo = appEntityInfo;
            _x.appEntityInfoNextLink = appEntityInfoNextLink;
            _x.canvasApps = canvasApps;
            _x.canvasAppsNextLink = canvasAppsNextLink;
            return _x;
        }
    }

    private AppContext _copy() {
        AppContext _x = new AppContext();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appInfo = appInfo;
        _x.sitemapId = sitemapId;
        _x.bpfIds = bpfIds;
        _x.dashboardIds = dashboardIds;
        _x.appEntityInfo = appEntityInfo;
        _x.canvasApps = canvasApps;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppContext[");
        b.append("appInfo=");
        b.append(this.appInfo);
        b.append(", ");
        b.append("SitemapId=");
        b.append(this.sitemapId);
        b.append(", ");
        b.append("bpfIds=");
        b.append(this.bpfIds);
        b.append(", ");
        b.append("dashboardIds=");
        b.append(this.dashboardIds);
        b.append(", ");
        b.append("appEntityInfo=");
        b.append(this.appEntityInfo);
        b.append(", ");
        b.append("CanvasApps=");
        b.append(this.canvasApps);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
