/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "PageNumber", "Count", "ReturnTotalRecordCount", "PagingCookie"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PagingInfo
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="PageNumber")
    protected Integer pageNumber;
    @JsonProperty(value="Count")
    protected Integer count;
    @JsonProperty(value="ReturnTotalRecordCount")
    protected Boolean returnTotalRecordCount;
    @JsonProperty(value="PagingCookie")
    protected String pagingCookie;

    protected PagingInfo() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.PagingInfo";
    }

    @Property(name="PageNumber")
    @JsonIgnore
    public Optional<Integer> getPageNumber() {
        return Optional.ofNullable(this.pageNumber);
    }

    public PagingInfo withPageNumber(Integer pageNumber) {
        PagingInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.PagingInfo");
        _x.pageNumber = pageNumber;
        return _x;
    }

    @Property(name="Count")
    @JsonIgnore
    public Optional<Integer> getCount() {
        return Optional.ofNullable(this.count);
    }

    public PagingInfo withCount(Integer count) {
        PagingInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.PagingInfo");
        _x.count = count;
        return _x;
    }

    @Property(name="ReturnTotalRecordCount")
    @JsonIgnore
    public Optional<Boolean> getReturnTotalRecordCount() {
        return Optional.ofNullable(this.returnTotalRecordCount);
    }

    public PagingInfo withReturnTotalRecordCount(Boolean returnTotalRecordCount) {
        PagingInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.PagingInfo");
        _x.returnTotalRecordCount = returnTotalRecordCount;
        return _x;
    }

    @Property(name="PagingCookie")
    @JsonIgnore
    public Optional<String> getPagingCookie() {
        return Optional.ofNullable(this.pagingCookie);
    }

    public PagingInfo withPagingCookie(String pagingCookie) {
        Checks.checkIsAscii((String)pagingCookie);
        PagingInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.PagingInfo");
        _x.pagingCookie = pagingCookie;
        return _x;
    }

    public PagingInfo withUnmappedField(String name, String value) {
        PagingInfo _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private PagingInfo _copy() {
        PagingInfo _x = new PagingInfo();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.pageNumber = this.pageNumber;
        _x.count = this.count;
        _x.returnTotalRecordCount = this.returnTotalRecordCount;
        _x.pagingCookie = this.pagingCookie;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PagingInfo[");
        b.append("PageNumber=");
        b.append(this.pageNumber);
        b.append(", ");
        b.append("Count=");
        b.append(this.count);
        b.append(", ");
        b.append("ReturnTotalRecordCount=");
        b.append(this.returnTotalRecordCount);
        b.append(", ");
        b.append("PagingCookie=");
        b.append(this.pagingCookie);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Integer pageNumber;
        private Integer count;
        private Boolean returnTotalRecordCount;
        private String pagingCookie;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            this.changedFields = this.changedFields.add("PageNumber");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.changedFields = this.changedFields.add("Count");
            return this;
        }

        public Builder returnTotalRecordCount(Boolean returnTotalRecordCount) {
            this.returnTotalRecordCount = returnTotalRecordCount;
            this.changedFields = this.changedFields.add("ReturnTotalRecordCount");
            return this;
        }

        public Builder pagingCookie(String pagingCookie) {
            this.pagingCookie = pagingCookie;
            this.changedFields = this.changedFields.add("PagingCookie");
            return this;
        }

        public PagingInfo build() {
            PagingInfo _x = new PagingInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.PagingInfo";
            _x.pageNumber = this.pageNumber;
            _x.count = this.count;
            _x.returnTotalRecordCount = this.returnTotalRecordCount;
            _x.pagingCookie = this.pagingCookie;
            return _x;
        }
    }
}

