/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.XrmAttributeExpression;

@JsonPropertyOrder(value={"@odata.type", "AllColumns", "Columns", "AttributeExpressions"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ColumnSet
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="AllColumns")
    protected Boolean allColumns;
    @JsonProperty(value="Columns")
    protected List<String> columns;
    @JsonProperty(value="Columns@nextLink")
    protected String columnsNextLink;
    @JsonProperty(value="AttributeExpressions")
    protected List<XrmAttributeExpression> attributeExpressions;
    @JsonProperty(value="AttributeExpressions@nextLink")
    protected String attributeExpressionsNextLink;

    protected ColumnSet() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ColumnSet";
    }

    @Property(name="AllColumns")
    @JsonIgnore
    public Optional<Boolean> getAllColumns() {
        return Optional.ofNullable(this.allColumns);
    }

    public ColumnSet withAllColumns(Boolean allColumns) {
        ColumnSet _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ColumnSet");
        _x.allColumns = allColumns;
        return _x;
    }

    @Property(name="Columns")
    @JsonIgnore
    public CollectionPage<String> getColumns() {
        return new CollectionPage(this.contextPath, String.class, this.columns, Optional.ofNullable(this.columnsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Columns")
    @JsonIgnore
    public CollectionPage<String> getColumns(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.columns, Optional.ofNullable(this.columnsNextLink), Collections.emptyList(), options);
    }

    @Property(name="AttributeExpressions")
    @JsonIgnore
    public CollectionPage<XrmAttributeExpression> getAttributeExpressions() {
        return new CollectionPage(this.contextPath, XrmAttributeExpression.class, this.attributeExpressions, Optional.ofNullable(this.attributeExpressionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AttributeExpressions")
    @JsonIgnore
    public CollectionPage<XrmAttributeExpression> getAttributeExpressions(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, XrmAttributeExpression.class, this.attributeExpressions, Optional.ofNullable(this.attributeExpressionsNextLink), Collections.emptyList(), options);
    }

    public ColumnSet withUnmappedField(String name, String value) {
        ColumnSet _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ColumnSet _copy() {
        ColumnSet _x = new ColumnSet();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.allColumns = this.allColumns;
        _x.columns = this.columns;
        _x.attributeExpressions = this.attributeExpressions;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ColumnSet[");
        b.append("AllColumns=");
        b.append(this.allColumns);
        b.append(", ");
        b.append("Columns=");
        b.append(this.columns);
        b.append(", ");
        b.append("AttributeExpressions=");
        b.append(this.attributeExpressions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Boolean allColumns;
        private List<String> columns;
        private String columnsNextLink;
        private List<XrmAttributeExpression> attributeExpressions;
        private String attributeExpressionsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder allColumns(Boolean allColumns) {
            this.allColumns = allColumns;
            this.changedFields = this.changedFields.add("AllColumns");
            return this;
        }

        public Builder columns(List<String> columns) {
            this.columns = columns;
            this.changedFields = this.changedFields.add("Columns");
            return this;
        }

        public Builder columns(String ... columns) {
            return this.columns(Arrays.asList(columns));
        }

        public Builder columnsNextLink(String columnsNextLink) {
            this.columnsNextLink = columnsNextLink;
            this.changedFields = this.changedFields.add("Columns");
            return this;
        }

        public Builder attributeExpressions(List<XrmAttributeExpression> attributeExpressions) {
            this.attributeExpressions = attributeExpressions;
            this.changedFields = this.changedFields.add("AttributeExpressions");
            return this;
        }

        public Builder attributeExpressions(XrmAttributeExpression ... attributeExpressions) {
            return this.attributeExpressions(Arrays.asList(attributeExpressions));
        }

        public Builder attributeExpressionsNextLink(String attributeExpressionsNextLink) {
            this.attributeExpressionsNextLink = attributeExpressionsNextLink;
            this.changedFields = this.changedFields.add("AttributeExpressions");
            return this;
        }

        public ColumnSet build() {
            ColumnSet _x = new ColumnSet();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ColumnSet";
            _x.allColumns = this.allColumns;
            _x.columns = this.columns;
            _x.columnsNextLink = this.columnsNextLink;
            _x.attributeExpressions = this.attributeExpressions;
            _x.attributeExpressionsNextLink = this.attributeExpressionsNextLink;
            return _x;
        }
    }
}

