package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SubCode implements Enum {

    @JsonProperty("Unspecified")
    UNSPECIFIED("Unspecified", "0"),

    @JsonProperty("Schedulable")
    SCHEDULABLE("Schedulable", "1"),

    @JsonProperty("Committed")
    COMMITTED("Committed", "2"),

    @JsonProperty("Uncommitted")
    UNCOMMITTED("Uncommitted", "3"),

    @JsonProperty("Break")
    BREAK("Break", "4"),

    @JsonProperty("Holiday")
    HOLIDAY("Holiday", "5"),

    @JsonProperty("Vacation")
    VACATION("Vacation", "6"),

    @JsonProperty("Appointment")
    APPOINTMENT("Appointment", "7"),

    @JsonProperty("ResourceStartTime")
    RESOURCE_START_TIME("ResourceStartTime", "8"),

    @JsonProperty("ResourceServiceRestriction")
    RESOURCE_SERVICE_RESTRICTION("ResourceServiceRestriction", "9"),

    @JsonProperty("ResourceCapacity")
    RESOURCE_CAPACITY("ResourceCapacity", "10"),

    @JsonProperty("ServiceRestriction")
    SERVICE_RESTRICTION("ServiceRestriction", "11"),

    @JsonProperty("ServiceCost")
    SERVICE_COST("ServiceCost", "12");

    private final String name;
    private final String value;

    private SubCode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
