package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagedPropertyType implements Enum {

    @JsonProperty("Operation")
    OPERATION("Operation", "0"),

    @JsonProperty("Attribute")
    ATTRIBUTE("Attribute", "1"),

    @JsonProperty("CustomEvaluator")
    CUSTOM_EVALUATOR("CustomEvaluator", "2"),

    @JsonProperty("Custom")
    CUSTOM("Custom", "3");

    private final String name;
    private final String value;

    private ManagedPropertyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
