package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EndpointType implements Enum {

    @JsonProperty("OrganizationService")
    ORGANIZATION_SERVICE("OrganizationService", "0"),

    @JsonProperty("OrganizationDataService")
    ORGANIZATION_DATA_SERVICE("OrganizationDataService", "1"),

    @JsonProperty("WebApplication")
    WEB_APPLICATION("WebApplication", "2");

    private final String name;
    private final String value;

    private EndpointType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
