package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeletedMetadataFilters implements Enum {

    @JsonProperty("Default")
    DEFAULT("Default", "1"),

    @JsonProperty("Attribute")
    ATTRIBUTE("Attribute", "2"),

    @JsonProperty("Relationship")
    RELATIONSHIP("Relationship", "4"),

    @JsonProperty("Label")
    LABEL("Label", "8"),

    @JsonProperty("OptionSet")
    OPTION_SET("OptionSet", "16"),

    @JsonProperty("All")
    ALL("All", "31");

    private final String name;
    private final String value;

    private DeletedMetadataFilters(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
