package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum BusinessNotificationSeverity implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Error")
    ERROR("Error", "1"),

    @JsonProperty("Warning")
    WARNING("Warning", "2"),

    @JsonProperty("Information")
    INFORMATION("Information", "3"),

    @JsonProperty("UserDefined")
    USER_DEFINED("UserDefined", "4");

    private final String name;
    private final String value;

    private BusinessNotificationSeverity(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
