package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Recurringappointmentmaster;
import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class RecurringappointmentmasterRequest extends EntityRequest<Recurringappointmentmaster> {

    public RecurringappointmentmasterRequest(ContextPath contextPath, Optional<Object> value) {
        super(Recurringappointmentmaster.class, contextPath, value);
    }

    public PostregardingCollectionRequest recurringappointmentmaster_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_PostRegardings"), Optional.empty());
    }

    public PostregardingRequest recurringappointmentmaster_PostRegardings(String postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("recurringappointmentmaster_PostRegardings").addKeys(new NameValue(postregardingid.toString())), Optional.empty());
    }

    public PostfollowCollectionRequest recurringappointmentmaster_PostFollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_PostFollows"), Optional.empty());
    }

    public PostfollowRequest recurringappointmentmaster_PostFollows(String postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("recurringappointmentmaster_PostFollows").addKeys(new NameValue(postfollowid.toString())), Optional.empty());
    }

    public KnowledgebaserecordRequest regardingobjectid_knowledgebaserecord_recurringappointmentmaster() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord_recurringappointmentmaster"), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest recurringAppointmentMaster_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest recurringAppointmentMaster_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("RecurringAppointmentMaster_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest recurringAppointmentMaster_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest recurringAppointmentMaster_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("RecurringAppointmentMaster_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest recurringAppointmentMaster_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest recurringAppointmentMaster_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("RecurringAppointmentMaster_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public SystemuserRequest owninguser_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("owninguser_recurringappointmentmaster"), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest recurringappointmentmaster_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest recurringappointmentmaster_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("recurringappointmentmaster_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public TeamRequest owningteam_recurringappointmentmaster() {
        return new TeamRequest(contextPath.addSegment("owningteam_recurringappointmentmaster"), Optional.empty());
    }

    public ActivitypointerRequest activityid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("activityid_activitypointer"), Optional.empty());
    }

    public ActivitypartyCollectionRequest recurringappointmentmaster_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_activity_parties"), Optional.empty());
    }

    public ActivitypartyRequest recurringappointmentmaster_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("recurringappointmentmaster_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest recurringAppointmentMaster_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest recurringAppointmentMaster_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("RecurringAppointmentMaster_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit_recurringappointmentmaster() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit_recurringappointmentmaster"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby_recurringappointmentmaster"), Optional.empty());
    }

    public SystemuserRequest createdby_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("createdby_recurringappointmentmaster"), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle_recurringappointmentmaster() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle_recurringappointmentmaster"), Optional.empty());
    }

    public AppointmentCollectionRequest recurringappointmentmaster_appointment() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_appointment"), Optional.empty());
    }

    public AppointmentRequest recurringappointmentmaster_appointment(String activityid) {
        return new AppointmentRequest(contextPath.addSegment("recurringappointmentmaster_appointment").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AccountRequest regardingobjectid_account_recurringappointmentmaster() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account_recurringappointmentmaster"), Optional.empty());
    }

    public QueueitemCollectionRequest recurringAppointmentMaster_QueueItem() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_QueueItem"), Optional.empty());
    }

    public QueueitemRequest recurringAppointmentMaster_QueueItem(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("RecurringAppointmentMaster_QueueItem").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest recurringappointmentmaster_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_connections1"), Optional.empty());
    }

    public ConnectionRequest recurringappointmentmaster_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("recurringappointmentmaster_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby_recurringappointmentmaster"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid_recurringappointmentmaster() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid_recurringappointmentmaster"), Optional.empty());
    }

    public ConnectionCollectionRequest recurringappointmentmaster_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_connections2"), Optional.empty());
    }

    public ConnectionRequest recurringappointmentmaster_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("recurringappointmentmaster_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest recurringAppointmentMaster_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest recurringAppointmentMaster_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("RecurringAppointmentMaster_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public ProcessstageRequest stageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), Optional.empty());
    }

    public ActioncardCollectionRequest recurringappointmentmaster_actioncard() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("recurringappointmentmaster_actioncard"), Optional.empty());
    }

    public ActioncardRequest recurringappointmentmaster_actioncard(String actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("recurringappointmentmaster_actioncard").addKeys(new NameValue(actioncardid.toString())), Optional.empty());
    }

    public ContactRequest regardingobjectid_contact_recurringappointmentmaster() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact_recurringappointmentmaster"), Optional.empty());
    }

    public SystemuserRequest modifiedby_recurringappointmentmaster() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby_recurringappointmentmaster"), Optional.empty());
    }

    public RecurrenceruleRequest activityid_recurrencerule() {
        return new RecurrenceruleRequest(contextPath.addSegment("activityid_recurrencerule"), Optional.empty());
    }

    public ProcesssessionCollectionRequest recurringAppointmentMaster_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest recurringAppointmentMaster_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("RecurringAppointmentMaster_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest recurringAppointmentMaster_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("RecurringAppointmentMaster_Annotation"), Optional.empty());
    }

    public AnnotationRequest recurringAppointmentMaster_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("RecurringAppointmentMaster_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public PrincipalRequest ownerid_recurringappointmentmaster() {
        return new PrincipalRequest(contextPath.addSegment("ownerid_recurringappointmentmaster"), Optional.empty());
    }

}
