package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Postcomment;

@JsonIgnoreType
public class PostcommentRequest extends EntityRequest<Postcomment> {

    public PostcommentRequest(ContextPath contextPath, Optional<Object> value) {
        super(Postcomment.class, contextPath, value);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public PostRequest postid() {
        return new PostRequest(contextPath.addSegment("postid"), Optional.empty());
    }

}
