package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Mobileofflineprofile;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OrganizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;

@JsonIgnoreType
public class MobileofflineprofileRequest extends EntityRequest<Mobileofflineprofile> {

    public MobileofflineprofileRequest(ContextPath contextPath, Optional<Object> value) {
        super(Mobileofflineprofile.class, contextPath, value);
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public OrganizationCollectionRequest defaultMobileOfflineProfile_Organization() {
        return new OrganizationCollectionRequest(
                        contextPath.addSegment("DefaultMobileOfflineProfile_Organization"), Optional.empty());
    }

    public OrganizationRequest defaultMobileOfflineProfile_Organization(String organizationid) {
        return new OrganizationRequest(contextPath.addSegment("DefaultMobileOfflineProfile_Organization").addKeys(new NameValue(organizationid.toString())), Optional.empty());
    }

    public MobileofflineprofileitemCollectionRequest mobileOfflineProfile_MobileOfflineProfileItem() {
        return new MobileofflineprofileitemCollectionRequest(
                        contextPath.addSegment("MobileOfflineProfile_MobileOfflineProfileItem"), Optional.empty());
    }

    public MobileofflineprofileitemRequest mobileOfflineProfile_MobileOfflineProfileItem(String mobileofflineprofileitemid) {
        return new MobileofflineprofileitemRequest(contextPath.addSegment("MobileOfflineProfile_MobileOfflineProfileItem").addKeys(new NameValue(mobileofflineprofileitemid.toString())), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserCollectionRequest mobileOfflineProfile_SystemUser() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("MobileOfflineProfile_SystemUser"), Optional.empty());
    }

    public SystemuserRequest mobileOfflineProfile_SystemUser(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("MobileOfflineProfile_SystemUser").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    @Action(name = "CloneMobileOfflineProfile")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Mobileofflineprofile> cloneMobileOfflineProfile() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Mobileofflineprofile>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CloneMobileOfflineProfile"), Mobileofflineprofile.class, _parameters);
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Mobileofflineprofile> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Mobileofflineprofile>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Mobileofflineprofile.class, _parameters);
    }

}
