package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Interactionforemail;
import microsoft.dynamics.crm.entity.collection.request.ActivitypointerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;

@JsonIgnoreType
public class InteractionforemailRequest extends EntityRequest<Interactionforemail> {

    public InteractionforemailRequest(ContextPath contextPath, Optional<Object> value) {
        super(Interactionforemail.class, contextPath, value);
    }

    public SystemuserRequest createdbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdbyname"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfbyname"), Optional.empty());
    }

    public SystemuserRequest modifiedbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedbyname"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfbyname"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public ActivitypointerCollectionRequest new_interactionforemail_ActivityPointers() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("new_interactionforemail_ActivityPointers"), Optional.empty());
    }

    public ActivitypointerRequest new_interactionforemail_ActivityPointers(String activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("new_interactionforemail_ActivityPointers").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest new_interactionforemail_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("new_interactionforemail_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest new_interactionforemail_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("new_interactionforemail_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

}
