package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Canvasapp;

@JsonIgnoreType
public class CanvasappRequest extends EntityRequest<Canvasapp> {

    public CanvasappRequest(ContextPath contextPath, Optional<Object> value) {
        super(Canvasapp.class, contextPath, value);
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public SolutionRequest fK_CanvasApp_Solution() {
        return new SolutionRequest(contextPath.addSegment("FK_CanvasApp_Solution"), Optional.empty());
    }

}
