package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Calendarrule;

@JsonIgnoreType
public class CalendarruleRequest extends EntityRequest<Calendarrule> {

    public CalendarruleRequest(ContextPath contextPath, Optional<Object> value) {
        super(Calendarrule.class, contextPath, value);
    }

    public CalendarRequest calendarid() {
        return new CalendarRequest(contextPath.addSegment("calendarid"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public CalendarRequest innercalendarid() {
        return new CalendarRequest(contextPath.addSegment("innercalendarid"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

}
