package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Userquery;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.UserqueryRequest;

public class UserqueryCollectionRequest extends CollectionPageEntityRequest<Userquery, UserqueryRequest>{

    protected ContextPath contextPath;

    public UserqueryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Userquery.class, cp -> new UserqueryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest userQuery_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("UserQuery_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest userQuery_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("UserQuery_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest userQuery_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("UserQuery_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest userQuery_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("UserQuery_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest userQuery_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("UserQuery_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest userQuery_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("UserQuery_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

}
