package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Entityimageconfig;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.EntityimageconfigRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class EntityimageconfigCollectionRequest extends CollectionPageEntityRequest<Entityimageconfig, EntityimageconfigRequest>{

    protected ContextPath contextPath;

    public EntityimageconfigCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Entityimageconfig.class, cp -> new EntityimageconfigRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest entityimageconfig_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("entityimageconfig_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest entityimageconfig_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("entityimageconfig_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest entityimageconfig_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("entityimageconfig_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest entityimageconfig_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("entityimageconfig_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest entityimageconfig_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("entityimageconfig_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest entityimageconfig_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("entityimageconfig_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest entityimageconfig_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("entityimageconfig_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest entityimageconfig_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("entityimageconfig_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest entityimageconfig_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("entityimageconfig_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest entityimageconfig_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("entityimageconfig_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

}
