package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamCollectionRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_modifiedonbehalfby_value", 
    "modifiedon", 
    "versionnumber", 
    "_createdonbehalfby_value", 
    "objecttypecode", 
    "defaultaccessrightsmask", 
    "_createdby_value", 
    "teamtemplateid", 
    "createdon", 
    "description", 
    "issystem", 
    "_modifiedby_value", 
    "teamtemplatename"})
@JsonInclude(Include.NON_NULL)
public class Teamtemplate extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.teamtemplate";
    }

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("objecttypecode")
    protected Integer objecttypecode;

    @JsonProperty("defaultaccessrightsmask")
    protected Integer defaultaccessrightsmask;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("teamtemplateid")
    protected String teamtemplateid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("issystem")
    protected Boolean issystem;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("teamtemplatename")
    protected String teamtemplatename;

    protected Teamtemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeamtemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String _modifiedonbehalfby_value;
        private OffsetDateTime modifiedon;
        private Long versionnumber;
        private String _createdonbehalfby_value;
        private Integer objecttypecode;
        private Integer defaultaccessrightsmask;
        private String _createdby_value;
        private String teamtemplateid;
        private OffsetDateTime createdon;
        private String description;
        private Boolean issystem;
        private String _modifiedby_value;
        private String teamtemplatename;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder objecttypecode(Integer objecttypecode) {
            this.objecttypecode = objecttypecode;
            this.changedFields = changedFields.add("objecttypecode");
            return this;
        }

        public Builder defaultaccessrightsmask(Integer defaultaccessrightsmask) {
            this.defaultaccessrightsmask = defaultaccessrightsmask;
            this.changedFields = changedFields.add("defaultaccessrightsmask");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder teamtemplateid(String teamtemplateid) {
            this.teamtemplateid = teamtemplateid;
            this.changedFields = changedFields.add("teamtemplateid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder issystem(Boolean issystem) {
            this.issystem = issystem;
            this.changedFields = changedFields.add("issystem");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder teamtemplatename(String teamtemplatename) {
            this.teamtemplatename = teamtemplatename;
            this.changedFields = changedFields.add("teamtemplatename");
            return this;
        }

        public Teamtemplate build() {
            Teamtemplate _x = new Teamtemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.teamtemplate";
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x.versionnumber = versionnumber;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.objecttypecode = objecttypecode;
            _x.defaultaccessrightsmask = defaultaccessrightsmask;
            _x._createdby_value = _createdby_value;
            _x.teamtemplateid = teamtemplateid;
            _x.createdon = createdon;
            _x.description = description;
            _x.issystem = issystem;
            _x._modifiedby_value = _modifiedby_value;
            _x.teamtemplatename = teamtemplatename;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && teamtemplateid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(teamtemplateid.toString()));
        }
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Teamtemplate with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Teamtemplate withModifiedon(OffsetDateTime modifiedon) {
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Teamtemplate withVersionnumber(Long versionnumber) {
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Teamtemplate with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="objecttypecode")
    @JsonIgnore
    public Optional<Integer> getObjecttypecode() {
        return Optional.ofNullable(objecttypecode);
    }

    public Teamtemplate withObjecttypecode(Integer objecttypecode) {
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    @Property(name="defaultaccessrightsmask")
    @JsonIgnore
    public Optional<Integer> getDefaultaccessrightsmask() {
        return Optional.ofNullable(defaultaccessrightsmask);
    }

    public Teamtemplate withDefaultaccessrightsmask(Integer defaultaccessrightsmask) {
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("defaultaccessrightsmask");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x.defaultaccessrightsmask = defaultaccessrightsmask;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Teamtemplate with_createdby_value(String _createdby_value) {
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="teamtemplateid")
    @JsonIgnore
    public Optional<String> getTeamtemplateid() {
        return Optional.ofNullable(teamtemplateid);
    }

    public Teamtemplate withTeamtemplateid(String teamtemplateid) {
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("teamtemplateid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x.teamtemplateid = teamtemplateid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Teamtemplate withCreatedon(OffsetDateTime createdon) {
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Teamtemplate withDescription(String description) {
        Checks.checkIsAscii(description);
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x.description = description;
        return _x;
    }

    @Property(name="issystem")
    @JsonIgnore
    public Optional<Boolean> getIssystem() {
        return Optional.ofNullable(issystem);
    }

    public Teamtemplate withIssystem(Boolean issystem) {
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("issystem");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x.issystem = issystem;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Teamtemplate with_modifiedby_value(String _modifiedby_value) {
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="teamtemplatename")
    @JsonIgnore
    public Optional<String> getTeamtemplatename() {
        return Optional.ofNullable(teamtemplatename);
    }

    public Teamtemplate withTeamtemplatename(String teamtemplatename) {
        Checks.checkIsAscii(teamtemplatename);
        Teamtemplate _x = _copy();
        _x.changedFields = changedFields.add("teamtemplatename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teamtemplate");
        _x.teamtemplatename = teamtemplatename;
        return _x;
    }

    public Teamtemplate withUnmappedField(String name, String value) {
        Teamtemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="teamtemplate_Teams")
    @JsonIgnore
    public TeamCollectionRequest getTeamtemplate_Teams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("teamtemplate_Teams"), RequestHelper.getValue(unmappedFields, "teamtemplate_Teams"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="TeamTemplate_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getTeamTemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("TeamTemplate_SyncErrors"), RequestHelper.getValue(unmappedFields, "TeamTemplate_SyncErrors"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Teamtemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Teamtemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Teamtemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Teamtemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Teamtemplate _copy() {
        Teamtemplate _x = new Teamtemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x.versionnumber = versionnumber;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.objecttypecode = objecttypecode;
        _x.defaultaccessrightsmask = defaultaccessrightsmask;
        _x._createdby_value = _createdby_value;
        _x.teamtemplateid = teamtemplateid;
        _x.createdon = createdon;
        _x.description = description;
        _x.issystem = issystem;
        _x._modifiedby_value = _modifiedby_value;
        _x.teamtemplatename = teamtemplatename;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Teamtemplate[");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("objecttypecode=");
        b.append(this.objecttypecode);
        b.append(", ");
        b.append("defaultaccessrightsmask=");
        b.append(this.defaultaccessrightsmask);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("teamtemplateid=");
        b.append(this.teamtemplateid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("issystem=");
        b.append(this.issystem);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("teamtemplatename=");
        b.append(this.teamtemplatename);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
