package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.CalendarRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_slakpiRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "successconditionsxml", 
    "_createdby_value", 
    "_modifiedby_value", 
    "warnafter", 
    "changedattributelist", 
    "actionurl", 
    "slaitemidunique", 
    "_slaid_value", 
    "_owningbusinessunit_value", 
    "modifiedon", 
    "actionflowuniquename", 
    "allowpauseresume", 
    "_transactioncurrencyid_value", 
    "_createdonbehalfby_value", 
    "description", 
    "_msdyn_slakpiid_value", 
    "versionnumber", 
    "_modifiedonbehalfby_value", 
    "_ownerid_value", 
    "slaitemid", 
    "applicablewhenxml", 
    "_businesshoursid_value", 
    "failureafter", 
    "overwritetime", 
    "exchangerate", 
    "_workflowid_value", 
    "createdon", 
    "applicableentity", 
    "componentstate", 
    "name", 
    "_owninguser_value", 
    "relatedfield", 
    "solutionid", 
    "sequencenumber", 
    "ismanaged"})
@JsonInclude(Include.NON_NULL)
public class Slaitem extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.slaitem";
    }

    @JsonProperty("successconditionsxml")
    protected String successconditionsxml;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("warnafter")
    protected Integer warnafter;

    @JsonProperty("changedattributelist")
    protected String changedattributelist;

    @JsonProperty("actionurl")
    protected String actionurl;

    @JsonProperty("slaitemidunique")
    protected String slaitemidunique;

    @JsonProperty("_slaid_value")
    protected String _slaid_value;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("actionflowuniquename")
    protected String actionflowuniquename;

    @JsonProperty("allowpauseresume")
    protected Boolean allowpauseresume;

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("_msdyn_slakpiid_value")
    protected String _msdyn_slakpiid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("slaitemid")
    protected String slaitemid;

    @JsonProperty("applicablewhenxml")
    protected String applicablewhenxml;

    @JsonProperty("_businesshoursid_value")
    protected String _businesshoursid_value;

    @JsonProperty("failureafter")
    protected Integer failureafter;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("_workflowid_value")
    protected String _workflowid_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("applicableentity")
    protected String applicableentity;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("relatedfield")
    protected String relatedfield;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("sequencenumber")
    protected Integer sequencenumber;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    protected Slaitem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSlaitem() {
        return new Builder();
    }

    public static final class Builder {
        private String successconditionsxml;
        private String _createdby_value;
        private String _modifiedby_value;
        private Integer warnafter;
        private String changedattributelist;
        private String actionurl;
        private String slaitemidunique;
        private String _slaid_value;
        private String _owningbusinessunit_value;
        private OffsetDateTime modifiedon;
        private String actionflowuniquename;
        private Boolean allowpauseresume;
        private String _transactioncurrencyid_value;
        private String _createdonbehalfby_value;
        private String description;
        private String _msdyn_slakpiid_value;
        private Long versionnumber;
        private String _modifiedonbehalfby_value;
        private String _ownerid_value;
        private String slaitemid;
        private String applicablewhenxml;
        private String _businesshoursid_value;
        private Integer failureafter;
        private OffsetDateTime overwritetime;
        private BigDecimal exchangerate;
        private String _workflowid_value;
        private OffsetDateTime createdon;
        private String applicableentity;
        private Integer componentstate;
        private String name;
        private String _owninguser_value;
        private String relatedfield;
        private String solutionid;
        private Integer sequencenumber;
        private Boolean ismanaged;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder successconditionsxml(String successconditionsxml) {
            this.successconditionsxml = successconditionsxml;
            this.changedFields = changedFields.add("successconditionsxml");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder warnafter(Integer warnafter) {
            this.warnafter = warnafter;
            this.changedFields = changedFields.add("warnafter");
            return this;
        }

        public Builder changedattributelist(String changedattributelist) {
            this.changedattributelist = changedattributelist;
            this.changedFields = changedFields.add("changedattributelist");
            return this;
        }

        public Builder actionurl(String actionurl) {
            this.actionurl = actionurl;
            this.changedFields = changedFields.add("actionurl");
            return this;
        }

        public Builder slaitemidunique(String slaitemidunique) {
            this.slaitemidunique = slaitemidunique;
            this.changedFields = changedFields.add("slaitemidunique");
            return this;
        }

        public Builder _slaid_value(String _slaid_value) {
            this._slaid_value = _slaid_value;
            this.changedFields = changedFields.add("_slaid_value");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder actionflowuniquename(String actionflowuniquename) {
            this.actionflowuniquename = actionflowuniquename;
            this.changedFields = changedFields.add("actionflowuniquename");
            return this;
        }

        public Builder allowpauseresume(Boolean allowpauseresume) {
            this.allowpauseresume = allowpauseresume;
            this.changedFields = changedFields.add("allowpauseresume");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder _msdyn_slakpiid_value(String _msdyn_slakpiid_value) {
            this._msdyn_slakpiid_value = _msdyn_slakpiid_value;
            this.changedFields = changedFields.add("_msdyn_slakpiid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder slaitemid(String slaitemid) {
            this.slaitemid = slaitemid;
            this.changedFields = changedFields.add("slaitemid");
            return this;
        }

        public Builder applicablewhenxml(String applicablewhenxml) {
            this.applicablewhenxml = applicablewhenxml;
            this.changedFields = changedFields.add("applicablewhenxml");
            return this;
        }

        public Builder _businesshoursid_value(String _businesshoursid_value) {
            this._businesshoursid_value = _businesshoursid_value;
            this.changedFields = changedFields.add("_businesshoursid_value");
            return this;
        }

        public Builder failureafter(Integer failureafter) {
            this.failureafter = failureafter;
            this.changedFields = changedFields.add("failureafter");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder _workflowid_value(String _workflowid_value) {
            this._workflowid_value = _workflowid_value;
            this.changedFields = changedFields.add("_workflowid_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder applicableentity(String applicableentity) {
            this.applicableentity = applicableentity;
            this.changedFields = changedFields.add("applicableentity");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder relatedfield(String relatedfield) {
            this.relatedfield = relatedfield;
            this.changedFields = changedFields.add("relatedfield");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder sequencenumber(Integer sequencenumber) {
            this.sequencenumber = sequencenumber;
            this.changedFields = changedFields.add("sequencenumber");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Slaitem build() {
            Slaitem _x = new Slaitem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.slaitem";
            _x.successconditionsxml = successconditionsxml;
            _x._createdby_value = _createdby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.warnafter = warnafter;
            _x.changedattributelist = changedattributelist;
            _x.actionurl = actionurl;
            _x.slaitemidunique = slaitemidunique;
            _x._slaid_value = _slaid_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.modifiedon = modifiedon;
            _x.actionflowuniquename = actionflowuniquename;
            _x.allowpauseresume = allowpauseresume;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.description = description;
            _x._msdyn_slakpiid_value = _msdyn_slakpiid_value;
            _x.versionnumber = versionnumber;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._ownerid_value = _ownerid_value;
            _x.slaitemid = slaitemid;
            _x.applicablewhenxml = applicablewhenxml;
            _x._businesshoursid_value = _businesshoursid_value;
            _x.failureafter = failureafter;
            _x.overwritetime = overwritetime;
            _x.exchangerate = exchangerate;
            _x._workflowid_value = _workflowid_value;
            _x.createdon = createdon;
            _x.applicableentity = applicableentity;
            _x.componentstate = componentstate;
            _x.name = name;
            _x._owninguser_value = _owninguser_value;
            _x.relatedfield = relatedfield;
            _x.solutionid = solutionid;
            _x.sequencenumber = sequencenumber;
            _x.ismanaged = ismanaged;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && slaitemid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(slaitemid.toString()));
        }
    }

    @Property(name="successconditionsxml")
    @JsonIgnore
    public Optional<String> getSuccessconditionsxml() {
        return Optional.ofNullable(successconditionsxml);
    }

    public Slaitem withSuccessconditionsxml(String successconditionsxml) {
        Checks.checkIsAscii(successconditionsxml);
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("successconditionsxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.successconditionsxml = successconditionsxml;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Slaitem with_createdby_value(String _createdby_value) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Slaitem with_modifiedby_value(String _modifiedby_value) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="warnafter")
    @JsonIgnore
    public Optional<Integer> getWarnafter() {
        return Optional.ofNullable(warnafter);
    }

    public Slaitem withWarnafter(Integer warnafter) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("warnafter");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.warnafter = warnafter;
        return _x;
    }

    @Property(name="changedattributelist")
    @JsonIgnore
    public Optional<String> getChangedattributelist() {
        return Optional.ofNullable(changedattributelist);
    }

    public Slaitem withChangedattributelist(String changedattributelist) {
        Checks.checkIsAscii(changedattributelist);
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("changedattributelist");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.changedattributelist = changedattributelist;
        return _x;
    }

    @Property(name="actionurl")
    @JsonIgnore
    public Optional<String> getActionurl() {
        return Optional.ofNullable(actionurl);
    }

    public Slaitem withActionurl(String actionurl) {
        Checks.checkIsAscii(actionurl);
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("actionurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.actionurl = actionurl;
        return _x;
    }

    @Property(name="slaitemidunique")
    @JsonIgnore
    public Optional<String> getSlaitemidunique() {
        return Optional.ofNullable(slaitemidunique);
    }

    public Slaitem withSlaitemidunique(String slaitemidunique) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("slaitemidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.slaitemidunique = slaitemidunique;
        return _x;
    }

    @Property(name="_slaid_value")
    @JsonIgnore
    public Optional<String> get_slaid_value() {
        return Optional.ofNullable(_slaid_value);
    }

    public Slaitem with_slaid_value(String _slaid_value) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("_slaid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x._slaid_value = _slaid_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Slaitem with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Slaitem withModifiedon(OffsetDateTime modifiedon) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="actionflowuniquename")
    @JsonIgnore
    public Optional<String> getActionflowuniquename() {
        return Optional.ofNullable(actionflowuniquename);
    }

    public Slaitem withActionflowuniquename(String actionflowuniquename) {
        Checks.checkIsAscii(actionflowuniquename);
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("actionflowuniquename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.actionflowuniquename = actionflowuniquename;
        return _x;
    }

    @Property(name="allowpauseresume")
    @JsonIgnore
    public Optional<Boolean> getAllowpauseresume() {
        return Optional.ofNullable(allowpauseresume);
    }

    public Slaitem withAllowpauseresume(Boolean allowpauseresume) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("allowpauseresume");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.allowpauseresume = allowpauseresume;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Slaitem with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Slaitem with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Slaitem withDescription(String description) {
        Checks.checkIsAscii(description);
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.description = description;
        return _x;
    }

    @Property(name="_msdyn_slakpiid_value")
    @JsonIgnore
    public Optional<String> get_msdyn_slakpiid_value() {
        return Optional.ofNullable(_msdyn_slakpiid_value);
    }

    public Slaitem with_msdyn_slakpiid_value(String _msdyn_slakpiid_value) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_slakpiid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x._msdyn_slakpiid_value = _msdyn_slakpiid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Slaitem withVersionnumber(Long versionnumber) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Slaitem with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Slaitem with_ownerid_value(String _ownerid_value) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="slaitemid")
    @JsonIgnore
    public Optional<String> getSlaitemid() {
        return Optional.ofNullable(slaitemid);
    }

    public Slaitem withSlaitemid(String slaitemid) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("slaitemid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.slaitemid = slaitemid;
        return _x;
    }

    @Property(name="applicablewhenxml")
    @JsonIgnore
    public Optional<String> getApplicablewhenxml() {
        return Optional.ofNullable(applicablewhenxml);
    }

    public Slaitem withApplicablewhenxml(String applicablewhenxml) {
        Checks.checkIsAscii(applicablewhenxml);
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("applicablewhenxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.applicablewhenxml = applicablewhenxml;
        return _x;
    }

    @Property(name="_businesshoursid_value")
    @JsonIgnore
    public Optional<String> get_businesshoursid_value() {
        return Optional.ofNullable(_businesshoursid_value);
    }

    public Slaitem with_businesshoursid_value(String _businesshoursid_value) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("_businesshoursid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x._businesshoursid_value = _businesshoursid_value;
        return _x;
    }

    @Property(name="failureafter")
    @JsonIgnore
    public Optional<Integer> getFailureafter() {
        return Optional.ofNullable(failureafter);
    }

    public Slaitem withFailureafter(Integer failureafter) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("failureafter");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.failureafter = failureafter;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Slaitem withOverwritetime(OffsetDateTime overwritetime) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Slaitem withExchangerate(BigDecimal exchangerate) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="_workflowid_value")
    @JsonIgnore
    public Optional<String> get_workflowid_value() {
        return Optional.ofNullable(_workflowid_value);
    }

    public Slaitem with_workflowid_value(String _workflowid_value) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("_workflowid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x._workflowid_value = _workflowid_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Slaitem withCreatedon(OffsetDateTime createdon) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="applicableentity")
    @JsonIgnore
    public Optional<String> getApplicableentity() {
        return Optional.ofNullable(applicableentity);
    }

    public Slaitem withApplicableentity(String applicableentity) {
        Checks.checkIsAscii(applicableentity);
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("applicableentity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.applicableentity = applicableentity;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Slaitem withComponentstate(Integer componentstate) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Slaitem withName(String name) {
        Checks.checkIsAscii(name);
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.name = name;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Slaitem with_owninguser_value(String _owninguser_value) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="relatedfield")
    @JsonIgnore
    public Optional<String> getRelatedfield() {
        return Optional.ofNullable(relatedfield);
    }

    public Slaitem withRelatedfield(String relatedfield) {
        Checks.checkIsAscii(relatedfield);
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("relatedfield");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.relatedfield = relatedfield;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Slaitem withSolutionid(String solutionid) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="sequencenumber")
    @JsonIgnore
    public Optional<Integer> getSequencenumber() {
        return Optional.ofNullable(sequencenumber);
    }

    public Slaitem withSequencenumber(Integer sequencenumber) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("sequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.sequencenumber = sequencenumber;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Slaitem withIsmanaged(Boolean ismanaged) {
        Slaitem _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.slaitem");
        _x.ismanaged = ismanaged;
        return _x;
    }

    public Slaitem withUnmappedField(String name, String value) {
        Slaitem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="workflowid")
    @JsonIgnore
    public WorkflowRequest getWorkflowid() {
        return new WorkflowRequest(contextPath.addSegment("workflowid"), RequestHelper.getValue(unmappedFields, "workflowid"));
    }

    @NavigationProperty(name="SLAItem_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getSLAItem_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SLAItem_SyncErrors"), RequestHelper.getValue(unmappedFields, "SLAItem_SyncErrors"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="slaid")
    @JsonIgnore
    public SlaRequest getSlaid() {
        return new SlaRequest(contextPath.addSegment("slaid"), RequestHelper.getValue(unmappedFields, "slaid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="businesshoursid")
    @JsonIgnore
    public CalendarRequest getBusinesshoursid() {
        return new CalendarRequest(contextPath.addSegment("businesshoursid"), RequestHelper.getValue(unmappedFields, "businesshoursid"));
    }

    @NavigationProperty(name="msdyn_SLAKPIID")
    @JsonIgnore
    public Msdyn_slakpiRequest getMsdyn_SLAKPIID() {
        return new Msdyn_slakpiRequest(contextPath.addSegment("msdyn_SLAKPIID"), RequestHelper.getValue(unmappedFields, "msdyn_SLAKPIID"));
    }

    @NavigationProperty(name="msdyn_slaitem_slakpiinstance")
    @JsonIgnore
    public SlakpiinstanceCollectionRequest getMsdyn_slaitem_slakpiinstance() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("msdyn_slaitem_slakpiinstance"), RequestHelper.getValue(unmappedFields, "msdyn_slaitem_slakpiinstance"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Slaitem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Slaitem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Slaitem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Slaitem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Slaitem _copy() {
        Slaitem _x = new Slaitem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.successconditionsxml = successconditionsxml;
        _x._createdby_value = _createdby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.warnafter = warnafter;
        _x.changedattributelist = changedattributelist;
        _x.actionurl = actionurl;
        _x.slaitemidunique = slaitemidunique;
        _x._slaid_value = _slaid_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.modifiedon = modifiedon;
        _x.actionflowuniquename = actionflowuniquename;
        _x.allowpauseresume = allowpauseresume;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.description = description;
        _x._msdyn_slakpiid_value = _msdyn_slakpiid_value;
        _x.versionnumber = versionnumber;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._ownerid_value = _ownerid_value;
        _x.slaitemid = slaitemid;
        _x.applicablewhenxml = applicablewhenxml;
        _x._businesshoursid_value = _businesshoursid_value;
        _x.failureafter = failureafter;
        _x.overwritetime = overwritetime;
        _x.exchangerate = exchangerate;
        _x._workflowid_value = _workflowid_value;
        _x.createdon = createdon;
        _x.applicableentity = applicableentity;
        _x.componentstate = componentstate;
        _x.name = name;
        _x._owninguser_value = _owninguser_value;
        _x.relatedfield = relatedfield;
        _x.solutionid = solutionid;
        _x.sequencenumber = sequencenumber;
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Slaitem[");
        b.append("successconditionsxml=");
        b.append(this.successconditionsxml);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("warnafter=");
        b.append(this.warnafter);
        b.append(", ");
        b.append("changedattributelist=");
        b.append(this.changedattributelist);
        b.append(", ");
        b.append("actionurl=");
        b.append(this.actionurl);
        b.append(", ");
        b.append("slaitemidunique=");
        b.append(this.slaitemidunique);
        b.append(", ");
        b.append("_slaid_value=");
        b.append(this._slaid_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("actionflowuniquename=");
        b.append(this.actionflowuniquename);
        b.append(", ");
        b.append("allowpauseresume=");
        b.append(this.allowpauseresume);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("_msdyn_slakpiid_value=");
        b.append(this._msdyn_slakpiid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("slaitemid=");
        b.append(this.slaitemid);
        b.append(", ");
        b.append("applicablewhenxml=");
        b.append(this.applicablewhenxml);
        b.append(", ");
        b.append("_businesshoursid_value=");
        b.append(this._businesshoursid_value);
        b.append(", ");
        b.append("failureafter=");
        b.append(this.failureafter);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("_workflowid_value=");
        b.append(this._workflowid_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("applicableentity=");
        b.append(this.applicableentity);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("relatedfield=");
        b.append(this.relatedfield);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("sequencenumber=");
        b.append(this.sequencenumber);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
