package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.ReportRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "modifiedon", 
    "utcconversiontimezonecode", 
    "versionnumber", 
    "iscustomizable", 
    "ismanaged", 
    "reportcategoryid", 
    "overwritetime", 
    "_modifiedby_value", 
    "_createdonbehalfby_value", 
    "reportcategoryidunique", 
    "importsequencenumber", 
    "_ownerid_value", 
    "exchangerate", 
    "_modifiedonbehalfby_value", 
    "createdon", 
    "_createdby_value", 
    "_reportid_value", 
    "componentstate", 
    "_transactioncurrencyid_value", 
    "timezoneruleversionnumber", 
    "owningbusinessunit", 
    "solutionid", 
    "owninguser", 
    "categorycode"})
@JsonInclude(Include.NON_NULL)
public class Reportcategory extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.reportcategory";
    }

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("reportcategoryid")
    protected String reportcategoryid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("reportcategoryidunique")
    protected String reportcategoryidunique;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_reportid_value")
    protected String _reportid_value;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("owningbusinessunit")
    protected String owningbusinessunit;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("owninguser")
    protected String owninguser;

    @JsonProperty("categorycode")
    protected Integer categorycode;

    protected Reportcategory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderReportcategory() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime modifiedon;
        private Integer utcconversiontimezonecode;
        private Long versionnumber;
        private BooleanManagedProperty iscustomizable;
        private Boolean ismanaged;
        private String reportcategoryid;
        private OffsetDateTime overwritetime;
        private String _modifiedby_value;
        private String _createdonbehalfby_value;
        private String reportcategoryidunique;
        private Integer importsequencenumber;
        private String _ownerid_value;
        private BigDecimal exchangerate;
        private String _modifiedonbehalfby_value;
        private OffsetDateTime createdon;
        private String _createdby_value;
        private String _reportid_value;
        private Integer componentstate;
        private String _transactioncurrencyid_value;
        private Integer timezoneruleversionnumber;
        private String owningbusinessunit;
        private String solutionid;
        private String owninguser;
        private Integer categorycode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder reportcategoryid(String reportcategoryid) {
            this.reportcategoryid = reportcategoryid;
            this.changedFields = changedFields.add("reportcategoryid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder reportcategoryidunique(String reportcategoryidunique) {
            this.reportcategoryidunique = reportcategoryidunique;
            this.changedFields = changedFields.add("reportcategoryidunique");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _reportid_value(String _reportid_value) {
            this._reportid_value = _reportid_value;
            this.changedFields = changedFields.add("_reportid_value");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder owningbusinessunit(String owningbusinessunit) {
            this.owningbusinessunit = owningbusinessunit;
            this.changedFields = changedFields.add("owningbusinessunit");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder owninguser(String owninguser) {
            this.owninguser = owninguser;
            this.changedFields = changedFields.add("owninguser");
            return this;
        }

        public Builder categorycode(Integer categorycode) {
            this.categorycode = categorycode;
            this.changedFields = changedFields.add("categorycode");
            return this;
        }

        public Reportcategory build() {
            Reportcategory _x = new Reportcategory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.reportcategory";
            _x.modifiedon = modifiedon;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.versionnumber = versionnumber;
            _x.iscustomizable = iscustomizable;
            _x.ismanaged = ismanaged;
            _x.reportcategoryid = reportcategoryid;
            _x.overwritetime = overwritetime;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.reportcategoryidunique = reportcategoryidunique;
            _x.importsequencenumber = importsequencenumber;
            _x._ownerid_value = _ownerid_value;
            _x.exchangerate = exchangerate;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.createdon = createdon;
            _x._createdby_value = _createdby_value;
            _x._reportid_value = _reportid_value;
            _x.componentstate = componentstate;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.owningbusinessunit = owningbusinessunit;
            _x.solutionid = solutionid;
            _x.owninguser = owninguser;
            _x.categorycode = categorycode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && reportcategoryid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(reportcategoryid.toString()));
        }
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Reportcategory withModifiedon(OffsetDateTime modifiedon) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Reportcategory withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Reportcategory withVersionnumber(Long versionnumber) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Reportcategory withIscustomizable(BooleanManagedProperty iscustomizable) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Reportcategory withIsmanaged(Boolean ismanaged) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="reportcategoryid")
    @JsonIgnore
    public Optional<String> getReportcategoryid() {
        return Optional.ofNullable(reportcategoryid);
    }

    public Reportcategory withReportcategoryid(String reportcategoryid) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("reportcategoryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.reportcategoryid = reportcategoryid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Reportcategory withOverwritetime(OffsetDateTime overwritetime) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Reportcategory with_modifiedby_value(String _modifiedby_value) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Reportcategory with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="reportcategoryidunique")
    @JsonIgnore
    public Optional<String> getReportcategoryidunique() {
        return Optional.ofNullable(reportcategoryidunique);
    }

    public Reportcategory withReportcategoryidunique(String reportcategoryidunique) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("reportcategoryidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.reportcategoryidunique = reportcategoryidunique;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Reportcategory withImportsequencenumber(Integer importsequencenumber) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Reportcategory with_ownerid_value(String _ownerid_value) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Reportcategory withExchangerate(BigDecimal exchangerate) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Reportcategory with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Reportcategory withCreatedon(OffsetDateTime createdon) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Reportcategory with_createdby_value(String _createdby_value) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_reportid_value")
    @JsonIgnore
    public Optional<String> get_reportid_value() {
        return Optional.ofNullable(_reportid_value);
    }

    public Reportcategory with_reportid_value(String _reportid_value) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("_reportid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x._reportid_value = _reportid_value;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Reportcategory withComponentstate(Integer componentstate) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Reportcategory with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Reportcategory withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="owningbusinessunit")
    @JsonIgnore
    public Optional<String> getOwningbusinessunit() {
        return Optional.ofNullable(owningbusinessunit);
    }

    public Reportcategory withOwningbusinessunit(String owningbusinessunit) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("owningbusinessunit");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.owningbusinessunit = owningbusinessunit;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Reportcategory withSolutionid(String solutionid) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="owninguser")
    @JsonIgnore
    public Optional<String> getOwninguser() {
        return Optional.ofNullable(owninguser);
    }

    public Reportcategory withOwninguser(String owninguser) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("owninguser");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.owninguser = owninguser;
        return _x;
    }

    @Property(name="categorycode")
    @JsonIgnore
    public Optional<Integer> getCategorycode() {
        return Optional.ofNullable(categorycode);
    }

    public Reportcategory withCategorycode(Integer categorycode) {
        Reportcategory _x = _copy();
        _x.changedFields = changedFields.add("categorycode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.reportcategory");
        _x.categorycode = categorycode;
        return _x;
    }

    public Reportcategory withUnmappedField(String name, String value) {
        Reportcategory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="reportid")
    @JsonIgnore
    public ReportRequest getReportid() {
        return new ReportRequest(contextPath.addSegment("reportid"), RequestHelper.getValue(unmappedFields, "reportid"));
    }

    @NavigationProperty(name="reportcategory_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getReportcategory_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("reportcategory_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "reportcategory_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="ReportCategory_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getReportCategory_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ReportCategory_SyncErrors"), RequestHelper.getValue(unmappedFields, "ReportCategory_SyncErrors"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Reportcategory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Reportcategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Reportcategory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Reportcategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Reportcategory _copy() {
        Reportcategory _x = new Reportcategory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.modifiedon = modifiedon;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.versionnumber = versionnumber;
        _x.iscustomizable = iscustomizable;
        _x.ismanaged = ismanaged;
        _x.reportcategoryid = reportcategoryid;
        _x.overwritetime = overwritetime;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.reportcategoryidunique = reportcategoryidunique;
        _x.importsequencenumber = importsequencenumber;
        _x._ownerid_value = _ownerid_value;
        _x.exchangerate = exchangerate;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.createdon = createdon;
        _x._createdby_value = _createdby_value;
        _x._reportid_value = _reportid_value;
        _x.componentstate = componentstate;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.owningbusinessunit = owningbusinessunit;
        _x.solutionid = solutionid;
        _x.owninguser = owninguser;
        _x.categorycode = categorycode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Reportcategory[");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("reportcategoryid=");
        b.append(this.reportcategoryid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("reportcategoryidunique=");
        b.append(this.reportcategoryidunique);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_reportid_value=");
        b.append(this._reportid_value);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("owningbusinessunit=");
        b.append(this.owningbusinessunit);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("owninguser=");
        b.append(this.owninguser);
        b.append(", ");
        b.append("categorycode=");
        b.append(this.categorycode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
