package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "msdyn_componentlayerdatasourceid", 
    "msdyn_name"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_componentlayerdatasource extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_componentlayerdatasource";
    }

    @JsonProperty("msdyn_componentlayerdatasourceid")
    protected String msdyn_componentlayerdatasourceid;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    protected Msdyn_componentlayerdatasource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_componentlayerdatasource() {
        return new Builder();
    }

    public static final class Builder {
        private String msdyn_componentlayerdatasourceid;
        private String msdyn_name;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder msdyn_componentlayerdatasourceid(String msdyn_componentlayerdatasourceid) {
            this.msdyn_componentlayerdatasourceid = msdyn_componentlayerdatasourceid;
            this.changedFields = changedFields.add("msdyn_componentlayerdatasourceid");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Msdyn_componentlayerdatasource build() {
            Msdyn_componentlayerdatasource _x = new Msdyn_componentlayerdatasource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_componentlayerdatasource";
            _x.msdyn_componentlayerdatasourceid = msdyn_componentlayerdatasourceid;
            _x.msdyn_name = msdyn_name;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_componentlayerdatasourceid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_componentlayerdatasourceid.toString()));
        }
    }

    @Property(name="msdyn_componentlayerdatasourceid")
    @JsonIgnore
    public Optional<String> getMsdyn_componentlayerdatasourceid() {
        return Optional.ofNullable(msdyn_componentlayerdatasourceid);
    }

    public Msdyn_componentlayerdatasource withMsdyn_componentlayerdatasourceid(String msdyn_componentlayerdatasourceid) {
        Msdyn_componentlayerdatasource _x = _copy();
        _x.changedFields = changedFields.add("msdyn_componentlayerdatasourceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_componentlayerdatasource");
        _x.msdyn_componentlayerdatasourceid = msdyn_componentlayerdatasourceid;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_componentlayerdatasource withMsdyn_name(String msdyn_name) {
        Checks.checkIsAscii(msdyn_name);
        Msdyn_componentlayerdatasource _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_componentlayerdatasource");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    public Msdyn_componentlayerdatasource withUnmappedField(String name, String value) {
        Msdyn_componentlayerdatasource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_componentlayerdatasource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_componentlayerdatasource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_componentlayerdatasource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_componentlayerdatasource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_componentlayerdatasource _copy() {
        Msdyn_componentlayerdatasource _x = new Msdyn_componentlayerdatasource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.msdyn_componentlayerdatasourceid = msdyn_componentlayerdatasourceid;
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_componentlayerdatasource[");
        b.append("msdyn_componentlayerdatasourceid=");
        b.append(this.msdyn_componentlayerdatasourceid);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
