package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_crewCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_team_applicationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Ggw_eventRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_owningteam_value", 
    "statuscode", 
    "ggw_open_for_signup", 
    "_owningbusinessunit_value", 
    "importsequencenumber", 
    "ggw_hidden", 
    "utcconversiontimezonecode", 
    "statecode", 
    "createdon", 
    "versionnumber", 
    "modifiedon", 
    "_createdby_value", 
    "_modifiedonbehalfby_value", 
    "_modifiedby_value", 
    "_createdonbehalfby_value", 
    "_ggw_eventid_value", 
    "ggw_description", 
    "timezoneruleversionnumber", 
    "_owninguser_value", 
    "overriddencreatedon", 
    "_ownerid_value", 
    "ggw_teamid", 
    "ggw_name", 
    "ggw_sendgrid_id"})
@JsonInclude(Include.NON_NULL)
public class Ggw_team extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ggw_team";
    }

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("ggw_open_for_signup")
    protected Boolean ggw_open_for_signup;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("ggw_hidden")
    protected Boolean ggw_hidden;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("_ggw_eventid_value")
    protected String _ggw_eventid_value;

    @JsonProperty("ggw_description")
    protected String ggw_description;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("ggw_teamid")
    protected String ggw_teamid;

    @JsonProperty("ggw_name")
    protected String ggw_name;

    @JsonProperty("ggw_sendgrid_id")
    protected String ggw_sendgrid_id;

    protected Ggw_team() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGgw_team() {
        return new Builder();
    }

    public static final class Builder {
        private String _owningteam_value;
        private Integer statuscode;
        private Boolean ggw_open_for_signup;
        private String _owningbusinessunit_value;
        private Integer importsequencenumber;
        private Boolean ggw_hidden;
        private Integer utcconversiontimezonecode;
        private Integer statecode;
        private OffsetDateTime createdon;
        private Long versionnumber;
        private OffsetDateTime modifiedon;
        private String _createdby_value;
        private String _modifiedonbehalfby_value;
        private String _modifiedby_value;
        private String _createdonbehalfby_value;
        private String _ggw_eventid_value;
        private String ggw_description;
        private Integer timezoneruleversionnumber;
        private String _owninguser_value;
        private OffsetDateTime overriddencreatedon;
        private String _ownerid_value;
        private String ggw_teamid;
        private String ggw_name;
        private String ggw_sendgrid_id;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder ggw_open_for_signup(Boolean ggw_open_for_signup) {
            this.ggw_open_for_signup = ggw_open_for_signup;
            this.changedFields = changedFields.add("ggw_open_for_signup");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder ggw_hidden(Boolean ggw_hidden) {
            this.ggw_hidden = ggw_hidden;
            this.changedFields = changedFields.add("ggw_hidden");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _ggw_eventid_value(String _ggw_eventid_value) {
            this._ggw_eventid_value = _ggw_eventid_value;
            this.changedFields = changedFields.add("_ggw_eventid_value");
            return this;
        }

        public Builder ggw_description(String ggw_description) {
            this.ggw_description = ggw_description;
            this.changedFields = changedFields.add("ggw_description");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder ggw_teamid(String ggw_teamid) {
            this.ggw_teamid = ggw_teamid;
            this.changedFields = changedFields.add("ggw_teamid");
            return this;
        }

        public Builder ggw_name(String ggw_name) {
            this.ggw_name = ggw_name;
            this.changedFields = changedFields.add("ggw_name");
            return this;
        }

        public Builder ggw_sendgrid_id(String ggw_sendgrid_id) {
            this.ggw_sendgrid_id = ggw_sendgrid_id;
            this.changedFields = changedFields.add("ggw_sendgrid_id");
            return this;
        }

        public Ggw_team build() {
            Ggw_team _x = new Ggw_team();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ggw_team";
            _x._owningteam_value = _owningteam_value;
            _x.statuscode = statuscode;
            _x.ggw_open_for_signup = ggw_open_for_signup;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.importsequencenumber = importsequencenumber;
            _x.ggw_hidden = ggw_hidden;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.statecode = statecode;
            _x.createdon = createdon;
            _x.versionnumber = versionnumber;
            _x.modifiedon = modifiedon;
            _x._createdby_value = _createdby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._ggw_eventid_value = _ggw_eventid_value;
            _x.ggw_description = ggw_description;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._owninguser_value = _owninguser_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x._ownerid_value = _ownerid_value;
            _x.ggw_teamid = ggw_teamid;
            _x.ggw_name = ggw_name;
            _x.ggw_sendgrid_id = ggw_sendgrid_id;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && ggw_teamid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(ggw_teamid.toString()));
        }
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Ggw_team with_owningteam_value(String _owningteam_value) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Ggw_team withStatuscode(Integer statuscode) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="ggw_open_for_signup")
    @JsonIgnore
    public Optional<Boolean> getGgw_open_for_signup() {
        return Optional.ofNullable(ggw_open_for_signup);
    }

    public Ggw_team withGgw_open_for_signup(Boolean ggw_open_for_signup) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("ggw_open_for_signup");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.ggw_open_for_signup = ggw_open_for_signup;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Ggw_team with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Ggw_team withImportsequencenumber(Integer importsequencenumber) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="ggw_hidden")
    @JsonIgnore
    public Optional<Boolean> getGgw_hidden() {
        return Optional.ofNullable(ggw_hidden);
    }

    public Ggw_team withGgw_hidden(Boolean ggw_hidden) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("ggw_hidden");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.ggw_hidden = ggw_hidden;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Ggw_team withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Ggw_team withStatecode(Integer statecode) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Ggw_team withCreatedon(OffsetDateTime createdon) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Ggw_team withVersionnumber(Long versionnumber) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Ggw_team withModifiedon(OffsetDateTime modifiedon) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Ggw_team with_createdby_value(String _createdby_value) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Ggw_team with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Ggw_team with_modifiedby_value(String _modifiedby_value) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Ggw_team with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_ggw_eventid_value")
    @JsonIgnore
    public Optional<String> get_ggw_eventid_value() {
        return Optional.ofNullable(_ggw_eventid_value);
    }

    public Ggw_team with_ggw_eventid_value(String _ggw_eventid_value) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("_ggw_eventid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x._ggw_eventid_value = _ggw_eventid_value;
        return _x;
    }

    @Property(name="ggw_description")
    @JsonIgnore
    public Optional<String> getGgw_description() {
        return Optional.ofNullable(ggw_description);
    }

    public Ggw_team withGgw_description(String ggw_description) {
        Checks.checkIsAscii(ggw_description);
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("ggw_description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.ggw_description = ggw_description;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Ggw_team withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Ggw_team with_owninguser_value(String _owninguser_value) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Ggw_team withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Ggw_team with_ownerid_value(String _ownerid_value) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="ggw_teamid")
    @JsonIgnore
    public Optional<String> getGgw_teamid() {
        return Optional.ofNullable(ggw_teamid);
    }

    public Ggw_team withGgw_teamid(String ggw_teamid) {
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("ggw_teamid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.ggw_teamid = ggw_teamid;
        return _x;
    }

    @Property(name="ggw_name")
    @JsonIgnore
    public Optional<String> getGgw_name() {
        return Optional.ofNullable(ggw_name);
    }

    public Ggw_team withGgw_name(String ggw_name) {
        Checks.checkIsAscii(ggw_name);
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("ggw_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.ggw_name = ggw_name;
        return _x;
    }

    @Property(name="ggw_sendgrid_id")
    @JsonIgnore
    public Optional<String> getGgw_sendgrid_id() {
        return Optional.ofNullable(ggw_sendgrid_id);
    }

    public Ggw_team withGgw_sendgrid_id(String ggw_sendgrid_id) {
        Checks.checkIsAscii(ggw_sendgrid_id);
        Ggw_team _x = _copy();
        _x.changedFields = changedFields.add("ggw_sendgrid_id");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team");
        _x.ggw_sendgrid_id = ggw_sendgrid_id;
        return _x;
    }

    public Ggw_team withUnmappedField(String name, String value) {
        Ggw_team _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="ggw_team_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getGgw_team_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ggw_team_SyncErrors"), RequestHelper.getValue(unmappedFields, "ggw_team_SyncErrors"));
    }

    @NavigationProperty(name="ggw_team_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getGgw_team_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("ggw_team_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "ggw_team_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="ggw_team_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getGgw_team_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("ggw_team_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "ggw_team_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="ggw_team_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getGgw_team_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("ggw_team_AsyncOperations"), RequestHelper.getValue(unmappedFields, "ggw_team_AsyncOperations"));
    }

    @NavigationProperty(name="ggw_team_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getGgw_team_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("ggw_team_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "ggw_team_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="ggw_team_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getGgw_team_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("ggw_team_ProcessSession"), RequestHelper.getValue(unmappedFields, "ggw_team_ProcessSession"));
    }

    @NavigationProperty(name="ggw_team_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getGgw_team_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("ggw_team_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "ggw_team_BulkDeleteFailures"));
    }

    @NavigationProperty(name="ggw_team_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getGgw_team_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("ggw_team_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "ggw_team_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="ggw_EventId")
    @JsonIgnore
    public Ggw_eventRequest getGgw_EventId() {
        return new Ggw_eventRequest(contextPath.addSegment("ggw_EventId"), RequestHelper.getValue(unmappedFields, "ggw_EventId"));
    }

    @NavigationProperty(name="ggw_ggw_crew_ggw_team")
    @JsonIgnore
    public Ggw_crewCollectionRequest getGgw_ggw_crew_ggw_team() {
        return new Ggw_crewCollectionRequest(
                        contextPath.addSegment("ggw_ggw_crew_ggw_team"), RequestHelper.getValue(unmappedFields, "ggw_ggw_crew_ggw_team"));
    }

    @NavigationProperty(name="ggw_ggw_team_ggw_team_application")
    @JsonIgnore
    public Ggw_team_applicationCollectionRequest getGgw_ggw_team_ggw_team_application() {
        return new Ggw_team_applicationCollectionRequest(
                        contextPath.addSegment("ggw_ggw_team_ggw_team_application"), RequestHelper.getValue(unmappedFields, "ggw_ggw_team_ggw_team_application"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Ggw_team patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Ggw_team _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Ggw_team put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Ggw_team _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Ggw_team _copy() {
        Ggw_team _x = new Ggw_team();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._owningteam_value = _owningteam_value;
        _x.statuscode = statuscode;
        _x.ggw_open_for_signup = ggw_open_for_signup;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.importsequencenumber = importsequencenumber;
        _x.ggw_hidden = ggw_hidden;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.statecode = statecode;
        _x.createdon = createdon;
        _x.versionnumber = versionnumber;
        _x.modifiedon = modifiedon;
        _x._createdby_value = _createdby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._ggw_eventid_value = _ggw_eventid_value;
        _x.ggw_description = ggw_description;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._owninguser_value = _owninguser_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x._ownerid_value = _ownerid_value;
        _x.ggw_teamid = ggw_teamid;
        _x.ggw_name = ggw_name;
        _x.ggw_sendgrid_id = ggw_sendgrid_id;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Ggw_team[");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("ggw_open_for_signup=");
        b.append(this.ggw_open_for_signup);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("ggw_hidden=");
        b.append(this.ggw_hidden);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_ggw_eventid_value=");
        b.append(this._ggw_eventid_value);
        b.append(", ");
        b.append("ggw_description=");
        b.append(this.ggw_description);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("ggw_teamid=");
        b.append(this.ggw_teamid);
        b.append(", ");
        b.append("ggw_name=");
        b.append(this.ggw_name);
        b.append(", ");
        b.append("ggw_sendgrid_id=");
        b.append(this.ggw_sendgrid_id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
