package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.OrganizationRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_organizationid_value", 
    "count", 
    "optimizationstorage", 
    "optimizationstatus", 
    "dataperformanceid", 
    "lastactionresult", 
    "component", 
    "weight", 
    "mediantime", 
    "entity", 
    "anyoptimizationavailable", 
    "estimatedoptimizationimpact", 
    "solution", 
    "executionperiod", 
    "maxtime", 
    "anyoptimizationapplied", 
    "realizedoptimizationimpact", 
    "lastoptimizationdate", 
    "mintime", 
    "operation"})
@JsonInclude(Include.NON_NULL)
public class Dataperformance extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.dataperformance";
    }

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("count")
    protected Integer count;

    @JsonProperty("optimizationstorage")
    protected BigDecimal optimizationstorage;

    @JsonProperty("optimizationstatus")
    protected String optimizationstatus;

    @JsonProperty("dataperformanceid")
    protected String dataperformanceid;

    @JsonProperty("lastactionresult")
    protected String lastactionresult;

    @JsonProperty("component")
    protected String component;

    @JsonProperty("weight")
    protected BigDecimal weight;

    @JsonProperty("mediantime")
    protected BigDecimal mediantime;

    @JsonProperty("entity")
    protected String entity;

    @JsonProperty("anyoptimizationavailable")
    protected Boolean anyoptimizationavailable;

    @JsonProperty("estimatedoptimizationimpact")
    protected BigDecimal estimatedoptimizationimpact;

    @JsonProperty("solution")
    protected String solution;

    @JsonProperty("executionperiod")
    protected String executionperiod;

    @JsonProperty("maxtime")
    protected BigDecimal maxtime;

    @JsonProperty("anyoptimizationapplied")
    protected Boolean anyoptimizationapplied;

    @JsonProperty("realizedoptimizationimpact")
    protected String realizedoptimizationimpact;

    @JsonProperty("lastoptimizationdate")
    protected OffsetDateTime lastoptimizationdate;

    @JsonProperty("mintime")
    protected BigDecimal mintime;

    @JsonProperty("operation")
    protected String operation;

    protected Dataperformance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDataperformance() {
        return new Builder();
    }

    public static final class Builder {
        private String _organizationid_value;
        private Integer count;
        private BigDecimal optimizationstorage;
        private String optimizationstatus;
        private String dataperformanceid;
        private String lastactionresult;
        private String component;
        private BigDecimal weight;
        private BigDecimal mediantime;
        private String entity;
        private Boolean anyoptimizationavailable;
        private BigDecimal estimatedoptimizationimpact;
        private String solution;
        private String executionperiod;
        private BigDecimal maxtime;
        private Boolean anyoptimizationapplied;
        private String realizedoptimizationimpact;
        private OffsetDateTime lastoptimizationdate;
        private BigDecimal mintime;
        private String operation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.changedFields = changedFields.add("count");
            return this;
        }

        public Builder optimizationstorage(BigDecimal optimizationstorage) {
            this.optimizationstorage = optimizationstorage;
            this.changedFields = changedFields.add("optimizationstorage");
            return this;
        }

        public Builder optimizationstatus(String optimizationstatus) {
            this.optimizationstatus = optimizationstatus;
            this.changedFields = changedFields.add("optimizationstatus");
            return this;
        }

        public Builder dataperformanceid(String dataperformanceid) {
            this.dataperformanceid = dataperformanceid;
            this.changedFields = changedFields.add("dataperformanceid");
            return this;
        }

        public Builder lastactionresult(String lastactionresult) {
            this.lastactionresult = lastactionresult;
            this.changedFields = changedFields.add("lastactionresult");
            return this;
        }

        public Builder component(String component) {
            this.component = component;
            this.changedFields = changedFields.add("component");
            return this;
        }

        public Builder weight(BigDecimal weight) {
            this.weight = weight;
            this.changedFields = changedFields.add("weight");
            return this;
        }

        public Builder mediantime(BigDecimal mediantime) {
            this.mediantime = mediantime;
            this.changedFields = changedFields.add("mediantime");
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            this.changedFields = changedFields.add("entity");
            return this;
        }

        public Builder anyoptimizationavailable(Boolean anyoptimizationavailable) {
            this.anyoptimizationavailable = anyoptimizationavailable;
            this.changedFields = changedFields.add("anyoptimizationavailable");
            return this;
        }

        public Builder estimatedoptimizationimpact(BigDecimal estimatedoptimizationimpact) {
            this.estimatedoptimizationimpact = estimatedoptimizationimpact;
            this.changedFields = changedFields.add("estimatedoptimizationimpact");
            return this;
        }

        public Builder solution(String solution) {
            this.solution = solution;
            this.changedFields = changedFields.add("solution");
            return this;
        }

        public Builder executionperiod(String executionperiod) {
            this.executionperiod = executionperiod;
            this.changedFields = changedFields.add("executionperiod");
            return this;
        }

        public Builder maxtime(BigDecimal maxtime) {
            this.maxtime = maxtime;
            this.changedFields = changedFields.add("maxtime");
            return this;
        }

        public Builder anyoptimizationapplied(Boolean anyoptimizationapplied) {
            this.anyoptimizationapplied = anyoptimizationapplied;
            this.changedFields = changedFields.add("anyoptimizationapplied");
            return this;
        }

        public Builder realizedoptimizationimpact(String realizedoptimizationimpact) {
            this.realizedoptimizationimpact = realizedoptimizationimpact;
            this.changedFields = changedFields.add("realizedoptimizationimpact");
            return this;
        }

        public Builder lastoptimizationdate(OffsetDateTime lastoptimizationdate) {
            this.lastoptimizationdate = lastoptimizationdate;
            this.changedFields = changedFields.add("lastoptimizationdate");
            return this;
        }

        public Builder mintime(BigDecimal mintime) {
            this.mintime = mintime;
            this.changedFields = changedFields.add("mintime");
            return this;
        }

        public Builder operation(String operation) {
            this.operation = operation;
            this.changedFields = changedFields.add("operation");
            return this;
        }

        public Dataperformance build() {
            Dataperformance _x = new Dataperformance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.dataperformance";
            _x._organizationid_value = _organizationid_value;
            _x.count = count;
            _x.optimizationstorage = optimizationstorage;
            _x.optimizationstatus = optimizationstatus;
            _x.dataperformanceid = dataperformanceid;
            _x.lastactionresult = lastactionresult;
            _x.component = component;
            _x.weight = weight;
            _x.mediantime = mediantime;
            _x.entity = entity;
            _x.anyoptimizationavailable = anyoptimizationavailable;
            _x.estimatedoptimizationimpact = estimatedoptimizationimpact;
            _x.solution = solution;
            _x.executionperiod = executionperiod;
            _x.maxtime = maxtime;
            _x.anyoptimizationapplied = anyoptimizationapplied;
            _x.realizedoptimizationimpact = realizedoptimizationimpact;
            _x.lastoptimizationdate = lastoptimizationdate;
            _x.mintime = mintime;
            _x.operation = operation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && dataperformanceid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(dataperformanceid.toString()));
        }
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Dataperformance with_organizationid_value(String _organizationid_value) {
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="count")
    @JsonIgnore
    public Optional<Integer> getCount() {
        return Optional.ofNullable(count);
    }

    public Dataperformance withCount(Integer count) {
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("count");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.count = count;
        return _x;
    }

    @Property(name="optimizationstorage")
    @JsonIgnore
    public Optional<BigDecimal> getOptimizationstorage() {
        return Optional.ofNullable(optimizationstorage);
    }

    public Dataperformance withOptimizationstorage(BigDecimal optimizationstorage) {
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("optimizationstorage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.optimizationstorage = optimizationstorage;
        return _x;
    }

    @Property(name="optimizationstatus")
    @JsonIgnore
    public Optional<String> getOptimizationstatus() {
        return Optional.ofNullable(optimizationstatus);
    }

    public Dataperformance withOptimizationstatus(String optimizationstatus) {
        Checks.checkIsAscii(optimizationstatus);
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("optimizationstatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.optimizationstatus = optimizationstatus;
        return _x;
    }

    @Property(name="dataperformanceid")
    @JsonIgnore
    public Optional<String> getDataperformanceid() {
        return Optional.ofNullable(dataperformanceid);
    }

    public Dataperformance withDataperformanceid(String dataperformanceid) {
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("dataperformanceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.dataperformanceid = dataperformanceid;
        return _x;
    }

    @Property(name="lastactionresult")
    @JsonIgnore
    public Optional<String> getLastactionresult() {
        return Optional.ofNullable(lastactionresult);
    }

    public Dataperformance withLastactionresult(String lastactionresult) {
        Checks.checkIsAscii(lastactionresult);
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("lastactionresult");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.lastactionresult = lastactionresult;
        return _x;
    }

    @Property(name="component")
    @JsonIgnore
    public Optional<String> getComponent() {
        return Optional.ofNullable(component);
    }

    public Dataperformance withComponent(String component) {
        Checks.checkIsAscii(component);
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("component");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.component = component;
        return _x;
    }

    @Property(name="weight")
    @JsonIgnore
    public Optional<BigDecimal> getWeight() {
        return Optional.ofNullable(weight);
    }

    public Dataperformance withWeight(BigDecimal weight) {
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("weight");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.weight = weight;
        return _x;
    }

    @Property(name="mediantime")
    @JsonIgnore
    public Optional<BigDecimal> getMediantime() {
        return Optional.ofNullable(mediantime);
    }

    public Dataperformance withMediantime(BigDecimal mediantime) {
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("mediantime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.mediantime = mediantime;
        return _x;
    }

    @Property(name="entity")
    @JsonIgnore
    public Optional<String> getEntity() {
        return Optional.ofNullable(entity);
    }

    public Dataperformance withEntity(String entity) {
        Checks.checkIsAscii(entity);
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("entity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.entity = entity;
        return _x;
    }

    @Property(name="anyoptimizationavailable")
    @JsonIgnore
    public Optional<Boolean> getAnyoptimizationavailable() {
        return Optional.ofNullable(anyoptimizationavailable);
    }

    public Dataperformance withAnyoptimizationavailable(Boolean anyoptimizationavailable) {
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("anyoptimizationavailable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.anyoptimizationavailable = anyoptimizationavailable;
        return _x;
    }

    @Property(name="estimatedoptimizationimpact")
    @JsonIgnore
    public Optional<BigDecimal> getEstimatedoptimizationimpact() {
        return Optional.ofNullable(estimatedoptimizationimpact);
    }

    public Dataperformance withEstimatedoptimizationimpact(BigDecimal estimatedoptimizationimpact) {
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("estimatedoptimizationimpact");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.estimatedoptimizationimpact = estimatedoptimizationimpact;
        return _x;
    }

    @Property(name="solution")
    @JsonIgnore
    public Optional<String> getSolution() {
        return Optional.ofNullable(solution);
    }

    public Dataperformance withSolution(String solution) {
        Checks.checkIsAscii(solution);
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("solution");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.solution = solution;
        return _x;
    }

    @Property(name="executionperiod")
    @JsonIgnore
    public Optional<String> getExecutionperiod() {
        return Optional.ofNullable(executionperiod);
    }

    public Dataperformance withExecutionperiod(String executionperiod) {
        Checks.checkIsAscii(executionperiod);
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("executionperiod");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.executionperiod = executionperiod;
        return _x;
    }

    @Property(name="maxtime")
    @JsonIgnore
    public Optional<BigDecimal> getMaxtime() {
        return Optional.ofNullable(maxtime);
    }

    public Dataperformance withMaxtime(BigDecimal maxtime) {
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("maxtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.maxtime = maxtime;
        return _x;
    }

    @Property(name="anyoptimizationapplied")
    @JsonIgnore
    public Optional<Boolean> getAnyoptimizationapplied() {
        return Optional.ofNullable(anyoptimizationapplied);
    }

    public Dataperformance withAnyoptimizationapplied(Boolean anyoptimizationapplied) {
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("anyoptimizationapplied");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.anyoptimizationapplied = anyoptimizationapplied;
        return _x;
    }

    @Property(name="realizedoptimizationimpact")
    @JsonIgnore
    public Optional<String> getRealizedoptimizationimpact() {
        return Optional.ofNullable(realizedoptimizationimpact);
    }

    public Dataperformance withRealizedoptimizationimpact(String realizedoptimizationimpact) {
        Checks.checkIsAscii(realizedoptimizationimpact);
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("realizedoptimizationimpact");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.realizedoptimizationimpact = realizedoptimizationimpact;
        return _x;
    }

    @Property(name="lastoptimizationdate")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastoptimizationdate() {
        return Optional.ofNullable(lastoptimizationdate);
    }

    public Dataperformance withLastoptimizationdate(OffsetDateTime lastoptimizationdate) {
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("lastoptimizationdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.lastoptimizationdate = lastoptimizationdate;
        return _x;
    }

    @Property(name="mintime")
    @JsonIgnore
    public Optional<BigDecimal> getMintime() {
        return Optional.ofNullable(mintime);
    }

    public Dataperformance withMintime(BigDecimal mintime) {
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("mintime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.mintime = mintime;
        return _x;
    }

    @Property(name="operation")
    @JsonIgnore
    public Optional<String> getOperation() {
        return Optional.ofNullable(operation);
    }

    public Dataperformance withOperation(String operation) {
        Checks.checkIsAscii(operation);
        Dataperformance _x = _copy();
        _x.changedFields = changedFields.add("operation");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.dataperformance");
        _x.operation = operation;
        return _x;
    }

    public Dataperformance withUnmappedField(String name, String value) {
        Dataperformance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Dataperformance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Dataperformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Dataperformance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Dataperformance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Dataperformance _copy() {
        Dataperformance _x = new Dataperformance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._organizationid_value = _organizationid_value;
        _x.count = count;
        _x.optimizationstorage = optimizationstorage;
        _x.optimizationstatus = optimizationstatus;
        _x.dataperformanceid = dataperformanceid;
        _x.lastactionresult = lastactionresult;
        _x.component = component;
        _x.weight = weight;
        _x.mediantime = mediantime;
        _x.entity = entity;
        _x.anyoptimizationavailable = anyoptimizationavailable;
        _x.estimatedoptimizationimpact = estimatedoptimizationimpact;
        _x.solution = solution;
        _x.executionperiod = executionperiod;
        _x.maxtime = maxtime;
        _x.anyoptimizationapplied = anyoptimizationapplied;
        _x.realizedoptimizationimpact = realizedoptimizationimpact;
        _x.lastoptimizationdate = lastoptimizationdate;
        _x.mintime = mintime;
        _x.operation = operation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Dataperformance[");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("count=");
        b.append(this.count);
        b.append(", ");
        b.append("optimizationstorage=");
        b.append(this.optimizationstorage);
        b.append(", ");
        b.append("optimizationstatus=");
        b.append(this.optimizationstatus);
        b.append(", ");
        b.append("dataperformanceid=");
        b.append(this.dataperformanceid);
        b.append(", ");
        b.append("lastactionresult=");
        b.append(this.lastactionresult);
        b.append(", ");
        b.append("component=");
        b.append(this.component);
        b.append(", ");
        b.append("weight=");
        b.append(this.weight);
        b.append(", ");
        b.append("mediantime=");
        b.append(this.mediantime);
        b.append(", ");
        b.append("entity=");
        b.append(this.entity);
        b.append(", ");
        b.append("anyoptimizationavailable=");
        b.append(this.anyoptimizationavailable);
        b.append(", ");
        b.append("estimatedoptimizationimpact=");
        b.append(this.estimatedoptimizationimpact);
        b.append(", ");
        b.append("solution=");
        b.append(this.solution);
        b.append(", ");
        b.append("executionperiod=");
        b.append(this.executionperiod);
        b.append(", ");
        b.append("maxtime=");
        b.append(this.maxtime);
        b.append(", ");
        b.append("anyoptimizationapplied=");
        b.append(this.anyoptimizationapplied);
        b.append(", ");
        b.append("realizedoptimizationimpact=");
        b.append(this.realizedoptimizationimpact);
        b.append(", ");
        b.append("lastoptimizationdate=");
        b.append(this.lastoptimizationdate);
        b.append(", ");
        b.append("mintime=");
        b.append(this.mintime);
        b.append(", ");
        b.append("operation=");
        b.append(this.operation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
