package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "channelaccessprofileentityaccesslevelid", 
    "componentstate", 
    "versionnumber", 
    "entityaccesslevelid", 
    "channelaccessprofileid", 
    "overwritetime", 
    "solutionid", 
    "ismanaged", 
    "channelaccessprofileentityaccesslevelidunique", 
    "entityaccessleveldepthmask"})
@JsonInclude(Include.NON_NULL)
public class Channelaccessprofileentityaccesslevel extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.channelaccessprofileentityaccesslevel";
    }

    @JsonProperty("channelaccessprofileentityaccesslevelid")
    protected String channelaccessprofileentityaccesslevelid;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("entityaccesslevelid")
    protected String entityaccesslevelid;

    @JsonProperty("channelaccessprofileid")
    protected String channelaccessprofileid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("channelaccessprofileentityaccesslevelidunique")
    protected String channelaccessprofileentityaccesslevelidunique;

    @JsonProperty("entityaccessleveldepthmask")
    protected Integer entityaccessleveldepthmask;

    protected Channelaccessprofileentityaccesslevel() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderChannelaccessprofileentityaccesslevel() {
        return new Builder();
    }

    public static final class Builder {
        private String channelaccessprofileentityaccesslevelid;
        private Integer componentstate;
        private Long versionnumber;
        private String entityaccesslevelid;
        private String channelaccessprofileid;
        private OffsetDateTime overwritetime;
        private String solutionid;
        private Boolean ismanaged;
        private String channelaccessprofileentityaccesslevelidunique;
        private Integer entityaccessleveldepthmask;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder channelaccessprofileentityaccesslevelid(String channelaccessprofileentityaccesslevelid) {
            this.channelaccessprofileentityaccesslevelid = channelaccessprofileentityaccesslevelid;
            this.changedFields = changedFields.add("channelaccessprofileentityaccesslevelid");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder entityaccesslevelid(String entityaccesslevelid) {
            this.entityaccesslevelid = entityaccesslevelid;
            this.changedFields = changedFields.add("entityaccesslevelid");
            return this;
        }

        public Builder channelaccessprofileid(String channelaccessprofileid) {
            this.channelaccessprofileid = channelaccessprofileid;
            this.changedFields = changedFields.add("channelaccessprofileid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder channelaccessprofileentityaccesslevelidunique(String channelaccessprofileentityaccesslevelidunique) {
            this.channelaccessprofileentityaccesslevelidunique = channelaccessprofileentityaccesslevelidunique;
            this.changedFields = changedFields.add("channelaccessprofileentityaccesslevelidunique");
            return this;
        }

        public Builder entityaccessleveldepthmask(Integer entityaccessleveldepthmask) {
            this.entityaccessleveldepthmask = entityaccessleveldepthmask;
            this.changedFields = changedFields.add("entityaccessleveldepthmask");
            return this;
        }

        public Channelaccessprofileentityaccesslevel build() {
            Channelaccessprofileentityaccesslevel _x = new Channelaccessprofileentityaccesslevel();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.channelaccessprofileentityaccesslevel";
            _x.channelaccessprofileentityaccesslevelid = channelaccessprofileentityaccesslevelid;
            _x.componentstate = componentstate;
            _x.versionnumber = versionnumber;
            _x.entityaccesslevelid = entityaccesslevelid;
            _x.channelaccessprofileid = channelaccessprofileid;
            _x.overwritetime = overwritetime;
            _x.solutionid = solutionid;
            _x.ismanaged = ismanaged;
            _x.channelaccessprofileentityaccesslevelidunique = channelaccessprofileentityaccesslevelidunique;
            _x.entityaccessleveldepthmask = entityaccessleveldepthmask;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && channelaccessprofileentityaccesslevelid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(channelaccessprofileentityaccesslevelid.toString()));
        }
    }

    @Property(name="channelaccessprofileentityaccesslevelid")
    @JsonIgnore
    public Optional<String> getChannelaccessprofileentityaccesslevelid() {
        return Optional.ofNullable(channelaccessprofileentityaccesslevelid);
    }

    public Channelaccessprofileentityaccesslevel withChannelaccessprofileentityaccesslevelid(String channelaccessprofileentityaccesslevelid) {
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.changedFields = changedFields.add("channelaccessprofileentityaccesslevelid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.channelaccessprofileentityaccesslevel");
        _x.channelaccessprofileentityaccesslevelid = channelaccessprofileentityaccesslevelid;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Channelaccessprofileentityaccesslevel withComponentstate(Integer componentstate) {
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.channelaccessprofileentityaccesslevel");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Channelaccessprofileentityaccesslevel withVersionnumber(Long versionnumber) {
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.channelaccessprofileentityaccesslevel");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="entityaccesslevelid")
    @JsonIgnore
    public Optional<String> getEntityaccesslevelid() {
        return Optional.ofNullable(entityaccesslevelid);
    }

    public Channelaccessprofileentityaccesslevel withEntityaccesslevelid(String entityaccesslevelid) {
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.changedFields = changedFields.add("entityaccesslevelid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.channelaccessprofileentityaccesslevel");
        _x.entityaccesslevelid = entityaccesslevelid;
        return _x;
    }

    @Property(name="channelaccessprofileid")
    @JsonIgnore
    public Optional<String> getChannelaccessprofileid() {
        return Optional.ofNullable(channelaccessprofileid);
    }

    public Channelaccessprofileentityaccesslevel withChannelaccessprofileid(String channelaccessprofileid) {
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.changedFields = changedFields.add("channelaccessprofileid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.channelaccessprofileentityaccesslevel");
        _x.channelaccessprofileid = channelaccessprofileid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Channelaccessprofileentityaccesslevel withOverwritetime(OffsetDateTime overwritetime) {
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.channelaccessprofileentityaccesslevel");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Channelaccessprofileentityaccesslevel withSolutionid(String solutionid) {
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.channelaccessprofileentityaccesslevel");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Channelaccessprofileentityaccesslevel withIsmanaged(Boolean ismanaged) {
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.channelaccessprofileentityaccesslevel");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="channelaccessprofileentityaccesslevelidunique")
    @JsonIgnore
    public Optional<String> getChannelaccessprofileentityaccesslevelidunique() {
        return Optional.ofNullable(channelaccessprofileentityaccesslevelidunique);
    }

    public Channelaccessprofileentityaccesslevel withChannelaccessprofileentityaccesslevelidunique(String channelaccessprofileentityaccesslevelidunique) {
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.changedFields = changedFields.add("channelaccessprofileentityaccesslevelidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.channelaccessprofileentityaccesslevel");
        _x.channelaccessprofileentityaccesslevelidunique = channelaccessprofileentityaccesslevelidunique;
        return _x;
    }

    @Property(name="entityaccessleveldepthmask")
    @JsonIgnore
    public Optional<Integer> getEntityaccessleveldepthmask() {
        return Optional.ofNullable(entityaccessleveldepthmask);
    }

    public Channelaccessprofileentityaccesslevel withEntityaccessleveldepthmask(Integer entityaccessleveldepthmask) {
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.changedFields = changedFields.add("entityaccessleveldepthmask");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.channelaccessprofileentityaccesslevel");
        _x.entityaccessleveldepthmask = entityaccessleveldepthmask;
        return _x;
    }

    public Channelaccessprofileentityaccesslevel withUnmappedField(String name, String value) {
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Channelaccessprofileentityaccesslevel patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Channelaccessprofileentityaccesslevel put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Channelaccessprofileentityaccesslevel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Channelaccessprofileentityaccesslevel _copy() {
        Channelaccessprofileentityaccesslevel _x = new Channelaccessprofileentityaccesslevel();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.channelaccessprofileentityaccesslevelid = channelaccessprofileentityaccesslevelid;
        _x.componentstate = componentstate;
        _x.versionnumber = versionnumber;
        _x.entityaccesslevelid = entityaccesslevelid;
        _x.channelaccessprofileid = channelaccessprofileid;
        _x.overwritetime = overwritetime;
        _x.solutionid = solutionid;
        _x.ismanaged = ismanaged;
        _x.channelaccessprofileentityaccesslevelidunique = channelaccessprofileentityaccesslevelidunique;
        _x.entityaccessleveldepthmask = entityaccessleveldepthmask;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Channelaccessprofileentityaccesslevel[");
        b.append("channelaccessprofileentityaccesslevelid=");
        b.append(this.channelaccessprofileentityaccesslevelid);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("entityaccesslevelid=");
        b.append(this.entityaccesslevelid);
        b.append(", ");
        b.append("channelaccessprofileid=");
        b.append(this.channelaccessprofileid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("channelaccessprofileentityaccesslevelidunique=");
        b.append(this.channelaccessprofileentityaccesslevelidunique);
        b.append(", ");
        b.append("entityaccessleveldepthmask=");
        b.append(this.entityaccessleveldepthmask);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
