package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.ActivitymimeattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "mimetype", 
    "filename", 
    "prefix", 
    "attachmentid", 
    "body", 
    "body_binary", 
    "filesize", 
    "subject", 
    "versionnumber"})
@JsonInclude(Include.NON_NULL)
public class Attachment extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.attachment";
    }

    @JsonProperty("mimetype")
    protected String mimetype;

    @JsonProperty("filename")
    protected String filename;

    @JsonProperty("prefix")
    protected String prefix;

    @JsonProperty("attachmentid")
    protected String attachmentid;

    @JsonProperty("body")
    protected String body;

    @JsonProperty("body_binary")
    protected byte[] body_binary;

    @JsonProperty("filesize")
    protected Integer filesize;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    protected Attachment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAttachment() {
        return new Builder();
    }

    public static final class Builder {
        private String mimetype;
        private String filename;
        private String prefix;
        private String attachmentid;
        private String body;
        private byte[] body_binary;
        private Integer filesize;
        private String subject;
        private Long versionnumber;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder mimetype(String mimetype) {
            this.mimetype = mimetype;
            this.changedFields = changedFields.add("mimetype");
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            this.changedFields = changedFields.add("filename");
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.changedFields = changedFields.add("prefix");
            return this;
        }

        public Builder attachmentid(String attachmentid) {
            this.attachmentid = attachmentid;
            this.changedFields = changedFields.add("attachmentid");
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder body_binary(byte[] body_binary) {
            this.body_binary = body_binary;
            this.changedFields = changedFields.add("body_binary");
            return this;
        }

        public Builder filesize(Integer filesize) {
            this.filesize = filesize;
            this.changedFields = changedFields.add("filesize");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Attachment build() {
            Attachment _x = new Attachment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.attachment";
            _x.mimetype = mimetype;
            _x.filename = filename;
            _x.prefix = prefix;
            _x.attachmentid = attachmentid;
            _x.body = body;
            _x.body_binary = body_binary;
            _x.filesize = filesize;
            _x.subject = subject;
            _x.versionnumber = versionnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && attachmentid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(attachmentid.toString()));
        }
    }

    @Property(name="mimetype")
    @JsonIgnore
    public Optional<String> getMimetype() {
        return Optional.ofNullable(mimetype);
    }

    public Attachment withMimetype(String mimetype) {
        Checks.checkIsAscii(mimetype);
        Attachment _x = _copy();
        _x.changedFields = changedFields.add("mimetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attachment");
        _x.mimetype = mimetype;
        return _x;
    }

    @Property(name="filename")
    @JsonIgnore
    public Optional<String> getFilename() {
        return Optional.ofNullable(filename);
    }

    public Attachment withFilename(String filename) {
        Checks.checkIsAscii(filename);
        Attachment _x = _copy();
        _x.changedFields = changedFields.add("filename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attachment");
        _x.filename = filename;
        return _x;
    }

    @Property(name="prefix")
    @JsonIgnore
    public Optional<String> getPrefix() {
        return Optional.ofNullable(prefix);
    }

    public Attachment withPrefix(String prefix) {
        Checks.checkIsAscii(prefix);
        Attachment _x = _copy();
        _x.changedFields = changedFields.add("prefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attachment");
        _x.prefix = prefix;
        return _x;
    }

    @Property(name="attachmentid")
    @JsonIgnore
    public Optional<String> getAttachmentid() {
        return Optional.ofNullable(attachmentid);
    }

    public Attachment withAttachmentid(String attachmentid) {
        Attachment _x = _copy();
        _x.changedFields = changedFields.add("attachmentid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attachment");
        _x.attachmentid = attachmentid;
        return _x;
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<String> getBody() {
        return Optional.ofNullable(body);
    }

    public Attachment withBody(String body) {
        Checks.checkIsAscii(body);
        Attachment _x = _copy();
        _x.changedFields = changedFields.add("body");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attachment");
        _x.body = body;
        return _x;
    }

    @Property(name="body_binary")
    @JsonIgnore
    public Optional<byte[]> getBody_binary() {
        return Optional.ofNullable(body_binary);
    }

    public Attachment withBody_binary(byte[] body_binary) {
        Attachment _x = _copy();
        _x.changedFields = changedFields.add("body_binary");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attachment");
        _x.body_binary = body_binary;
        return _x;
    }

    @Property(name="filesize")
    @JsonIgnore
    public Optional<Integer> getFilesize() {
        return Optional.ofNullable(filesize);
    }

    public Attachment withFilesize(Integer filesize) {
        Attachment _x = _copy();
        _x.changedFields = changedFields.add("filesize");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attachment");
        _x.filesize = filesize;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public Attachment withSubject(String subject) {
        Checks.checkIsAscii(subject);
        Attachment _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attachment");
        _x.subject = subject;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Attachment withVersionnumber(Long versionnumber) {
        Attachment _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.attachment");
        _x.versionnumber = versionnumber;
        return _x;
    }

    public Attachment withUnmappedField(String name, String value) {
        Attachment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Attachment_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getAttachment_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Attachment_SyncErrors"), RequestHelper.getValue(unmappedFields, "Attachment_SyncErrors"));
    }

    @NavigationProperty(name="attachment_activity_mime_attachments")
    @JsonIgnore
    public ActivitymimeattachmentCollectionRequest getAttachment_activity_mime_attachments() {
        return new ActivitymimeattachmentCollectionRequest(
                        contextPath.addSegment("attachment_activity_mime_attachments"), RequestHelper.getValue(unmappedFields, "attachment_activity_mime_attachments"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Attachment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Attachment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Attachment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Attachment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Attachment _copy() {
        Attachment _x = new Attachment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.mimetype = mimetype;
        _x.filename = filename;
        _x.prefix = prefix;
        _x.attachmentid = attachmentid;
        _x.body = body;
        _x.body_binary = body_binary;
        _x.filesize = filesize;
        _x.subject = subject;
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Attachment[");
        b.append("mimetype=");
        b.append(this.mimetype);
        b.append(", ");
        b.append("filename=");
        b.append(this.filename);
        b.append(", ");
        b.append("prefix=");
        b.append(this.prefix);
        b.append(", ");
        b.append("attachmentid=");
        b.append(this.attachmentid);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("body_binary=");
        b.append(this.body_binary);
        b.append(", ");
        b.append("filesize=");
        b.append(this.filesize);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
