package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;

@JsonPropertyOrder({
    "@odata.type", 
    "componentstate", 
    "iscustomizable", 
    "componentidunique", 
    "versionnumber", 
    "roleid", 
    "ismanaged", 
    "solutionid", 
    "overwritetime", 
    "applicationuserroleid", 
    "applicationuserid"})
@JsonInclude(Include.NON_NULL)
public class Applicationuserrole extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.applicationuserrole";
    }

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("componentidunique")
    protected String componentidunique;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("roleid")
    protected String roleid;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("applicationuserroleid")
    protected String applicationuserroleid;

    @JsonProperty("applicationuserid")
    protected String applicationuserid;

    protected Applicationuserrole() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderApplicationuserrole() {
        return new Builder();
    }

    public static final class Builder {
        private Integer componentstate;
        private BooleanManagedProperty iscustomizable;
        private String componentidunique;
        private Long versionnumber;
        private String roleid;
        private Boolean ismanaged;
        private String solutionid;
        private OffsetDateTime overwritetime;
        private String applicationuserroleid;
        private String applicationuserid;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder componentidunique(String componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder roleid(String roleid) {
            this.roleid = roleid;
            this.changedFields = changedFields.add("roleid");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder applicationuserroleid(String applicationuserroleid) {
            this.applicationuserroleid = applicationuserroleid;
            this.changedFields = changedFields.add("applicationuserroleid");
            return this;
        }

        public Builder applicationuserid(String applicationuserid) {
            this.applicationuserid = applicationuserid;
            this.changedFields = changedFields.add("applicationuserid");
            return this;
        }

        public Applicationuserrole build() {
            Applicationuserrole _x = new Applicationuserrole();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.applicationuserrole";
            _x.componentstate = componentstate;
            _x.iscustomizable = iscustomizable;
            _x.componentidunique = componentidunique;
            _x.versionnumber = versionnumber;
            _x.roleid = roleid;
            _x.ismanaged = ismanaged;
            _x.solutionid = solutionid;
            _x.overwritetime = overwritetime;
            _x.applicationuserroleid = applicationuserroleid;
            _x.applicationuserid = applicationuserid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && applicationuserroleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(applicationuserroleid.toString()));
        }
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Applicationuserrole withComponentstate(Integer componentstate) {
        Applicationuserrole _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuserrole");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Applicationuserrole withIscustomizable(BooleanManagedProperty iscustomizable) {
        Applicationuserrole _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuserrole");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<String> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Applicationuserrole withComponentidunique(String componentidunique) {
        Applicationuserrole _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuserrole");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Applicationuserrole withVersionnumber(Long versionnumber) {
        Applicationuserrole _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuserrole");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="roleid")
    @JsonIgnore
    public Optional<String> getRoleid() {
        return Optional.ofNullable(roleid);
    }

    public Applicationuserrole withRoleid(String roleid) {
        Applicationuserrole _x = _copy();
        _x.changedFields = changedFields.add("roleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuserrole");
        _x.roleid = roleid;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Applicationuserrole withIsmanaged(Boolean ismanaged) {
        Applicationuserrole _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuserrole");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Applicationuserrole withSolutionid(String solutionid) {
        Applicationuserrole _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuserrole");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Applicationuserrole withOverwritetime(OffsetDateTime overwritetime) {
        Applicationuserrole _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuserrole");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="applicationuserroleid")
    @JsonIgnore
    public Optional<String> getApplicationuserroleid() {
        return Optional.ofNullable(applicationuserroleid);
    }

    public Applicationuserrole withApplicationuserroleid(String applicationuserroleid) {
        Applicationuserrole _x = _copy();
        _x.changedFields = changedFields.add("applicationuserroleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuserrole");
        _x.applicationuserroleid = applicationuserroleid;
        return _x;
    }

    @Property(name="applicationuserid")
    @JsonIgnore
    public Optional<String> getApplicationuserid() {
        return Optional.ofNullable(applicationuserid);
    }

    public Applicationuserrole withApplicationuserid(String applicationuserid) {
        Applicationuserrole _x = _copy();
        _x.changedFields = changedFields.add("applicationuserid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.applicationuserrole");
        _x.applicationuserid = applicationuserid;
        return _x;
    }

    public Applicationuserrole withUnmappedField(String name, String value) {
        Applicationuserrole _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Applicationuserrole patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Applicationuserrole _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Applicationuserrole put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Applicationuserrole _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Applicationuserrole _copy() {
        Applicationuserrole _x = new Applicationuserrole();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentstate = componentstate;
        _x.iscustomizable = iscustomizable;
        _x.componentidunique = componentidunique;
        _x.versionnumber = versionnumber;
        _x.roleid = roleid;
        _x.ismanaged = ismanaged;
        _x.solutionid = solutionid;
        _x.overwritetime = overwritetime;
        _x.applicationuserroleid = applicationuserroleid;
        _x.applicationuserid = applicationuserid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Applicationuserrole[");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("roleid=");
        b.append(this.roleid);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("applicationuserroleid=");
        b.append(this.applicationuserroleid);
        b.append(", ");
        b.append("applicationuserid=");
        b.append(this.applicationuserid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
