package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.enums.StageSolutionStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "StageSolutionUploadId", 
    "SolutionComponentsDetails", 
    "SolutionDetails", 
    "MissingDependencies", 
    "StageSolutionStatus", 
    "SolutionValidationResults"})
@JsonInclude(Include.NON_NULL)
public class StageSolutionResults implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("StageSolutionUploadId")
    protected String stageSolutionUploadId;

    @JsonProperty("SolutionComponentsDetails")
    protected List<SolutionComponentDetails> solutionComponentsDetails;

    @JsonProperty("SolutionComponentsDetails@nextLink")
    protected String solutionComponentsDetailsNextLink;

    @JsonProperty("SolutionDetails")
    protected SolutionDetails solutionDetails;

    @JsonProperty("MissingDependencies")
    protected List<MissingDependency> missingDependencies;

    @JsonProperty("MissingDependencies@nextLink")
    protected String missingDependenciesNextLink;

    @JsonProperty("StageSolutionStatus")
    protected StageSolutionStatus stageSolutionStatus;

    @JsonProperty("SolutionValidationResults")
    protected List<SolutionValidationResult> solutionValidationResults;

    @JsonProperty("SolutionValidationResults@nextLink")
    protected String solutionValidationResultsNextLink;

    protected StageSolutionResults() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.StageSolutionResults";
    }

    @Property(name="StageSolutionUploadId")
    @JsonIgnore
    public Optional<String> getStageSolutionUploadId() {
        return Optional.ofNullable(stageSolutionUploadId);
    }

    public StageSolutionResults withStageSolutionUploadId(String stageSolutionUploadId) {
        StageSolutionResults _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.StageSolutionResults");
        _x.stageSolutionUploadId = stageSolutionUploadId;
        return _x;
    }

    @Property(name="SolutionComponentsDetails")
    @JsonIgnore
    public CollectionPage<SolutionComponentDetails> getSolutionComponentsDetails() {
        return new CollectionPage<SolutionComponentDetails>(contextPath, SolutionComponentDetails.class, this.solutionComponentsDetails, Optional.ofNullable(solutionComponentsDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="SolutionComponentsDetails")
    @JsonIgnore
    public CollectionPage<SolutionComponentDetails> getSolutionComponentsDetails(HttpRequestOptions options) {
        return new CollectionPage<SolutionComponentDetails>(contextPath, SolutionComponentDetails.class, this.solutionComponentsDetails, Optional.ofNullable(solutionComponentsDetailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="SolutionDetails")
    @JsonIgnore
    public Optional<SolutionDetails> getSolutionDetails() {
        return Optional.ofNullable(solutionDetails);
    }

    public StageSolutionResults withSolutionDetails(SolutionDetails solutionDetails) {
        StageSolutionResults _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.StageSolutionResults");
        _x.solutionDetails = solutionDetails;
        return _x;
    }

    @Property(name="MissingDependencies")
    @JsonIgnore
    public CollectionPage<MissingDependency> getMissingDependencies() {
        return new CollectionPage<MissingDependency>(contextPath, MissingDependency.class, this.missingDependencies, Optional.ofNullable(missingDependenciesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="MissingDependencies")
    @JsonIgnore
    public CollectionPage<MissingDependency> getMissingDependencies(HttpRequestOptions options) {
        return new CollectionPage<MissingDependency>(contextPath, MissingDependency.class, this.missingDependencies, Optional.ofNullable(missingDependenciesNextLink), Collections.emptyList(), options);
    }

    @Property(name="StageSolutionStatus")
    @JsonIgnore
    public Optional<StageSolutionStatus> getStageSolutionStatus() {
        return Optional.ofNullable(stageSolutionStatus);
    }

    public StageSolutionResults withStageSolutionStatus(StageSolutionStatus stageSolutionStatus) {
        StageSolutionResults _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.StageSolutionResults");
        _x.stageSolutionStatus = stageSolutionStatus;
        return _x;
    }

    @Property(name="SolutionValidationResults")
    @JsonIgnore
    public CollectionPage<SolutionValidationResult> getSolutionValidationResults() {
        return new CollectionPage<SolutionValidationResult>(contextPath, SolutionValidationResult.class, this.solutionValidationResults, Optional.ofNullable(solutionValidationResultsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="SolutionValidationResults")
    @JsonIgnore
    public CollectionPage<SolutionValidationResult> getSolutionValidationResults(HttpRequestOptions options) {
        return new CollectionPage<SolutionValidationResult>(contextPath, SolutionValidationResult.class, this.solutionValidationResults, Optional.ofNullable(solutionValidationResultsNextLink), Collections.emptyList(), options);
    }

    public StageSolutionResults withUnmappedField(String name, String value) {
        StageSolutionResults _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String stageSolutionUploadId;
        private List<SolutionComponentDetails> solutionComponentsDetails;
        private String solutionComponentsDetailsNextLink;
        private SolutionDetails solutionDetails;
        private List<MissingDependency> missingDependencies;
        private String missingDependenciesNextLink;
        private StageSolutionStatus stageSolutionStatus;
        private List<SolutionValidationResult> solutionValidationResults;
        private String solutionValidationResultsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder stageSolutionUploadId(String stageSolutionUploadId) {
            this.stageSolutionUploadId = stageSolutionUploadId;
            this.changedFields = changedFields.add("StageSolutionUploadId");
            return this;
        }

        public Builder solutionComponentsDetails(List<SolutionComponentDetails> solutionComponentsDetails) {
            this.solutionComponentsDetails = solutionComponentsDetails;
            this.changedFields = changedFields.add("SolutionComponentsDetails");
            return this;
        }

        public Builder solutionComponentsDetails(SolutionComponentDetails... solutionComponentsDetails) {
            return solutionComponentsDetails(Arrays.asList(solutionComponentsDetails));
        }

        public Builder solutionComponentsDetailsNextLink(String solutionComponentsDetailsNextLink) {
            this.solutionComponentsDetailsNextLink = solutionComponentsDetailsNextLink;
            this.changedFields = changedFields.add("SolutionComponentsDetails");
            return this;
        }

        public Builder solutionDetails(SolutionDetails solutionDetails) {
            this.solutionDetails = solutionDetails;
            this.changedFields = changedFields.add("SolutionDetails");
            return this;
        }

        public Builder missingDependencies(List<MissingDependency> missingDependencies) {
            this.missingDependencies = missingDependencies;
            this.changedFields = changedFields.add("MissingDependencies");
            return this;
        }

        public Builder missingDependencies(MissingDependency... missingDependencies) {
            return missingDependencies(Arrays.asList(missingDependencies));
        }

        public Builder missingDependenciesNextLink(String missingDependenciesNextLink) {
            this.missingDependenciesNextLink = missingDependenciesNextLink;
            this.changedFields = changedFields.add("MissingDependencies");
            return this;
        }

        public Builder stageSolutionStatus(StageSolutionStatus stageSolutionStatus) {
            this.stageSolutionStatus = stageSolutionStatus;
            this.changedFields = changedFields.add("StageSolutionStatus");
            return this;
        }

        public Builder solutionValidationResults(List<SolutionValidationResult> solutionValidationResults) {
            this.solutionValidationResults = solutionValidationResults;
            this.changedFields = changedFields.add("SolutionValidationResults");
            return this;
        }

        public Builder solutionValidationResults(SolutionValidationResult... solutionValidationResults) {
            return solutionValidationResults(Arrays.asList(solutionValidationResults));
        }

        public Builder solutionValidationResultsNextLink(String solutionValidationResultsNextLink) {
            this.solutionValidationResultsNextLink = solutionValidationResultsNextLink;
            this.changedFields = changedFields.add("SolutionValidationResults");
            return this;
        }

        public StageSolutionResults build() {
            StageSolutionResults _x = new StageSolutionResults();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.StageSolutionResults";
            _x.stageSolutionUploadId = stageSolutionUploadId;
            _x.solutionComponentsDetails = solutionComponentsDetails;
            _x.solutionComponentsDetailsNextLink = solutionComponentsDetailsNextLink;
            _x.solutionDetails = solutionDetails;
            _x.missingDependencies = missingDependencies;
            _x.missingDependenciesNextLink = missingDependenciesNextLink;
            _x.stageSolutionStatus = stageSolutionStatus;
            _x.solutionValidationResults = solutionValidationResults;
            _x.solutionValidationResultsNextLink = solutionValidationResultsNextLink;
            return _x;
        }
    }

    private StageSolutionResults _copy() {
        StageSolutionResults _x = new StageSolutionResults();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.stageSolutionUploadId = stageSolutionUploadId;
        _x.solutionComponentsDetails = solutionComponentsDetails;
        _x.solutionDetails = solutionDetails;
        _x.missingDependencies = missingDependencies;
        _x.stageSolutionStatus = stageSolutionStatus;
        _x.solutionValidationResults = solutionValidationResults;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StageSolutionResults[");
        b.append("StageSolutionUploadId=");
        b.append(this.stageSolutionUploadId);
        b.append(", ");
        b.append("SolutionComponentsDetails=");
        b.append(this.solutionComponentsDetails);
        b.append(", ");
        b.append("SolutionDetails=");
        b.append(this.solutionDetails);
        b.append(", ");
        b.append("MissingDependencies=");
        b.append(this.missingDependencies);
        b.append(", ");
        b.append("StageSolutionStatus=");
        b.append(this.stageSolutionStatus);
        b.append(", ");
        b.append("SolutionValidationResults=");
        b.append(this.solutionValidationResults);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
