package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.dynamics.crm.enums.SolutionOperationStatus;
import microsoft.dynamics.crm.enums.SolutionOperationType;

@JsonPropertyOrder({
    "@odata.type", 
    "FormattedResults", 
    "Type", 
    "Status", 
    "WarningMessages", 
    "ErrorMessages"})
@JsonInclude(Include.NON_NULL)
public class SolutionOperationResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("FormattedResults")
    protected String formattedResults;

    @JsonProperty("Type")
    protected SolutionOperationType type;

    @JsonProperty("Status")
    protected SolutionOperationStatus status;

    @JsonProperty("WarningMessages")
    protected List<String> warningMessages;

    @JsonProperty("WarningMessages@nextLink")
    protected String warningMessagesNextLink;

    @JsonProperty("ErrorMessages")
    protected List<String> errorMessages;

    @JsonProperty("ErrorMessages@nextLink")
    protected String errorMessagesNextLink;

    protected SolutionOperationResult() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SolutionOperationResult";
    }

    @Property(name="FormattedResults")
    @JsonIgnore
    public Optional<String> getFormattedResults() {
        return Optional.ofNullable(formattedResults);
    }

    public SolutionOperationResult withFormattedResults(String formattedResults) {
        Checks.checkIsAscii(formattedResults);
        SolutionOperationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionOperationResult");
        _x.formattedResults = formattedResults;
        return _x;
    }

    @Property(name="Type")
    @JsonIgnore
    public Optional<SolutionOperationType> getType() {
        return Optional.ofNullable(type);
    }

    public SolutionOperationResult withType(SolutionOperationType type) {
        SolutionOperationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionOperationResult");
        _x.type = type;
        return _x;
    }

    @Property(name="Status")
    @JsonIgnore
    public Optional<SolutionOperationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public SolutionOperationResult withStatus(SolutionOperationStatus status) {
        SolutionOperationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionOperationResult");
        _x.status = status;
        return _x;
    }

    @Property(name="WarningMessages")
    @JsonIgnore
    public CollectionPage<String> getWarningMessages() {
        return new CollectionPage<String>(contextPath, String.class, this.warningMessages, Optional.ofNullable(warningMessagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="WarningMessages")
    @JsonIgnore
    public CollectionPage<String> getWarningMessages(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.warningMessages, Optional.ofNullable(warningMessagesNextLink), Collections.emptyList(), options);
    }

    @Property(name="ErrorMessages")
    @JsonIgnore
    public CollectionPage<String> getErrorMessages() {
        return new CollectionPage<String>(contextPath, String.class, this.errorMessages, Optional.ofNullable(errorMessagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ErrorMessages")
    @JsonIgnore
    public CollectionPage<String> getErrorMessages(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.errorMessages, Optional.ofNullable(errorMessagesNextLink), Collections.emptyList(), options);
    }

    public SolutionOperationResult withUnmappedField(String name, String value) {
        SolutionOperationResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String formattedResults;
        private SolutionOperationType type;
        private SolutionOperationStatus status;
        private List<String> warningMessages;
        private String warningMessagesNextLink;
        private List<String> errorMessages;
        private String errorMessagesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder formattedResults(String formattedResults) {
            this.formattedResults = formattedResults;
            this.changedFields = changedFields.add("FormattedResults");
            return this;
        }

        public Builder type(SolutionOperationType type) {
            this.type = type;
            this.changedFields = changedFields.add("Type");
            return this;
        }

        public Builder status(SolutionOperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("Status");
            return this;
        }

        public Builder warningMessages(List<String> warningMessages) {
            this.warningMessages = warningMessages;
            this.changedFields = changedFields.add("WarningMessages");
            return this;
        }

        public Builder warningMessages(String... warningMessages) {
            return warningMessages(Arrays.asList(warningMessages));
        }

        public Builder warningMessagesNextLink(String warningMessagesNextLink) {
            this.warningMessagesNextLink = warningMessagesNextLink;
            this.changedFields = changedFields.add("WarningMessages");
            return this;
        }

        public Builder errorMessages(List<String> errorMessages) {
            this.errorMessages = errorMessages;
            this.changedFields = changedFields.add("ErrorMessages");
            return this;
        }

        public Builder errorMessages(String... errorMessages) {
            return errorMessages(Arrays.asList(errorMessages));
        }

        public Builder errorMessagesNextLink(String errorMessagesNextLink) {
            this.errorMessagesNextLink = errorMessagesNextLink;
            this.changedFields = changedFields.add("ErrorMessages");
            return this;
        }

        public SolutionOperationResult build() {
            SolutionOperationResult _x = new SolutionOperationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.SolutionOperationResult";
            _x.formattedResults = formattedResults;
            _x.type = type;
            _x.status = status;
            _x.warningMessages = warningMessages;
            _x.warningMessagesNextLink = warningMessagesNextLink;
            _x.errorMessages = errorMessages;
            _x.errorMessagesNextLink = errorMessagesNextLink;
            return _x;
        }
    }

    private SolutionOperationResult _copy() {
        SolutionOperationResult _x = new SolutionOperationResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.formattedResults = formattedResults;
        _x.type = type;
        _x.status = status;
        _x.warningMessages = warningMessages;
        _x.errorMessages = errorMessages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SolutionOperationResult[");
        b.append("FormattedResults=");
        b.append(this.formattedResults);
        b.append(", ");
        b.append("Type=");
        b.append(this.type);
        b.append(", ");
        b.append("Status=");
        b.append(this.status);
        b.append(", ");
        b.append("WarningMessages=");
        b.append(this.warningMessages);
        b.append(", ");
        b.append("ErrorMessages=");
        b.append(this.errorMessages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
