package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "RetrieveProvisionedLanguages"})
@JsonInclude(Include.NON_NULL)
public class RetrieveProvisionedLanguagesResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("RetrieveProvisionedLanguages")
    protected List<Integer> retrieveProvisionedLanguages;

    @JsonProperty("RetrieveProvisionedLanguages@nextLink")
    protected String retrieveProvisionedLanguagesNextLink;

    protected RetrieveProvisionedLanguagesResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveProvisionedLanguagesResponse";
    }

    @Property(name="RetrieveProvisionedLanguages")
    @JsonIgnore
    public CollectionPage<Integer> getRetrieveProvisionedLanguages() {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.retrieveProvisionedLanguages, Optional.ofNullable(retrieveProvisionedLanguagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="RetrieveProvisionedLanguages")
    @JsonIgnore
    public CollectionPage<Integer> getRetrieveProvisionedLanguages(HttpRequestOptions options) {
        return new CollectionPage<Integer>(contextPath, Integer.class, this.retrieveProvisionedLanguages, Optional.ofNullable(retrieveProvisionedLanguagesNextLink), Collections.emptyList(), options);
    }

    public RetrieveProvisionedLanguagesResponse withUnmappedField(String name, String value) {
        RetrieveProvisionedLanguagesResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Integer> retrieveProvisionedLanguages;
        private String retrieveProvisionedLanguagesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder retrieveProvisionedLanguages(List<Integer> retrieveProvisionedLanguages) {
            this.retrieveProvisionedLanguages = retrieveProvisionedLanguages;
            this.changedFields = changedFields.add("RetrieveProvisionedLanguages");
            return this;
        }

        public Builder retrieveProvisionedLanguages(Integer... retrieveProvisionedLanguages) {
            return retrieveProvisionedLanguages(Arrays.asList(retrieveProvisionedLanguages));
        }

        public Builder retrieveProvisionedLanguagesNextLink(String retrieveProvisionedLanguagesNextLink) {
            this.retrieveProvisionedLanguagesNextLink = retrieveProvisionedLanguagesNextLink;
            this.changedFields = changedFields.add("RetrieveProvisionedLanguages");
            return this;
        }

        public RetrieveProvisionedLanguagesResponse build() {
            RetrieveProvisionedLanguagesResponse _x = new RetrieveProvisionedLanguagesResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveProvisionedLanguagesResponse";
            _x.retrieveProvisionedLanguages = retrieveProvisionedLanguages;
            _x.retrieveProvisionedLanguagesNextLink = retrieveProvisionedLanguagesNextLink;
            return _x;
        }
    }

    private RetrieveProvisionedLanguagesResponse _copy() {
        RetrieveProvisionedLanguagesResponse _x = new RetrieveProvisionedLanguagesResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.retrieveProvisionedLanguages = retrieveProvisionedLanguages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveProvisionedLanguagesResponse[");
        b.append("RetrieveProvisionedLanguages=");
        b.append(this.retrieveProvisionedLanguages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
