package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.enums.OrderType;

@JsonPropertyOrder({
    "@odata.type", 
    "AttributeName", 
    "OrderType", 
    "Alias"})
@JsonInclude(Include.NON_NULL)
public class OrderExpression implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AttributeName")
    protected String attributeName;

    @JsonProperty("OrderType")
    protected OrderType orderType;

    @JsonProperty("Alias")
    protected String alias;

    protected OrderExpression() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.OrderExpression";
    }

    @Property(name="AttributeName")
    @JsonIgnore
    public Optional<String> getAttributeName() {
        return Optional.ofNullable(attributeName);
    }

    public OrderExpression withAttributeName(String attributeName) {
        Checks.checkIsAscii(attributeName);
        OrderExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrderExpression");
        _x.attributeName = attributeName;
        return _x;
    }

    @Property(name="OrderType")
    @JsonIgnore
    public Optional<OrderType> getOrderType() {
        return Optional.ofNullable(orderType);
    }

    public OrderExpression withOrderType(OrderType orderType) {
        OrderExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrderExpression");
        _x.orderType = orderType;
        return _x;
    }

    @Property(name="Alias")
    @JsonIgnore
    public Optional<String> getAlias() {
        return Optional.ofNullable(alias);
    }

    public OrderExpression withAlias(String alias) {
        Checks.checkIsAscii(alias);
        OrderExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrderExpression");
        _x.alias = alias;
        return _x;
    }

    public OrderExpression withUnmappedField(String name, String value) {
        OrderExpression _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String attributeName;
        private OrderType orderType;
        private String alias;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            this.changedFields = changedFields.add("AttributeName");
            return this;
        }

        public Builder orderType(OrderType orderType) {
            this.orderType = orderType;
            this.changedFields = changedFields.add("OrderType");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.changedFields = changedFields.add("Alias");
            return this;
        }

        public OrderExpression build() {
            OrderExpression _x = new OrderExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.OrderExpression";
            _x.attributeName = attributeName;
            _x.orderType = orderType;
            _x.alias = alias;
            return _x;
        }
    }

    private OrderExpression _copy() {
        OrderExpression _x = new OrderExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.attributeName = attributeName;
        _x.orderType = orderType;
        _x.alias = alias;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrderExpression[");
        b.append("AttributeName=");
        b.append(this.attributeName);
        b.append(", ");
        b.append("OrderType=");
        b.append(this.orderType);
        b.append(", ");
        b.append("Alias=");
        b.append(this.alias);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
