package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "FileName", 
    "FileSizeInBytes", 
    "FileContinuationToken"})
@JsonInclude(Include.NON_NULL)
public class InitializeAttachmentBlocksDownloadResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("FileName")
    protected String fileName;

    @JsonProperty("FileSizeInBytes")
    protected Integer fileSizeInBytes;

    @JsonProperty("FileContinuationToken")
    protected String fileContinuationToken;

    protected InitializeAttachmentBlocksDownloadResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.InitializeAttachmentBlocksDownloadResponse";
    }

    @Property(name="FileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    public InitializeAttachmentBlocksDownloadResponse withFileName(String fileName) {
        Checks.checkIsAscii(fileName);
        InitializeAttachmentBlocksDownloadResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.InitializeAttachmentBlocksDownloadResponse");
        _x.fileName = fileName;
        return _x;
    }

    @Property(name="FileSizeInBytes")
    @JsonIgnore
    public Optional<Integer> getFileSizeInBytes() {
        return Optional.ofNullable(fileSizeInBytes);
    }

    public InitializeAttachmentBlocksDownloadResponse withFileSizeInBytes(Integer fileSizeInBytes) {
        InitializeAttachmentBlocksDownloadResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.InitializeAttachmentBlocksDownloadResponse");
        _x.fileSizeInBytes = fileSizeInBytes;
        return _x;
    }

    @Property(name="FileContinuationToken")
    @JsonIgnore
    public Optional<String> getFileContinuationToken() {
        return Optional.ofNullable(fileContinuationToken);
    }

    public InitializeAttachmentBlocksDownloadResponse withFileContinuationToken(String fileContinuationToken) {
        Checks.checkIsAscii(fileContinuationToken);
        InitializeAttachmentBlocksDownloadResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.InitializeAttachmentBlocksDownloadResponse");
        _x.fileContinuationToken = fileContinuationToken;
        return _x;
    }

    public InitializeAttachmentBlocksDownloadResponse withUnmappedField(String name, String value) {
        InitializeAttachmentBlocksDownloadResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String fileName;
        private Integer fileSizeInBytes;
        private String fileContinuationToken;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("FileName");
            return this;
        }

        public Builder fileSizeInBytes(Integer fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            this.changedFields = changedFields.add("FileSizeInBytes");
            return this;
        }

        public Builder fileContinuationToken(String fileContinuationToken) {
            this.fileContinuationToken = fileContinuationToken;
            this.changedFields = changedFields.add("FileContinuationToken");
            return this;
        }

        public InitializeAttachmentBlocksDownloadResponse build() {
            InitializeAttachmentBlocksDownloadResponse _x = new InitializeAttachmentBlocksDownloadResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.InitializeAttachmentBlocksDownloadResponse";
            _x.fileName = fileName;
            _x.fileSizeInBytes = fileSizeInBytes;
            _x.fileContinuationToken = fileContinuationToken;
            return _x;
        }
    }

    private InitializeAttachmentBlocksDownloadResponse _copy() {
        InitializeAttachmentBlocksDownloadResponse _x = new InitializeAttachmentBlocksDownloadResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.fileName = fileName;
        _x.fileSizeInBytes = fileSizeInBytes;
        _x.fileContinuationToken = fileContinuationToken;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InitializeAttachmentBlocksDownloadResponse[");
        b.append("FileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("FileSizeInBytes=");
        b.append(this.fileSizeInBytes);
        b.append(", ");
        b.append("FileContinuationToken=");
        b.append(this.fileContinuationToken);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
