package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "DependantEntities"})
@JsonInclude(Include.NON_NULL)
public class DependentEntityMetadataCollection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("DependantEntities")
    protected List<DependentEntityMetadata> dependantEntities;

    @JsonProperty("DependantEntities@nextLink")
    protected String dependantEntitiesNextLink;

    protected DependentEntityMetadataCollection() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DependentEntityMetadataCollection";
    }

    @Property(name="DependantEntities")
    @JsonIgnore
    public CollectionPage<DependentEntityMetadata> getDependantEntities() {
        return new CollectionPage<DependentEntityMetadata>(contextPath, DependentEntityMetadata.class, this.dependantEntities, Optional.ofNullable(dependantEntitiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="DependantEntities")
    @JsonIgnore
    public CollectionPage<DependentEntityMetadata> getDependantEntities(HttpRequestOptions options) {
        return new CollectionPage<DependentEntityMetadata>(contextPath, DependentEntityMetadata.class, this.dependantEntities, Optional.ofNullable(dependantEntitiesNextLink), Collections.emptyList(), options);
    }

    public DependentEntityMetadataCollection withUnmappedField(String name, String value) {
        DependentEntityMetadataCollection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DependentEntityMetadata> dependantEntities;
        private String dependantEntitiesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder dependantEntities(List<DependentEntityMetadata> dependantEntities) {
            this.dependantEntities = dependantEntities;
            this.changedFields = changedFields.add("DependantEntities");
            return this;
        }

        public Builder dependantEntities(DependentEntityMetadata... dependantEntities) {
            return dependantEntities(Arrays.asList(dependantEntities));
        }

        public Builder dependantEntitiesNextLink(String dependantEntitiesNextLink) {
            this.dependantEntitiesNextLink = dependantEntitiesNextLink;
            this.changedFields = changedFields.add("DependantEntities");
            return this;
        }

        public DependentEntityMetadataCollection build() {
            DependentEntityMetadataCollection _x = new DependentEntityMetadataCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DependentEntityMetadataCollection";
            _x.dependantEntities = dependantEntities;
            _x.dependantEntitiesNextLink = dependantEntitiesNextLink;
            return _x;
        }
    }

    private DependentEntityMetadataCollection _copy() {
        DependentEntityMetadataCollection _x = new DependentEntityMetadataCollection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dependantEntities = dependantEntities;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DependentEntityMetadataCollection[");
        b.append("DependantEntities=");
        b.append(this.dependantEntities);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
