package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "DependentAttributes"})
@JsonInclude(Include.NON_NULL)
public class DependentAttributeMetadataCollection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("DependentAttributes")
    protected List<DependentAttributeMetadata> dependentAttributes;

    @JsonProperty("DependentAttributes@nextLink")
    protected String dependentAttributesNextLink;

    protected DependentAttributeMetadataCollection() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DependentAttributeMetadataCollection";
    }

    @Property(name="DependentAttributes")
    @JsonIgnore
    public CollectionPage<DependentAttributeMetadata> getDependentAttributes() {
        return new CollectionPage<DependentAttributeMetadata>(contextPath, DependentAttributeMetadata.class, this.dependentAttributes, Optional.ofNullable(dependentAttributesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="DependentAttributes")
    @JsonIgnore
    public CollectionPage<DependentAttributeMetadata> getDependentAttributes(HttpRequestOptions options) {
        return new CollectionPage<DependentAttributeMetadata>(contextPath, DependentAttributeMetadata.class, this.dependentAttributes, Optional.ofNullable(dependentAttributesNextLink), Collections.emptyList(), options);
    }

    public DependentAttributeMetadataCollection withUnmappedField(String name, String value) {
        DependentAttributeMetadataCollection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DependentAttributeMetadata> dependentAttributes;
        private String dependentAttributesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder dependentAttributes(List<DependentAttributeMetadata> dependentAttributes) {
            this.dependentAttributes = dependentAttributes;
            this.changedFields = changedFields.add("DependentAttributes");
            return this;
        }

        public Builder dependentAttributes(DependentAttributeMetadata... dependentAttributes) {
            return dependentAttributes(Arrays.asList(dependentAttributes));
        }

        public Builder dependentAttributesNextLink(String dependentAttributesNextLink) {
            this.dependentAttributesNextLink = dependentAttributesNextLink;
            this.changedFields = changedFields.add("DependentAttributes");
            return this;
        }

        public DependentAttributeMetadataCollection build() {
            DependentAttributeMetadataCollection _x = new DependentAttributeMetadataCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DependentAttributeMetadataCollection";
            _x.dependentAttributes = dependentAttributes;
            _x.dependentAttributesNextLink = dependentAttributesNextLink;
            return _x;
        }
    }

    private DependentAttributeMetadataCollection _copy() {
        DependentAttributeMetadataCollection _x = new DependentAttributeMetadataCollection();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.dependentAttributes = dependentAttributes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DependentAttributeMetadataCollection[");
        b.append("DependentAttributes=");
        b.append(this.dependentAttributes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
